/**
 * @file CcaIncomingCallRejectedEventHandler.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaIncomingCallRejectedEventHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#ifndef CcaIncomingCallRejectedEventHandler_h
#define CcaIncomingCallRejectedEventHandler_h

#include "CcaProperty.h"

/*
 * Handler class for CCA property - MOST_TELFI_C_U16_INCOMINGCALLREJECTEDEVENT
 */
class CcaIncomingCallRejectedEventHandler final: public CcaProperty
{

public:

   /**
    * Constructor of CcaIncomingCallRejectedEventHandler class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   CcaIncomingCallRejectedEventHandler(ahl_tclBaseOneThreadService* pAhlService);

   /**
    * Destructor of CcaIncomingCallRejectedEventHandler class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual ~CcaIncomingCallRejectedEventHandler()
   {

   }

protected:

   /**
    * Actual processing of the CCA message takes place here and forward
    * request to IpcWrapper. From IpcWrapper request is posted to PM CORE CPP.
    * This method is invoked when client does a GET on PmApp CCA property
    *
    * @param[in] amt_tclServiceData* - Pointer to the CCA message data
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onOpcodeGet(amt_tclServiceData* pInMsg, const pmcore::ActType act) override;

   /**
    * Actual processing of the CCA message takes place here and forward
    * request to IpcWrapper. From IpcWrapper request is posted to PM CORE CPP
    * This method is invoked when client does a SET on PmApp CCA property
    *
    * @param[in] amt_tclServiceData* - Pointer to the CCA message data
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onOpcodeSet(amt_tclServiceData* pInMsg, const pmcore::ActType act) override;

   /**
    * PM shall update clients on the property updates received from CPP interfaces.
    *
    * @param[in] PropertyUpdate* - pointer to the property update data
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onPropertyUpdate(PropertyUpdate* pPropertyUpdate) override;

   /**
    * Overridden from the CcaProperty class
    *
    * @param[in]  PmCoreResponseData* - Pointer to the response data from CPP layer
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void processOpcodeSetError(PmCoreResponseData* pInMsg) override;

   /**
    * Overridden from CcaProperty class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   template<typename TPropertyType>
   void dispatchProperty(TPropertyType* propertyUpdate);

   /**
    * Overridden from CcaProperty class
    *
    * @param[in] PmCoreResponseData* responseMsg - cpp respone received from PM Core
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void processOpcodeGetResponse(PmCoreResponseData* responseMsg) override;
};

#endif // CcaIncomingCallRejectedEventHandler_h
