/**
 * @file CcaSwapCallReqHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaSwapCallReqHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaSwapCallReqHandler.h"
#include "IpcWrapper.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaSwapCallReqHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaSwapCallReqHandler::CcaSwapCallReqHandler(ahl_tclBaseOneThreadService* pService) : CcaMethod(pService)
{
   ETG_TRACE_USR4(("CcaSwapCallReqHandler::CcaSwapCallReqHandler entered"));
}

void CcaSwapCallReqHandler::onMethodStart(amt_tclServiceData* pInMsg, tU64 ccaToken)
{
   ETG_TRACE_USR4(("CcaSwapCallReqHandler::onMethodStart entered"));

   most_telfi_tclMsgSwapCallMethodStart swapCallMsg;

   getDataFromAmt(pInMsg, swapCallMsg);

   ETG_TRACE_USR4(("No of CallInstances:: %d", swapCallMsg.oStreamOfCallInstances.u16Items.size()));

   for(tU16 u16Index = 0; u16Index < swapCallMsg.oStreamOfCallInstances.u16Items.size(); u16Index++)
   {
      ETG_TRACE_USR4(("CallInstance[%d]:: %d", u16Index, swapCallMsg.oStreamOfCallInstances.u16Items[u16Index]));
   }

   SwapOperation operation = SWAP_CALLS;

   BdAddress deviceAddress = "";
   ::com::bosch::pmapp::DeviceDetailsListHandler::getInstance().getActiveDeviceAddress(deviceAddress);

   PmResult pmresult = pm_ipc_wrapper::IpcWrapper::getInstance().postSwapCallRequest2PmCore(deviceAddress, operation, ccaToken);
   handlePmResult(pmresult, ccaToken);

   swapCallMsg.vDestroy();
}

void CcaSwapCallReqHandler::processMethodResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaSwapCallReqHandler::processMethodResponse entered"));
   SwapCallResponseMsg* swapCallResponseMsg = static_cast<SwapCallResponseMsg*> (responseMsg);

   ETG_TRACE_USR4(("swapCallResponseMsg->_u64TokenId : %u", swapCallResponseMsg->_u64TokenId));

   if(PM_RESULT_OK == swapCallResponseMsg->_pmResult._pmResultCode)
   {
      most_telfi_tclMsgSwapCallMethodResult oSwapCallMR;

//      oSwapCallMR.u16CallInstance = rfpCallInstance->m_u16Id ;
//      oSwapCallMR.e8CallStatus.enType = (most_fi_tcl_e8_TelCallStatus::tenType)rfpCallInstance->m_u16CallStatusNotice;

      sendMethodResult(swapCallResponseMsg->_u64TokenId, oSwapCallMR);
      oSwapCallMR.vDestroy();
   }
   else
   {
      ETG_TRACE_ERR(("CcaSwapCallReqHandler::processMethodResponse - Error response for swap request"));

      // The error message is populated just as in legacy phone component to maintain uniformity.
      sendMethodError(swapCallResponseMsg->_u64TokenId, most_fi_tcl_e8_ErrorCode::FI_EN_NOTAVAILABLE);
   }
}
