/**
 * @file CcaStopRingtoneReqHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaStopRingtoneReqHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaStopRingtoneReqHandler.h"
#include "IpcWrapper.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaStopRingtoneReqHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaStopRingtoneReqHandler::CcaStopRingtoneReqHandler(ahl_tclBaseOneThreadService* pService) : CcaMethod(pService)
{
   ETG_TRACE_USR4(("CcaStopRingtoneReqHandler::CcaStopRingtoneReqHandler entered"));
}

void CcaStopRingtoneReqHandler::onMethodStart(amt_tclServiceData* pInMsg, tU64 ccaToken)
{
   ETG_TRACE_USR4(("CcaStopRingtoneReqHandler::onMethodStart entered"));

   most_telfi_tclMsgStopRingtoneMethodStart stopRingtoneMsg;

   getDataFromAmt(pInMsg, stopRingtoneMsg);

   PmResult pmResult = pm_ipc_wrapper::IpcWrapper::getInstance().postStopRingtoneRequest2PmCore(ccaToken);

   handlePmResult(pmResult, ccaToken);
   stopRingtoneMsg.vDestroy();
}

void CcaStopRingtoneReqHandler::processMethodResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaStopRingtoneReqHandler::processMethodResponse entered"));

   PmCoreResponseData* stopRingtoneResponseMsg = static_cast<PmCoreResponseData*> (responseMsg);

   ETG_TRACE_USR4(("stopRingtoneResponseMsg->_u64TokenId : %u", stopRingtoneResponseMsg->_u64TokenId));

   if(PM_RESULT_OK == stopRingtoneResponseMsg->_pmResult._pmResultCode)
   {
      most_telfi_tclMsgStopRingtoneMethodResult stopRingtoneMethodResult;
      sendMethodResult(stopRingtoneResponseMsg->_u64TokenId, stopRingtoneMethodResult);
      stopRingtoneMethodResult.vDestroy();
   }
   else
   {
      ETG_TRACE_ERR(("CcaStopRingtoneReqHandler::processMethodResponse - Error response for stop ringtone request"));

      // The error message is populated just as in legacy phone component to maintain uniformity.
      sendMethodError(stopRingtoneResponseMsg->_u64TokenId, most_fi_tcl_e8_ErrorCode::FI_EN_NOTAVAILABLE);
   }
}
