/**
 * @file CcaSpeedDialReqHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaSpeedDialReqHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaSpeedDialReqHandler.h"
#include "IpcWrapper.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaSpeedDialReqHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaSpeedDialReqHandler::CcaSpeedDialReqHandler(ahl_tclBaseOneThreadService* pService) : CcaMethod(pService)
{
   ETG_TRACE_USR4(("CcaSpeedDialReqHandler::CcaSpeedDialReqHandler entered"));
}

void CcaSpeedDialReqHandler::onMethodStart(amt_tclServiceData* pInMsg, tU64 ccaToken)
{
   ETG_TRACE_USR4(("CcaSpeedDialReqHandler::onMethodStart entered"));

   most_telfi_tclMsgSpeedDialMethodStart speedDialMsg;

   getDataFromAmt(pInMsg, speedDialMsg);

   MemDialIndex memDialIndex = speedDialMsg.s8MemoryDialParam;
   ETG_TRACE_USR4(("CcaSpeedDialReqHandler::onMethodStart MemoryDialParam : %u", memDialIndex));

   BdAddress deviceAddress = "";
   ::com::bosch::pmapp::DeviceDetailsListHandler::getInstance().getActiveDeviceAddress(deviceAddress);

   PmResult pmresult = pm_ipc_wrapper::IpcWrapper::getInstance().postSpeedDialRequest2PmCore(deviceAddress,
         memDialIndex, DEFAULT_CALLERID, ccaToken);

   handlePmResult(pmresult, ccaToken);

   speedDialMsg.vDestroy();
}

void CcaSpeedDialReqHandler::processMethodResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaSpeedDialReqHandler::processMethodResponse entered"));

   SpeedDialResponseMsg* speedDialResponseMsg = static_cast<SpeedDialResponseMsg*> (responseMsg);

   ETG_TRACE_USR4(("speedDialResponseMsg->_u64TokenId : %u", speedDialResponseMsg->_u64TokenId));

   if(PM_RESULT_OK == speedDialResponseMsg->_pmResult._pmResultCode)
   {
      most_telfi_tclMsgSpeedDialMethodResult oSpeedDialMR;

//      oSpeedDialMR.u16CallInstance = rfpCallInstance->m_u16Id;
//      oSpeedDialMR.e8CallStatus.enType = (most_fi_tcl_e8_TelCallStatus::tenType)rfpCallInstance->m_u16CallStatusNotice;
//      oSpeedDialMR.bUsingVehicleAudio = rfpCallInstance->m_bUsingVehicleAudio;

      sendMethodResult(speedDialResponseMsg->_u64TokenId, oSpeedDialMR);
      oSpeedDialMR.vDestroy();
   }
   else
   {
      ETG_TRACE_ERR(("CcaSpeedDialReqHandler::processMethodResponse - Error for SpeedDial request"));

      // The error message is populated just as in legacy phone component to maintain uniformity.
      sendMethodError(speedDialResponseMsg->_u64TokenId, most_fi_tcl_e8_ErrorCode::FI_EN_NOTAVAILABLE);
   }
}
