/**
 * @file CcaSetActivePhoneReqHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaSetActivePhoneReqHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaSetActivePhoneReqHandler.h"
#include "IpcWrapper.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaSetActivePhoneReqHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaSetActivePhoneReqHandler::CcaSetActivePhoneReqHandler(ahl_tclBaseOneThreadService* pService) : CcaMethod(pService)
{
   ETG_TRACE_USR4(("CcaSetActivePhoneReqHandler::CcaSetActivePhoneReqHandler entered"));
}

void CcaSetActivePhoneReqHandler::onMethodStart(amt_tclServiceData* pInMsg, tU64 ccaToken)
{
   ETG_TRACE_USR4(("CcaSetActivePhoneReqHandler::onMethodStart entered"));

   most_telfi_tclMsgSetActivePhoneMethodStart setActivePhoneMsg;

   getDataFromAmt(pInMsg, setActivePhoneMsg);

   DeviceHandle deviceHandle = setActivePhoneMsg.u8DeviceHandle;
   ETG_TRACE_USR4(("CcaSetActivePhoneReqHandler::onMethodStart DeviceHandle : %d", deviceHandle));

   BdAddress deviceAddress = "";
   ::com::bosch::pmapp::DeviceDetailsListHandler::getInstance().getDeviceAddress(deviceHandle, deviceAddress);

   PmResult pmresult;
   BdAddressList deviceAddressList;

   deviceAddressList.push_back(deviceAddress);
   pmresult = pm_ipc_wrapper::IpcWrapper::getInstance().postSetActivePhoneRequest2PmCore(deviceAddressList, ccaToken);

   handlePmResult(pmresult, ccaToken);

   setActivePhoneMsg.vDestroy();
}

void CcaSetActivePhoneReqHandler::processMethodResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaSetActivePhoneReqHandler::processMethodResponse entered"));

   PmCoreResponseData* setActivePhoneResponseMsg = static_cast<PmCoreResponseData*> (responseMsg);

   ETG_TRACE_USR4(("setActivePhoneResponseMsg->_u64TokenId : %u", setActivePhoneResponseMsg->_u64TokenId));

   if(PM_RESULT_OK == setActivePhoneResponseMsg->_pmResult._pmResultCode)
   {
      most_telfi_tclMsgSetActivePhoneMethodResult oSetActivePhoneMR;
      sendMethodResult(setActivePhoneResponseMsg->_u64TokenId, oSetActivePhoneMR);
      oSetActivePhoneMR.vDestroy();
   }
   else
   {
      ETG_TRACE_ERR(("CcaSetActivePhoneReqHandler::processMethodResponse - Error for SetActivePhone request"));

      // The error message is populated just as in legacy phone component to maintain uniformity.
      sendMethodError(setActivePhoneResponseMsg->_u64TokenId, most_fi_tcl_e8_ErrorCode::FI_EN_NOTAVAILABLE);
   }
}
