/**
 * @file CcaResumeCallReqHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaResumeCallReqHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaResumeCallReqHandler.h"
#include "IpcWrapper.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaResumeCallReqHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaResumeCallReqHandler::CcaResumeCallReqHandler(ahl_tclBaseOneThreadService* pService) : CcaMethod(pService)
{
   ETG_TRACE_USR4(("CcaResumeCallReqHandler::CcaResumeCallReqHandler entered"));
}

void CcaResumeCallReqHandler::onMethodStart(amt_tclServiceData* pInMsg, tU64 ccaToken)
{
   ETG_TRACE_USR4(("CcaResumeCallReqHandler::onMethodStart entered"));

   most_telfi_tclMsgResumeCallMethodStart resumeCallMsg;

   getDataFromAmt(pInMsg, resumeCallMsg);

   ETG_TRACE_USR4(("CcaResumeCallReqHandler::onMethodStart CallInstance : %d", resumeCallMsg.u16CallInstance));

   SwapOperation operation = SWAP_CALLS;

   BdAddress deviceAddress = "";
   ::com::bosch::pmapp::DeviceDetailsListHandler::getInstance().getActiveDeviceAddress(deviceAddress);

   PmResult pmresult = pm_ipc_wrapper::IpcWrapper::getInstance().postSwapCallRequest2PmCore(deviceAddress, operation, ccaToken);
   handlePmResult(pmresult, ccaToken);

   resumeCallMsg.vDestroy();
}

void CcaResumeCallReqHandler::processMethodResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaResumeCallReqHandler::processMethodResponse entered"));

   SwapCallResponseMsg* resumeCallResponseMsg = static_cast<SwapCallResponseMsg*> (responseMsg);

   ETG_TRACE_USR4(("resumeCallResponseMsg->_u64TokenId : %u", resumeCallResponseMsg->_u64TokenId));

   if(PM_RESULT_OK == resumeCallResponseMsg->_pmResult._pmResultCode)
   {
      most_telfi_tclMsgResumeCallMethodResult oResumeCallMR;

//      oResumeCallMR.u16CallInstance = rfpCallInstance->m_u16Id ;
//      oResumeCallMR.e8CallStatus.enType = (most_fi_tcl_e8_TelCallStatus::tenType)rfpCallInstance->m_u16CallStatusNotice;
//      oResumeCallMR.bUsingVehicleAudio = rfpCallInstance->m_bUsingVehicleAudio;

      sendMethodResult(resumeCallResponseMsg->_u64TokenId, oResumeCallMR);
      oResumeCallMR.vDestroy();
   }
   else
   {
      ETG_TRACE_ERR(("CcaResumeCallReqHandler::processMethodResponse - Error response for resumecall request"));

      // The error message is populated just as in legacy phone component to maintain uniformity.
      sendMethodError(resumeCallResponseMsg->_u64TokenId, most_fi_tcl_e8_ErrorCode::FI_EN_NOTAVAILABLE);
   }
}
