/**
 * @file CcaRedialReqHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaRedialReqHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaRedialReqHandler.h"
#include "IpcWrapper.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaRedialReqHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaRedialReqHandler::CcaRedialReqHandler(ahl_tclBaseOneThreadService* pService) : CcaMethod(pService)
{
   ETG_TRACE_USR4(("CcaRedialReqHandler::CcaRedialReqHandler entered"));
}

void CcaRedialReqHandler::onMethodStart(amt_tclServiceData* pInMsg, tU64 ccaToken)
{
   ETG_TRACE_USR4(("CcaRedialReqHandler::onMethodStart entered"));

   most_telfi_tclMsgRedialMethodStart redialMsg;

   getDataFromAmt(pInMsg, redialMsg);

   ETG_TRACE_USR4(("CcaRedialReqHandler::onMethodStart ECNRSetting : %d",
         redialMsg.e8EchoCancellationNoiseReductionSetting.enType));

   BdAddress deviceAddress = "";
   ::com::bosch::pmapp::DeviceDetailsListHandler::getInstance().getActiveDeviceAddress(deviceAddress);

   PmResult pmresult = pm_ipc_wrapper::IpcWrapper::getInstance().postRedialRequest2PmCore(deviceAddress,
         DEFAULT_CALLERID, ccaToken);
   handlePmResult(pmresult, ccaToken);

   redialMsg.vDestroy();
}

void CcaRedialReqHandler::processMethodResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaRedialReqHandler::processMethodResponse entered"));

   RedialResponseMsg* redialResponseMsg = static_cast<RedialResponseMsg*> (responseMsg);

   ETG_TRACE_USR4(("redialResponseMsg->_u64TokenId : %u", redialResponseMsg->_u64TokenId));

   if(PM_RESULT_OK == redialResponseMsg->_pmResult._pmResultCode)
   {
      most_telfi_tclMsgRedialMethodResult redialMR;

      // TODO: Populating the actual data here, Revisit if all fields are updated appropriately
//      redialMR.u16CallInstance = redialResponseMsg->_callInstance;
//      redialMR.e8CallStatus.enType = static_cast<most_fi_tcl_e8_TelCallStatus::tenType>(most_fi_tcl_e8_TelCallStatus::FI_EN_E8ACTIVE);
//      redialMR.bUsingVehicleAudio = true;

      sendMethodResult(redialResponseMsg->_u64TokenId, redialMR);
      redialMR.vDestroy();
   }
   else
   {
      ETG_TRACE_ERR(("CcaRedialReqHandler::processMethodResponse - Error response for redial request"));

      // The error message is populated just as in legacy phone component to maintain uniformity.
      sendMethodError(redialResponseMsg->_u64TokenId, most_fi_tcl_e8_ErrorCode::FI_EN_NOTAVAILABLE);
   }
}
