/**
 * @file CcaQueryTelephoneNumberReqHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaQueryTelephoneNumberReqHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaQueryTelephoneNumberReqHandler.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaQueryTelephoneNumberReqHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaQueryTelephoneNumberReqHandler::CcaQueryTelephoneNumberReqHandler(ahl_tclBaseOneThreadService* pService)
   : CcaMethod(pService)
{
   ETG_TRACE_USR4(("CcaQueryTelephoneNumberReqHandler::CcaQueryTelephoneNumberReqHandler entered"));
}

void CcaQueryTelephoneNumberReqHandler::onMethodStart(amt_tclServiceData* pInMsg, tU64 ccaToken)
{
   ETG_TRACE_USR4(("CcaQueryTelephoneNumberReqHandler::onMethodStart entered"));
   (void) ccaToken;

   most_telfi_tclMsgQueryTelephoneNumberMethodStart queryTelephoneNumberMsg;

   getDataFromAmt(pInMsg, queryTelephoneNumberMsg);

   ETG_TRACE_USR4(("CcaQueryTelephoneNumberReqHandler::onMethodStart CallInstance : %d",
         queryTelephoneNumberMsg.u16CallInstance));

   // TODO: 1. Store the CCA Message in a list / map
   //       2. This is required when the same request is posted from any of
   //          the clients an error has to be reported.
   //       3. Send result based on the CallStatus update
   //sendMethodError(ccaToken, );

   PmResult pmresult(PM_RESULT_ERR_GENERAL, "");

   handlePmResult(pmresult, ccaToken);

   queryTelephoneNumberMsg.vDestroy();
}

void CcaQueryTelephoneNumberReqHandler::processMethodResponse(PmCoreResponseData* pInMsg)
{
   ETG_TRACE_USR4(("CcaQueryTelephoneNumberReqHandler::processMethodResponse entered"));
   (void)pInMsg; // To remove gen4 warning

   // TODO: This is where the method result / error shall be posted to clients
   //       based on the "pCppResponse.u8Status"
   // sendMethodResult(const CcaMsgHeader& msgHeaderInfo, const fi_tclTypeBase& oOutData);
   // sendErrorMessage(const CcaMsgHeader& msgHeaderInfo, tU16 u16ErrorCode);
}
