/**
 * @file CcaIgnoreCallReqHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaIgnoreCallReqHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaIgnoreCallReqHandler.h"
#include "IpcWrapper.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaIgnoreCallReqHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaIgnoreCallReqHandler::CcaIgnoreCallReqHandler(ahl_tclBaseOneThreadService* pService) : CcaMethod(pService)
{
   ETG_TRACE_USR4(("CcaIgnoreCallReqHandler::CcaIgnoreCallReqHandler entered"));
}

void CcaIgnoreCallReqHandler::onMethodStart(amt_tclServiceData* pInMsg, tU64 ccaToken)
{
   ETG_TRACE_USR4(("CcaIgnoreCallReqHandler::onMethodStart entered"));

   most_telfi_tclMsgIgnoreCallMethodStart ignoreCallMsg;

   getDataFromAmt(pInMsg, ignoreCallMsg);

   ETG_TRACE_USR4(("CcaIgnoreCallReqHandler::onMethodStart CallInstance : %d", ignoreCallMsg.u16CallInstance));

   PmResult pmresult(PM_RESULT_ERR_INVALID_PARAMETER, "");
   DeviceCallInstanceListMap hangupCallList;
   CallInstanceList callsList;
   BdAddress deviceAddress = "";

   if (CALL_INSTANCE_DEFAULT == ignoreCallMsg.u16CallInstance)
   {
      ::com::bosch::pmapp::DeviceDetailsListHandler::getInstance().getActiveDeviceAddress(deviceAddress);

      if (!deviceAddress.empty())
      {
         callsList.push_back(CALL_INSTANCE_DEFAULT);

         hangupCallList.emplace_hint(hangupCallList.end(), deviceAddress, callsList);
         pmresult = pm_ipc_wrapper::IpcWrapper::getInstance().postHangupCallsRequest2PmCore(hangupCallList, ccaToken);
      }
      else
      {
         pmresult._pmResultCode = PM_RESULT_ERR_DEVICE_NOT_EXIST;
      }
   }
   else
   {
      CallInstance pmcoreCallInstance = CALL_INSTANCE_DEFAULT;

      CcaCallStatusListHandler::getInstance().convertCCACallInstance(ignoreCallMsg.u16CallInstance,
            deviceAddress, pmcoreCallInstance);

      callsList.push_back(pmcoreCallInstance);

      hangupCallList.insert(std::pair<BdAddress, CallInstanceList> (deviceAddress, callsList));
      pmresult = pm_ipc_wrapper::IpcWrapper::getInstance().postHangupCallsRequest2PmCore(hangupCallList, ccaToken);
   }

   handlePmResult(pmresult, ccaToken);
   ignoreCallMsg.vDestroy();
}

void CcaIgnoreCallReqHandler::processMethodResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaIgnoreCallReqHandler::processMethodResponse entered"));
   PmCoreResponseData* ignoreCallResponseMsg = static_cast<PmCoreResponseData*> (responseMsg);

   ETG_TRACE_USR4(("ignoreCallResponseMsg->_u64TokenId : %u", ignoreCallResponseMsg->_u64TokenId));

   if(PM_RESULT_OK == ignoreCallResponseMsg->_pmResult._pmResultCode)
   {
      most_telfi_tclMsgIgnoreCallMethodResult oIgnoreCallMR;

//      oIgnoreCallMR.u16CallInstance = rfpCallInstance->m_u16Id;
//      oIgnoreCallMR.e8CallStatus.enType =
//            (most_fi_tcl_e8_TelCallStatus::tenType) rfpCallInstance->m_u16CallStatusNotice;
//      oIgnoreCallMR.bUsingVehicleAudio = rfpCallInstance->m_bUsingVehicleAudio;

      sendMethodResult(ignoreCallResponseMsg->_u64TokenId, oIgnoreCallMR);
      oIgnoreCallMR.vDestroy();
   }
   else
   {
      ETG_TRACE_ERR(("CcaIgnoreCallReqHandler::processMethodResponse - Error for ignorecall request"));

      // The error message is populated just as in legacy phone component to maintain uniformity.
      sendMethodError(ignoreCallResponseMsg->_u64TokenId, most_fi_tcl_e8_ErrorCode::FI_EN_NOTAVAILABLE);
   }
}
