/**
 * @file CcaHoldCallReqHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaHoldCallReqHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaHoldCallReqHandler.h"
#include "IpcWrapper.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaHoldCallReqHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaHoldCallReqHandler::CcaHoldCallReqHandler(ahl_tclBaseOneThreadService* pService) : CcaMethod(pService)
{
   ETG_TRACE_USR4(("CcaHoldCallReqHandler::CcaHoldCallReqHandler entered"));
}

void CcaHoldCallReqHandler::onMethodStart(amt_tclServiceData* pInMsg, tU64 ccaToken)
{
   ETG_TRACE_USR4(("CcaHoldCallReqHandler::onMethodStart entered"));

   most_telfi_tclMsgHoldCallMethodStart holdCallMsg;

   getDataFromAmt(pInMsg, holdCallMsg);

   ETG_TRACE_USR4(("CcaHoldCallReqHandler::onMethodStart CallInstance : %u", holdCallMsg.u16CallInstance));

   SwapOperation operation = SWAP_CALLS;

   BdAddress deviceAddress = "";
   ::com::bosch::pmapp::DeviceDetailsListHandler::getInstance().getActiveDeviceAddress(deviceAddress);

   PmResult pmresult = pm_ipc_wrapper::IpcWrapper::getInstance().postSwapCallRequest2PmCore(deviceAddress, operation, ccaToken);
   handlePmResult(pmresult, ccaToken);

   holdCallMsg.vDestroy();
}

void CcaHoldCallReqHandler::processMethodResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaHoldCallReqHandler::processMethodResponse entered"));

   SwapCallResponseMsg* holdCallResponseMsg = static_cast<SwapCallResponseMsg*> (responseMsg);

   ETG_TRACE_USR4(("holdCallResponseMsg->_u64TokenId : %u", holdCallResponseMsg->_u64TokenId));

   if(PM_RESULT_OK == holdCallResponseMsg->_pmResult._pmResultCode)
   {
      most_telfi_tclMsgHoldCallMethodResult oHoldCallMR;

//      oHoldCallMR.u16CallInstance = rfpCallInstance->m_u16Id;
//      oHoldCallMR.e8CallStatus.enType = (most_fi_tcl_e8_TelCallStatus::tenType)rfpCallInstance->m_u16CallStatusNotice;
//      oHoldCallMR.bUsingVehicleAudio = rfpCallInstance->m_bUsingVehicleAudio;

      sendMethodResult(holdCallResponseMsg->_u64TokenId, oHoldCallMR);
      oHoldCallMR.vDestroy();
   }
   else
   {
      ETG_TRACE_ERR(("CcaHoldCallReqHandler::processMethodResponse - Error response for hold request"));

      // The error message is populated just as in legacy phone component to maintain uniformity.
      sendMethodError(holdCallResponseMsg->_u64TokenId, most_fi_tcl_e8_ErrorCode::FI_EN_NOTAVAILABLE);
   }
}
