/**
 * @file CcaDialExtendedReqHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaDialExtendedReqHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaDialExtendedReqHandler.h"
#include "IpcWrapper.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaDialExtendedReqHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaDialExtendedReqHandler::CcaDialExtendedReqHandler(ahl_tclBaseOneThreadService* pService) : CcaMethod(pService)
{
   ETG_TRACE_USR4(("CcaDialExtendedReqHandler::CcaDialExtendedReqHandler entered"));
}

void CcaDialExtendedReqHandler::onMethodStart(amt_tclServiceData* pInMsg, tU64 ccaToken)
{
   ETG_TRACE_USR4(("CcaDialExtendedReqHandler::onMethodStart entered"));

   most_telfi_tclMsgDialExtendedMethodStart dialExtendedMsg;

   getDataFromAmt(pInMsg, dialExtendedMsg);

   PmResult pmResult(PM_RESULT_ERR_INVALID_PARAMETER, "");

   if(dialExtendedMsg.sTelephoneNumber.szValue)
   {
      TelephoneNumber telephoneNumber(dialExtendedMsg.sTelephoneNumber.szValue);
      DialInfo dialInfo(telephoneNumber, "", "", DEFAULT_CALLERID);

      // TODO: We need to store the name and update it in callStatusnoticeExtended property
      if(dialExtendedMsg.sName.szValue)
      {
         ETG_TRACE_USR4(("CcaDialExtendedReqHandler::onMethodStart Name : %s", dialExtendedMsg.sName.szValue));

         dialInfo._firstName = dialExtendedMsg.sName.szValue;
      }
      ETG_TRACE_USR4(("CcaDialExtendedReqHandler::onMethodStart ECNRSetting : %u",
            dialExtendedMsg.e8EchoCancellationNoiseReductionSetting.enType));

      BdAddress deviceAddress = "";
      ::com::bosch::pmapp::DeviceDetailsListHandler::getInstance().getActiveDeviceAddress(deviceAddress);
      pmResult = pm_ipc_wrapper::IpcWrapper::getInstance().postDialRequest2PmCore(deviceAddress, dialInfo, ccaToken);
   }

   handlePmResult(pmResult, ccaToken);
   dialExtendedMsg.vDestroy();
}

void CcaDialExtendedReqHandler::processMethodResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaDialExtendedReqHandler::processMethodResponse entered"));

   DialResponseMsg* dialExtendedResponseMsg = static_cast<DialResponseMsg*> (responseMsg);

   ETG_TRACE_USR4(("dialExtendedResponseMsg->_u64TokenId : %u", dialExtendedResponseMsg->_u64TokenId));

   if(PM_RESULT_OK == dialExtendedResponseMsg->_pmResult._pmResultCode)
   {
      most_telfi_tclMsgDialExtendedMethodResult oDialExtendedMR;

      oDialExtendedMR.u16CallInstance = dialExtendedResponseMsg->_callInstance;
      oDialExtendedMR.e8CallStatus.enType = most_fi_tcl_e8_TelCallStatus::FI_EN_E8DIALING;
      oDialExtendedMR.bUsingVehicleAudio = true; //TODO this needs to be checked

      sendMethodResult(dialExtendedResponseMsg->_u64TokenId, oDialExtendedMR);
      oDialExtendedMR.vDestroy();
   }
   else
   {
      ETG_TRACE_ERR(("CcaDialExtendedReqHandler::processMethodResponse - Error response for dial extended request"));

      // The error message is populated just as in legacy phone component to maintain uniformity.
      sendMethodError(dialExtendedResponseMsg->_u64TokenId, most_fi_tcl_e8_ErrorCode::FI_EN_NOTAVAILABLE);
   }
}
