/**
 * @file CcaDeActivateExternalVRReqHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaDeActivateExternalVRReqHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaDeActivateExternalVRReqHandler.h"
#include "IpcWrapper.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaDeActivateExternalVRReqHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaDeActivateExternalVRReqHandler::CcaDeActivateExternalVRReqHandler(ahl_tclBaseOneThreadService* pService) :
      CcaMethod(pService)
{
   ETG_TRACE_USR4(("CcaDeActivateExternalVRReqHandler::CcaDeActivateExternalVRReqHandler entered"));
}

void CcaDeActivateExternalVRReqHandler::onMethodStart(amt_tclServiceData* pInMsg, tU64 ccaToken)
{
   ETG_TRACE_USR4(("CcaDeActivateExternalVRReqHandler::onMethodStart entered"));

   most_telfi_tclMsgDeActivateExternalVRMethodStart deActivateExternalVRMsg;

   getDataFromAmt(pInMsg, deActivateExternalVRMsg);

   ETG_TRACE_USR4(("CcaDeActivateExternalVRReqHandler::BdAddress %s", deActivateExternalVRMsg.sBdAddress.szValue));

   PmResult pmResult = pm_ipc_wrapper::IpcWrapper::getInstance().postDeActivateExternalVRRequest2PmCore(
         deActivateExternalVRMsg.sBdAddress.szValue, ccaToken);

   handlePmResult(pmResult, ccaToken);

   deActivateExternalVRMsg.vDestroy();
}

void CcaDeActivateExternalVRReqHandler::processMethodResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaDeActivateExternalVRReqHandler::processMethodResponse entered"));

   PmCoreResponseData* deActivateExternalVRResponseMsg = static_cast<PmCoreResponseData*> (responseMsg);

   ETG_TRACE_USR4(("deActivateExternalVRResponseMsg->_u64TokenId: %u", deActivateExternalVRResponseMsg->_u64TokenId));

   if(PM_RESULT_OK == deActivateExternalVRResponseMsg->_pmResult._pmResultCode)
   {
      most_telfi_tclMsgDeActivateExternalVRMethodResult deActivateExternalVRMethodResult;

      sendMethodResult(deActivateExternalVRResponseMsg->_u64TokenId, deActivateExternalVRMethodResult);

      deActivateExternalVRMethodResult.vDestroy();
   }
   else
   {
      ETG_TRACE_ERR(("CcaDeActivateExternalVRReqHandler::processMethodResponse - Error response for"
            " deactivate external VR request"));

      // The error message is populated just as in legacy phone component to maintain uniformity.
      sendMethodError(deActivateExternalVRResponseMsg->_u64TokenId, most_fi_tcl_e8_ErrorCode::FI_EN_NOTAVAILABLE);
   }
}
