/**
 * @file CcaConferenceInReqHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaConferenceInReqHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaConferenceInReqHandler.h"
#include "IpcWrapper.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaConferenceInReqHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaConferenceInReqHandler::CcaConferenceInReqHandler(ahl_tclBaseOneThreadService* pService) : CcaMethod(pService)
{
   ETG_TRACE_USR4(("CcaConferenceInReqHandler::CcaConferenceInReqHandler entered"));
}

void CcaConferenceInReqHandler::onMethodStart(amt_tclServiceData* pInMsg, tU64 ccaToken)
{
   ETG_TRACE_USR4(("CcaConferenceInReqHandler::onMethodStart entered"));

   most_telfi_tclMsgConferenceInMethodStart conferenceInMsg;

   getDataFromAmt(pInMsg, conferenceInMsg);

   ETG_TRACE_USR4(("No of CallInstances:: %d", conferenceInMsg.oStreamOfCallInstances.u16Items.size()));

   CallInstanceList callsList;
   for(tU16 u16Index = 0; u16Index < conferenceInMsg.oStreamOfCallInstances.u16Items.size(); u16Index++)
   {
      ETG_TRACE_USR4(("CallInstance[%d]:: %d", u16Index, conferenceInMsg.oStreamOfCallInstances.u16Items[u16Index]));
      callsList.push_back((CallInstance)conferenceInMsg.oStreamOfCallInstances.u16Items[u16Index]);
   }

   PmResult pmResult(PM_RESULT_ERR_INVALID_PARAMETER, "");

   if (!callsList.empty())
   {
      DeviceCallInstanceListMap mergeCallsList;

      BdAddress deviceAddress = "";
      ::com::bosch::pmapp::DeviceDetailsListHandler::getInstance().getActiveDeviceAddress(deviceAddress);

      mergeCallsList.insert(std::pair<BdAddress, CallInstanceList> (deviceAddress, callsList));

      pmResult = pm_ipc_wrapper::IpcWrapper::getInstance().postMergeCallsRequest2PmCore(mergeCallsList, ccaToken);
   }

   handlePmResult(pmResult, ccaToken);
   conferenceInMsg.vDestroy();
}

void CcaConferenceInReqHandler::processMethodResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaConferenceInReqHandler::processMethodResponse entered"));

   PmCoreResponseData* conferenceCallResponseMsg = static_cast<PmCoreResponseData*> (responseMsg);

   ETG_TRACE_USR4(("conferenceCallResponseMsg->_u64TokenId : %u", conferenceCallResponseMsg->_u64TokenId));

   if(PM_RESULT_OK == conferenceCallResponseMsg->_pmResult._pmResultCode)
   {
      most_telfi_tclMsgConferenceInMethodResult oConferenceCallMR;

//      oConferenceCallMR.oStreamOfCallInstances.u16Items.push_back(u16ConferenceCall1);
//      oConferenceCallMR.oStreamOfCallInstances.u16Items.push_back(u16ConferenceCall2);

      sendMethodResult(conferenceCallResponseMsg->_u64TokenId, oConferenceCallMR);
      oConferenceCallMR.vDestroy();
   }
   else
   {
      ETG_TRACE_ERR(("CcaConferenceInReqHandler::processMethodResponse - Error response for mergecall request"));

      // The error message is populated just as in legacy phone component to maintain uniformity.
      sendMethodError(conferenceCallResponseMsg->_u64TokenId, most_fi_tcl_e8_ErrorCode::FI_EN_NOTAVAILABLE);
   }
}
