/**
 * @file CcaCancelOutgoingCallReqHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaCancelOutgoingCallReqHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaCancelOutgoingCallReqHandler.h"
#include "IpcWrapper.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaCancelOutgoingCallReqHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaCancelOutgoingCallReqHandler::CcaCancelOutgoingCallReqHandler(ahl_tclBaseOneThreadService* pService) : CcaMethod(pService)
{
   ETG_TRACE_USR4(("CcaCancelOutgoingCallReqHandler::CcaCancelOutgoingCallReqHandler entered"));
}

void CcaCancelOutgoingCallReqHandler::onMethodStart(amt_tclServiceData* pInMsg, tU64 ccaToken)
{
   ETG_TRACE_USR4(("CcaCancelOutgoingCallReqHandler::onMethodStart entered"));

   most_telfi_tclMsgCancelOutgoingCallMethodStart cancelOutgoingCallMsg;

   getDataFromAmt(pInMsg, cancelOutgoingCallMsg);

   ETG_TRACE_USR4(("CcaCancelOutgoingCallReqHandler::onMethodStart CallInstance : %u",
         cancelOutgoingCallMsg.u16CallInstance));

   CallInstance pmcoreCallInstance = CALL_INSTANCE_DEFAULT;
   BdAddress deviceAddress = "";

   CcaCallStatusListHandler::getInstance().convertCCACallInstance(cancelOutgoingCallMsg.u16CallInstance,
         deviceAddress, pmcoreCallInstance);

   PmResult pmresult(PM_RESULT_ERR_INVALID_PARAMETER, "");

   if ((pmcoreCallInstance != CALL_INSTANCE_DEFAULT) && (!deviceAddress.empty()))
   {
      DeviceCallInstanceListMap hangupCallList;
      CallInstanceList callsList;
      callsList.push_back(pmcoreCallInstance);

      hangupCallList.insert(std::pair<BdAddress, CallInstanceList> (deviceAddress, callsList));

      pmresult = pm_ipc_wrapper::IpcWrapper::getInstance().postHangupCallsRequest2PmCore(hangupCallList, ccaToken);
   }

   handlePmResult(pmresult, ccaToken);

   cancelOutgoingCallMsg.vDestroy();
}

void CcaCancelOutgoingCallReqHandler::processMethodResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaCancelOutgoingCallReqHandler::processMethodResponse entered"));

   PmCoreResponseData* cancelOutgoingCallResponseMsg = static_cast<PmCoreResponseData*> (responseMsg);

   ETG_TRACE_USR4(("cancelOutgoingCallResponseMsg->_u64TokenId : %u", cancelOutgoingCallResponseMsg->_u64TokenId));

   if(PM_RESULT_OK == cancelOutgoingCallResponseMsg->_pmResult._pmResultCode)
   {
      most_telfi_tclMsgCancelOutgoingCallMethodResult oCancelOutgoingCallMR;

      // Parameters need to be updated
//      oCancelOutgoingCallMR.u16CallInstance = rfpCallInstance->m_u16Id;
//      oCancelOutgoingCallMR.e8CallStatus.enType = (most_fi_tcl_e8_TelCallStatus::tenType)rfpCallInstance->m_u16CallStatusNotice;
      oCancelOutgoingCallMR.bUsingVehicleAudio = true;

      sendMethodResult(cancelOutgoingCallResponseMsg->_u64TokenId, oCancelOutgoingCallMR);
      oCancelOutgoingCallMR.vDestroy();
   }
   else
   {
      ETG_TRACE_ERR(("CcaCancelOutgoingCallReqHandler::processMethodResponse - Error for canceloutgoingcall request"));

      // The error message is populated just as in legacy phone component to maintain uniformity.
      sendMethodError(cancelOutgoingCallResponseMsg->_u64TokenId, most_fi_tcl_e8_ErrorCode::FI_EN_NOTAVAILABLE);
   }
}
