/**
 * @file CcaAutoWaitingModeOnOffReqHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaAutoWaitingModeOnOffReqHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaAutoWaitingModeOnOffReqHandler.h"
#include "IpcWrapper.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaAutoWaitingModeOnOffReqHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaAutoWaitingModeOnOffReqHandler::CcaAutoWaitingModeOnOffReqHandler(ahl_tclBaseOneThreadService* pService) :
      CcaMethod(pService)
{
   ETG_TRACE_USR4(("CcaAutoWaitingModeOnOffReqHandler::CcaAutoWaitingModeOnOffReqHandler entered"));
}

void CcaAutoWaitingModeOnOffReqHandler::onMethodStart(amt_tclServiceData* pInMsg, tU64 ccaToken)
{
   ETG_TRACE_USR4(("CcaAutoWaitingModeOnOffReqHandler::onMethodStart entered"));

   most_telfi_tclMsgAutoWaitingModeOnOffMethodStart autoWaitingModeOnOffMsg;

   getDataFromAmt(pInMsg, autoWaitingModeOnOffMsg);

   ETG_TRACE_USR4(("CcaAutoWaitingModeOnOffReqHandler::BdAddress %s", autoWaitingModeOnOffMsg.sBdAddress.szValue));
   ETG_TRACE_USR4(("CcaAutoWaitingModeOnOffReqHandler::AutoWaitingModeState %d",
         autoWaitingModeOnOffMsg.bAutoWaitingModeState));

   PmResult pmResult = pm_ipc_wrapper::IpcWrapper::getInstance().postAutoWaitingModeOnOffRequest2PmCore(
         autoWaitingModeOnOffMsg.sBdAddress.szValue, autoWaitingModeOnOffMsg.bAutoWaitingModeState, ccaToken);

   handlePmResult(pmResult, ccaToken);

   autoWaitingModeOnOffMsg.vDestroy();
}

void CcaAutoWaitingModeOnOffReqHandler::processMethodResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaAutoWaitingModeOnOffReqHandler::processMethodResponse entered"));

   PmCoreResponseData* autoWaitingModeOnOffResponseMsg = static_cast<PmCoreResponseData*> (responseMsg);

   ETG_TRACE_USR4(("autoWaitingModeOnOffResponseMsg->_u64TokenId: %u", autoWaitingModeOnOffResponseMsg->_u64TokenId));

   if(PM_RESULT_OK == autoWaitingModeOnOffResponseMsg->_pmResult._pmResultCode)
   {
      most_telfi_tclMsgAutoWaitingModeOnOffMethodResult autoWaitingModeOnOffMethodResult;

      sendMethodResult(autoWaitingModeOnOffResponseMsg->_u64TokenId, autoWaitingModeOnOffMethodResult);

      autoWaitingModeOnOffMethodResult.vDestroy();
   }
   else
   {
      ETG_TRACE_ERR(("CcaAutoWaitingModeOnOffReqHandler::processMethodResponse - Error response for"
            " auto waiting mode on off request"));

      // The error message is populated just as in legacy phone component to maintain uniformity.
      sendMethodError(autoWaitingModeOnOffResponseMsg->_u64TokenId, most_fi_tcl_e8_ErrorCode::FI_EN_NOTAVAILABLE);
   }
}
