/**
 * @file CcaAcceptCallReqHandler.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the CcaAcceptCallReqHandler class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#include "CcaAcceptCallReqHandler.h"
#include "IpcWrapper.h"
#include "PmAppTrace.h"

using namespace pmcore;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CcaAcceptCallReqHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS   TR_CLASS_PM_SERVICE
#endif
#endif

CcaAcceptCallReqHandler::CcaAcceptCallReqHandler(ahl_tclBaseOneThreadService* pService) : CcaMethod(pService)
{
   ETG_TRACE_USR4(("CcaAcceptCallReqHandler::CcaAcceptCallReqHandler entered"));
}

void CcaAcceptCallReqHandler::onMethodStart(amt_tclServiceData* pInMsg, tU64 ccaToken)
{
   ETG_TRACE_USR4(("CcaAcceptCallReqHandler::onMethodStart entered"));

   most_telfi_tclMsgAcceptCallMethodStart acceptCallMsg;

   getDataFromAmt(pInMsg, acceptCallMsg);

   ETG_TRACE_USR4(("CcaAcceptCallReqHandler::onMethodStart CallInstance : %d", acceptCallMsg.u16CallInstance));

   CallInstance pmcoreCallInstance = CALL_INSTANCE_DEFAULT;
   BdAddress deviceAddress = "";

   CcaCallStatusListHandler::getInstance().convertCCACallInstance(acceptCallMsg.u16CallInstance,
         deviceAddress, pmcoreCallInstance);

   PmResult pmresult(PM_RESULT_ERR_INVALID_PARAMETER, "");

   if (pmcoreCallInstance != CALL_INSTANCE_DEFAULT)
   {
      pmresult = pm_ipc_wrapper::IpcWrapper::getInstance().postAcceptRequest2PmCore(pmcoreCallInstance,
            ccaToken, deviceAddress);
   }

   handlePmResult(pmresult, ccaToken);

   acceptCallMsg.vDestroy();
}

void CcaAcceptCallReqHandler::processMethodResponse(PmCoreResponseData* responseMsg)
{
   ETG_TRACE_USR4(("CcaAcceptCallReqHandler::processMethodResponse entered"));

   AcceptCallResponseMsg* acceptCallResponseMsg = static_cast<AcceptCallResponseMsg*> (responseMsg);

   ETG_TRACE_USR4(("acceptCallResponseMsg->_u64TokenId : %u", acceptCallResponseMsg->_u64TokenId));

   if(PM_RESULT_OK == acceptCallResponseMsg->_pmResult._pmResultCode)
   {
      most_telfi_tclMsgAcceptCallMethodResult oAcceptCallMR;

      CCACallInstance ccaCallInstance = CCA_CALL_INSTANCE_DEFAULT;
      CcaCallStatusListHandler::getInstance().getCCACallInstance(acceptCallResponseMsg->_deviceAddress,
            acceptCallResponseMsg->_callInstance, ccaCallInstance);

      oAcceptCallMR.u16CallInstance = ccaCallInstance;
      oAcceptCallMR.bUsingVehicleAudio = CcaCallStatusListHandler::getInstance().getAudioActiveStatus();

      // Method result is updated immediately. Hence the state of the call is expected to be Ringtone.
      oAcceptCallMR.e8CallStatus.enType =
            static_cast<most_fi_tcl_e8_TelCallStatus::tenType>(most_fi_tcl_e8_TelCallStatus::FI_EN_E8RINGTONE);

      sendMethodResult(acceptCallResponseMsg->_u64TokenId, oAcceptCallMR);
      oAcceptCallMR.vDestroy();
   }
   else
   {
      ETG_TRACE_ERR(("CcaAcceptCallReqHandler::processMethodResponse - Error response for accept request"));

      // The error message is populated just as in legacy phone component to maintain uniformity.
      sendMethodError(acceptCallResponseMsg->_u64TokenId, most_fi_tcl_e8_ErrorCode::FI_EN_NOTAVAILABLE);
   }
}
