/**
 * @file PhoneBookCallBackIf.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the PhoneBookCallBackIf class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details This file holds the class definition for PhoneBookCallBackIf class
 *
 * @ingroup IpcWrapper
 */

#include "PhoneBookCallBackIf.h"
#include "DeviceDetailsListHandler.h"

using namespace pmcore;

namespace com
{
namespace bosch
{
namespace pmapp
{

DEFINE_CLASS_LOGGER_AND_LEVEL("phone_call_mgr/clienthandlers", PhoneBookCallBackIf, Info);

PhoneBookCallBackIf::PhoneBookCallBackIf()
{
   LOG_INFO("PhoneBookCallBackIf::PhoneBookCallBackIf() entered");
}

PhoneBookCallBackIf::~PhoneBookCallBackIf()
{
}

void PhoneBookCallBackIf::setPhoneBookFiProxy(MostPhonBkFiProxy phoneBookFiProxy)
{
   LOG_INFO("PhoneBookCallBackIf::setPhoneBookFiProxy() entered");
   _phoneBookFiProxy = phoneBookFiProxy;
}

void PhoneBookCallBackIf::onSearchPhoneBookError(const MostPhonBkFiProxy& proxy,
      const ::boost::shared_ptr< SearchPhoneBookError >& error)
{
   LOG_INFO("onSearchPhoneBookError() entered");

   // TODO: Manipulation and Logical handling of errors need to be done in the upcoming releases.
   // Once those changes are done, logs printing the Error codes shall be removed
   // since they are already printed from the generated code of ASF.

   // On auto-reconnection during boot-up, if searchPhonebook method is called, systemErrorCode is received as '0'.
   // And while download of contacts is in progress, if the searchPhonebook method is invoked,
   // then errorCode is received as '176'.

   if ((_phoneBookFiProxy.get()) && (proxy == _phoneBookFiProxy))
   {
      if(error->hasCcaErrorCode())
      {
         SearchPhoneBookErrorStructure searchPhoneBookErrorStruct = error->getCcaErrorCode();

         ::fi_basetypes_most::T_e8_ErrorCode errorCode = searchPhoneBookErrorStruct.getE8ErrorCode();
         LOG_ERROR("CCA errorCode: %u", errorCode);
      }
      else if (error->hasSystemErrorCode())
      {
         ::asf::cca::CcaTypes::SystemErrorCode systemErrorCode = error->getSystemErrorCode();
         LOG_ERROR("systemErrorCode: %u", systemErrorCode);
      }

      DeviceDetailsListHandler::getInstance().queryContactInfoResponse(error->getAct(),
            QueriedContactInfo(),
            PhonebookErrorResponseEnum::COMPONENT_ERROR);
   }
   else
   {
      LOG_ERROR("Undesirable proxy received");
   }
}

void PhoneBookCallBackIf::onSearchPhoneBookResult(const MostPhonBkFiProxy& proxy,
      const ::boost::shared_ptr< SearchPhoneBookResult >& result)
{
   LOG_INFO("onSearchPhoneBookResult() entered");

   if ((_phoneBookFiProxy.get()) && (proxy == _phoneBookFiProxy))
   {
      FirstName firstName(result->getSFirstName());
      LOG_INFO("FirstName: %s", firstName.c_str());

      LastName lastName(result->getSLastName());
      LOG_INFO("LastName: %s", lastName.c_str());

      ContactHandle contactHandle = result->getU32ContactHandle();
      LOG_INFO("ContactHandle: %u", contactHandle);

      DeviceDetailsListHandler::getInstance().queryContactInfoResponse(result->getAct(),
            QueriedContactInfo(firstName, lastName, contactHandle),
            PhonebookErrorResponseEnum::NO_ERROR);
   }
   else
   {
      LOG_ERROR("Undesirable proxy received");
   }
}

} // namespace pmapp
} // namespace bosch
} // namespace com
