/**
 * @file MediaPlayerRequestIf.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the MediaPlayerRequestIf class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details This file holds the class definition for MediaPlayerRequestIf class
 *
 * @ingroup IpcWrapper
 */

#include "MediaPlayerRequestIf.h"
#include "PhoneCallManager.h"

namespace com
{
namespace bosch
{
namespace pmapp
{

DEFINE_CLASS_LOGGER_AND_LEVEL("phone_call_mgr/clienthandlers", MediaPlayerRequestIf, Info);

MediaPlayerRequestIf::MediaPlayerRequestIf()
:IMediaPlayerRequestIf(false), _mediaPlayerCallBackIf(nullptr)
{
   LOG_INFO(("MediaPlayerRequestIf::MediaPlayerRequestIf() entered"));

   createProxy("mostMediaPlayerPort");
}

MediaPlayerRequestIf::~MediaPlayerRequestIf()
{
   destroyProxy();
}

void MediaPlayerRequestIf::onAvailable(const boost::shared_ptr<asf::core::Proxy>& proxy,
      const asf::core::ServiceStateChange& stateChange)
{
   LOG_INFO("MediaPlayerRequestIf::onAvailable() entered");

   if ((_mplayMediaPlayerFIProxy.get()) && (proxy == _mplayMediaPlayerFIProxy))
   {
      registerProperties();

      _serviceAvailability = true;
   }
   else
   {
      LOG_ERROR("Undesirable proxy");
   }
}

void MediaPlayerRequestIf::onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy,
      const asf::core::ServiceStateChange& stateChange)
{
   LOG_INFO("MediaPlayerRequestIf::onUnavailable() entered");

   if ((_mplayMediaPlayerFIProxy.get()) && (proxy == _mplayMediaPlayerFIProxy))
   {
      deregisterProperties();
      _serviceAvailability = false;
   }
   else
   {
      LOG_ERROR("Undesirable proxy");
   }
}

void MediaPlayerRequestIf::createProxy(const std::string portName)
{
   LOG_INFO("MediaPlayerRequestIf::createProxy entered");

   if (!(portName.empty()))
   {
      _mplayMediaPlayerFIProxy = Mplay_MediaPlayer_FIProxy::createProxy(portName, *this);
   }
}

void MediaPlayerRequestIf::destroyProxy()
{
   if (_mplayMediaPlayerFIProxy.get())
   {
      _mplayMediaPlayerFIProxy.reset();
   }
}

void MediaPlayerRequestIf::setMediaPlayerCallBackIf(IMediaPlayerCallBackIf* mediaPlayerCallBackIf)
{
   LOG_INFO("MediaPlayerRequestIf::setMediaPlayerCallBackIf entered");
   if (mediaPlayerCallBackIf)
   {
      _mediaPlayerCallBackIf = mediaPlayerCallBackIf;
      _mediaPlayerCallBackIf->setMediaPlayerFiProxy(_mplayMediaPlayerFIProxy);
   }
}

void MediaPlayerRequestIf::registerProperties()
{
   LOG_INFO("MediaPlayerRequestIf::registerProperties() entered");
   if(_mediaPlayerCallBackIf)
   {
      _mplayMediaPlayerFIProxy->sendReadyToPlayUpReg(*_mediaPlayerCallBackIf);
   }
   else
   {
      LOG_ERROR("registerProperties _mplayMediaPlayerFIProxy is NULL");
   }
}

void MediaPlayerRequestIf::deregisterProperties()
{
   LOG_INFO("MediaPlayerRequestIf::deregisterProperties() entered");

   _mplayMediaPlayerFIProxy->sendReadyToPlayRelUpRegAll();
}

} // namespace pmapp
} // namespace bosch
} // namespace com
