/**
 * @file MediaPlayerCallBackIf.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the MediaPlayerCallBackIf class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details This file holds the class definition for MediaPlayerCallBackIf class
 *
 * @ingroup IpcWrapper
 */

#include "MediaPlayerCallBackIf.h"
#include "IpcWrapper.h"

using namespace pm_ipc_wrapper;

namespace com
{
namespace bosch
{
namespace pmapp
{

DEFINE_CLASS_LOGGER_AND_LEVEL("phone_call_mgr/clienthandlers", MediaPlayerCallBackIf, Info);

MediaPlayerCallBackIf::MediaPlayerCallBackIf()
{
   LOG_INFO("MediaPlayerCallBackIf::MediaPlayerCallBackIf() entered");
}

MediaPlayerCallBackIf::~MediaPlayerCallBackIf()
{
}

void MediaPlayerCallBackIf::setMediaPlayerFiProxy(MplayMediaPlayerFIProxy mplayMediaPlayerFIProxy)
{
   LOG_INFO("MediaPlayerCallBackIf::setMediaPlayerFiProxy() entered");
   _mplayMediaPlayerFIProxy = mplayMediaPlayerFIProxy;
}

void MediaPlayerCallBackIf::onReadyToPlayError(const ::boost::shared_ptr< Mplay_MediaPlayer_FIProxy >& proxy, const ::boost::shared_ptr<ReadyToPlayError >& error)
{
   LOG_INFO("onReadyToPlayError() entered");

   if ((_mplayMediaPlayerFIProxy.get()) && (proxy == _mplayMediaPlayerFIProxy))
   {
      // As of now, Error handling is not done for property Get callbacks.
      LOG_ERROR("Error received for Property Get");
   }
   else
   {
      LOG_ERROR("Undesirable proxy received");
   }
}

void MediaPlayerCallBackIf::onReadyToPlayStatus(const ::boost::shared_ptr< Mplay_MediaPlayer_FIProxy >& proxy, const ::boost::shared_ptr<ReadyToPlayStatus >& status)
{
   LOG_INFO("MediaPlayerCallBackIf::onReadyToPlayError() entered");
   (void) proxy;
   if ((_mplayMediaPlayerFIProxy.get()) && (proxy == _mplayMediaPlayerFIProxy))
   {
      pmcore::BdAddress bdAddressFromMplay = status->getSDeviceSerialNumber();
      bool playingStatus = status->getBPlayingStatus();

      if(playingStatus)
      {
         IpcWrapper::getInstance().stopExtendedVRSession(bdAddressFromMplay);
      }
   }
   else
   {
      LOG_ERROR("Undesirable proxy received");
   }
}

} // namespace pmapp
} // namespace bosch
} // namespace com
