/**
 * @file PhoneBookRequestIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the PhoneBookRequestIf class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details This file holds the class definition for PhoneBookRequestIf class
 *
 * @ingroup IpcWrapper
 */

#ifndef PhoneBookRequestIf_h
#define PhoneBookRequestIf_h

#include "PhoneBookCallBackIf.h"
#include "ICreateDestroyProxy.h"
#include "IPhoneBookRequestIf.h"

namespace com
{
namespace bosch
{
namespace pmapp
{

class PhoneBookRequestIf final
: public asf::core::ServiceAvailableIF
  , public ICreateDestroyProxy
  , public IPhoneBookRequestIf
  {
  public:

   /**
    * Constructor of PhoneBookRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   PhoneBookRequestIf();

   /**
    * Destructor of PhoneBookRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   ~PhoneBookRequestIf();

   /**
    * Member function Overridden from IPhoneBookRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void setPhoneBookCallBackIf(IPhoneBookCallBackIf*) override;

   /**
    * Member function Overridden from IPhoneBookRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual act_t searchPhoneBook(const uint8 deviceHandle, const ::fi_basetypes_most::T_String phoneNumber) override;

   /**
    * Member function Overridden from IPhoneBookRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual act_t searchPhoneBook(const std::string deviceAddress, const std::string phoneNumber) override;

  protected:
   /**
    * Member function Overridden from asf::core::ServiceAvailableIF class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onAvailable(const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange) override;

   /**
    * Member function Overridden from asf::core::ServiceAvailableIF class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange) override;

   /**
    * Member function Overridden from ICreateDestroyProxy class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void createProxy(const std::string portName) override;

   /**
    * Member function Overridden from ICreateDestroyProxy class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void destroyProxy() override;

   /**
    * Member function Overridden from IPhoneBookRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void registerProperties() override;

   /**
    * Member function Overridden from IPhoneBookRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void deregisterProperties() override;

  private:
   MostPhonBkFiProxy _phoneBookFiProxy; /**< Instance of the MOST_PhonBk_FIProxy class >*/
   IPhoneBookCallBackIf* _phoneBookCallBackIf;

   DECLARE_CLASS_LOGGER(); //lint !e1516 Member declaration hides inherited member
  };

} // namespace pmapp
} // namespace bosch
} // namespace com

#endif //PhoneBookRequestIf_h
