/**
 * @file PhoneBookCallBackIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the PhoneBookCallBackIf class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details This file holds the class definition for PhoneBookCallBackIf class
 *
 * @ingroup IpcWrapper
 */

#ifndef PhoneBookCallBackIf_h
#define PhoneBookCallBackIf_h

#include "asf/core/Logger.h"

#include "MOST_PhonBk_FIProxy.h"
#include "IPhoneBookCallBackIf.h"

namespace com
{
namespace bosch
{
namespace pmapp
{

class PhoneBookCallBackIf final
: public IPhoneBookCallBackIf
  {
  public:

   /**
    * Constructor of PhoneBookCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   PhoneBookCallBackIf();

   /**
    * Destructor of PhoneBookCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   ~PhoneBookCallBackIf();

   /**
    * Member function Overridden from IPhoneBookCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void setPhoneBookFiProxy(MostPhonBkFiProxy phoneBookFiProxy) override;

  protected:
   /**
    * Member function Overridden from IPhoneBookCallBackIf class
    *
    * @param[in]
    *
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onSearchPhoneBookError(const MostPhonBkFiProxy& ,
         const ::boost::shared_ptr< MOST_PhonBk_FI::SearchPhoneBookError >& ) override;

   /**
    * Member function Overridden from IPhoneBookCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onSearchPhoneBookResult(const MostPhonBkFiProxy& ,
         const ::boost::shared_ptr< MOST_PhonBk_FI::SearchPhoneBookResult >& ) override;

  private:
   DECLARE_CLASS_LOGGER(); //lint !e1516 Member declaration hides inherited member
  };

} // namespace pmapp
} // namespace bosch
} // namespace com
#endif //PhoneBookCallBackIf_h
