/**
 * @file BmAppCallBackIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the BmAppCallBackIf class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details This file holds the class definition for BmAppCallBackIf class
 *
 * @ingroup IpcWrapper
 */

#ifndef BmAppCallBackIf_h
#define BmAppCallBackIf_h

#include "asf/core/Logger.h"

#include "IBmAppCallBackIf.h"

namespace com
{
namespace bosch
{
namespace pmapp
{

class BmAppCallBackIf final : public IBmAppCallBackIf
{
public:
   /**
    * Constructor of BmAppCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   BmAppCallBackIf();

   /**
    * Destructor of BmAppCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   ~BmAppCallBackIf();

   /**
    * Member function Overridden from IBmAppCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void setBtSetFIProxy(MostBTSetFiProxy btSetFIProxy) override;

protected:
   /**
    * Member function Overridden from IBmAppCallBackIf class
    *
    * @param[in]
    *
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onDeviceListExtendedError(const MostBTSetFiProxy& ,
         const ::boost::shared_ptr< MOST_BTSet_FI::DeviceListExtendedError >& ) override;

   /**
    * Member function Overridden from IBmAppCallBackIf class
    *
    * @param[in]
    *
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onDeviceListExtendedStatus(const MostBTSetFiProxy& ,
         const ::boost::shared_ptr< MOST_BTSet_FI::DeviceListExtendedStatus >& ) override;

   /**
    * Member function Overridden from IBmAppCallBackIf class
    *
    * @param[in]
    *
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onVehicleConfigurationError(const MostBTSetFiProxy& ,
         const ::boost::shared_ptr< MOST_BTSet_FI::VehicleConfigurationError >& ) override;

   /**
    * Member function Overridden from IBmAppCallBackIf class
    *
    * @param[in]
    *
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onVehicleConfigurationStatus(const MostBTSetFiProxy& ,
         const ::boost::shared_ptr< MOST_BTSet_FI::VehicleConfigurationStatus >& ) override;

   /**
    * Member function Overridden from IBmAppCallBackIf class
    *
    * @param[in]
    *
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onSetPrimaryError(const MostBTSetFiProxy& ,
         const ::boost::shared_ptr< MOST_BTSet_FI::SetPrimaryError >& ) override;

   /**
    * Member function Overridden from IBmAppCallBackIf class
    *
    * @param[in]
    *
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onSetPrimaryResult(const MostBTSetFiProxy& ,
         const ::boost::shared_ptr< MOST_BTSet_FI::SetPrimaryResult >& ) override;

   /**
    * Member function Overridden from IBmAppCallBackIf class
    *
    * @param[in]
    *
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onSetBTProfilesUsageError(const MostBTSetFiProxy& ,
         const ::boost::shared_ptr< MOST_BTSet_FI::SetBTProfilesUsageError >& ) override;

   /**
    * Member function Overridden from IBmAppCallBackIf class
    *
    * @param[in]
    *
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual void onSetBTProfilesUsageResult(const MostBTSetFiProxy& ,
         const ::boost::shared_ptr< MOST_BTSet_FI::SetBTProfilesUsageResult >& ) override;

private:
   DECLARE_CLASS_LOGGER(); //lint !e1516 Member declaration hides inherited member
};

} // namespace pmapp
} // namespace bosch
} // namespace com

#endif //BmAppCallBackIf_h
