/**
 * @file AhlService.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the AhlService class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details The PM APP CCA server framework class is defined here.
 *
 * @ingroup IpcWrapper
 */

#include "AhlService.h"
#include "PhoneCallManager.h"

DEFINE_CLASS_LOGGER_AND_LEVEL("phone_call_mgr/framework", AhlService, Info);

AhlService::AhlService(ahl_tclBaseOneThreadApp* app, tU16 serviceId, tU16 majorVersion, tU16 minorVersion)
: ahl_tclBaseOneThreadService(app, serviceId, majorVersion, minorVersion)
{
   LOG_INFO("AhlService::AhlService() entered");
   setPmCcaServiceAvailability();
}

AhlService::~AhlService()
{
}

void AhlService::vMyDispatchMessage(amt_tclServiceData* message)
{
   LOG_INFO("AhlService::vMyDispatchMessage() entered");

   // Since the instances for class CcaMessageHandler, IpcMessageDispatcher have a composite relationship with
   // the class PhoneCallManager, there is no necessity of null check for accessing those instances

   MessageHandlerBase* pmCcaMsgHandler = PhoneCallManager::getInstance().getPmAppCcaServer()->getCcaMsgHandler();

   IpcMessageDispatcher* ipcMsgDispatcher = PhoneCallManager::getInstance().getIpcMessageDispatcher();

   ipcMsgDispatcher->dispatchMessage(pmCcaMsgHandler, message);
}

void AhlService::setPmCcaServiceAvailability(bool availability)
{
   LOG_INFO("AhlService::setPmCcaServiceAvailability() entered : %d",availability);
   ahl_tclBaseOneThreadService::vSetPrivateServiceAvailableAllowed(availability);
}
