/**
 * @file AhlApp.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the AhlApp class methods
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details The PM APP CCA server framework class is defined here.
 *
 * @ingroup IpcWrapper
 */

#include "AhlApp.h"
#include "StreamMessage.h"

DEFINE_CLASS_LOGGER_AND_LEVEL("phone_call_mgr/framework", AhlApp, Info);

AhlApp::AhlApp(tU16 appId): ahl_tclBaseOneThreadApp(appId)
{
   LOG_INFO("AhlApp::AhlApp() entered");
}

void AhlApp::onCcaMessage(const ::boost::shared_ptr< asf::core::Blob >& request)
{
   LOG_INFO("AhlApp::onCcaMessage() entered");

   if(nullptr != request)
   {
      // Convert the ASF based message to stream message
      StreamMessage message((tU8*)request->getBytes());

      LOG_INFO("onCcaMessage(): SourceAppID=%d", message.u16GetSourceAppID());
      LOG_INFO("onCcaMessage(): TargetAppID=%d", message.u16GetTargetAppID());
      LOG_INFO("onCcaMessage(): type=%d", message.u8GetType());

      // Dispatch the converted stream message to the AIL interface via AHL
      bDispatchCCAMessages(&message);
   }
   else
   {
      LOG_ERROR("onCcaMessage: Invalid CCA message request");
   }
}
