/**
 * @file AhlApp.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the AhlApp class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details The PM APP CCA server framework class is defined here.
 *
 * @ingroup IpcWrapper
 */

#ifndef AhlApp_h
#define AhlApp_h

#include "asf/cca/CcaServerHookStub.h"

#include "ahl_fw.h"

/**
 * The class defines the AhlApp class through which the CCA interfaces are
 * routed to phone call manager
 */
class AhlApp final: public ahl_tclBaseOneThreadApp
, public asf::cca::CcaServerHook::CcaServerHookStub
{

public:

   /**
    * Constructor of AhlApp class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   AhlApp(); // not implemented!

   /**
    * Constructor of AhlApp class
    *
    * @param[in] tU16 - appId the CCA application ID of phone call manager
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   AhlApp(tU16 appId);

   /**
    * Destructor of AhlApp class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   virtual ~AhlApp()
   {

   }

   /**
    * CCA messages meant for PM CCA server are passed to the AhlApp base class
    * through the CcaServerHookStub::onCcaMessage() callback interface
    *
    * @param[in] asf::core::blob Request Message in ASF format
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   void onCcaMessage(const ::boost::shared_ptr< asf::core::Blob >& request) override;

private:

   DECLARE_CLASS_LOGGER(); //lint !e1516 Member declaration hides inherited member

};


#endif // AhlApp_h
