/* *
 * @file PmVoiceRecHandlerSm.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Generated code from PmVoiceRecHandlerSm.sct
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 * */

#ifndef PMVOICERECHANDLERSM_H_
#define PMVOICERECHANDLERSM_H_


#include <PmCoreSmTypes.h>
#include <deque>
#include "sc_types.h"
#include "StatemachineInterface.h"
#include "scTracing.h"

/*! \file Header of the state machine 'PmVoiceRecHandlerSm'.
*/


#ifndef SCT_EVENTS_PMVOICERECHANDLERSM_H
#define SCT_EVENTS_PMVOICERECHANDLERSM_H
#ifndef SC_INVALID_EVENT_VALUE
#define SC_INVALID_EVENT_VALUE 0
#endif

namespace pmvoicerechandlersm_events
{
typedef enum  {
	pmvoicerechandlersm_invalid_event = SC_INVALID_EVENT_VALUE,
	SCI_UserAction_START_VR,
	SCI_UserAction_STOP_VR,
	SCI_UserAction_START_EXT_VR,
	SCI_UserAction_STOP_EXT_VR,
	SCI_UserAction_SWITCH_TO_PASSIVE,
	SCI_UserAction_SWITCH_TO_PASSIVE_CLIENT_REQ,
	SCI_AgConnectionStatusUpdate_DEVICE_DISCONNECTED,
	SCI_AgVRUpdate_VR_ACTIVATED,
	SCI_AgVRUpdate_VR_DEACTIVATED,
	SCI_AgVRUpdate_HFP_CALL_ADDED,
	SCI_AgVRUpdate_VR_ACTIVATION_FAILURE,
	SCI_AgVRUpdate_VR_DEACTIVATION_FAILURE,
	SCI_AgAudioUpdate_SCO_CONNECTED,
	SCI_AgAudioUpdate_SCO_DISCONNECTED,
	SCI_AMResponse_VOICEREC_CHANNEL_GRANTED,
	SCI_AMResponse_VOICEREC_CHANNEL_DENIED,
	SCI_AMResponse_PLAY_AUDIO_SUCCESS,
	SCI_AMResponse_PLAY_AUDIO_FAILURE,
	SCI_AMResponse_PAUSE_AUDIO_SUCCESS,
	SCI_AMResponse_PAUSE_AUDIO_FAILURE,
	SCI_AMResponse_STOP_AUDIO_SUCCESS,
	SCI_AMResponse_STOP_AUDIO_FAILURE,
	SCI_AMResponse_VOICEREC_CHANNEL_RELEASED_EXT_TRIGGER,
	SCI_AMResponse_PHONE_CHANNEL_GRANTED,
	SCI_AMResponse_PHONE_CHANNEL_DENIED,
	SCI_AMResponse_WAITINGMODE_CHANNEL_GRANTED,
	SCI_AMResponse_WAITINGMODE_CHANNEL_DENIED,
	SCI_Timer_EXTENDED_VRSESSION_TIMER_CALLBACK,
	SCI_MediaPlayer_MEDIAREADYTOPLAY,
	InternalSCI_SWITCHED_TO_PASSIVE,
	InternalSCI_MOVE_TO_NEXT_STATE
} PmVoiceRecHandlerSmEventName;

class SctEvent
{
	public:
		SctEvent(PmVoiceRecHandlerSmEventName name) : name(name){}
		virtual ~SctEvent(){}
		const PmVoiceRecHandlerSmEventName name;
		
};
		
template <typename T>
class TypedSctEvent : public SctEvent
{
	public:
		TypedSctEvent(PmVoiceRecHandlerSmEventName name, T value) :
			SctEvent(name),
			value(value)
			{}
		virtual ~TypedSctEvent(){}
		const T value;
};

class SctEvent_SCI_UserAction_START_VR : public SctEvent
{
	public:
		SctEvent_SCI_UserAction_START_VR(PmVoiceRecHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_UserAction_STOP_VR : public SctEvent
{
	public:
		SctEvent_SCI_UserAction_STOP_VR(PmVoiceRecHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_UserAction_START_EXT_VR : public SctEvent
{
	public:
		SctEvent_SCI_UserAction_START_EXT_VR(PmVoiceRecHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_UserAction_STOP_EXT_VR : public SctEvent
{
	public:
		SctEvent_SCI_UserAction_STOP_EXT_VR(PmVoiceRecHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_UserAction_SWITCH_TO_PASSIVE : public TypedSctEvent<AudioChannel>
{
	public:
		SctEvent_SCI_UserAction_SWITCH_TO_PASSIVE(PmVoiceRecHandlerSmEventName name, AudioChannel value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_UserAction_SWITCH_TO_PASSIVE_CLIENT_REQ : public SctEvent
{
	public:
		SctEvent_SCI_UserAction_SWITCH_TO_PASSIVE_CLIENT_REQ(PmVoiceRecHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AgConnectionStatusUpdate_DEVICE_DISCONNECTED : public SctEvent
{
	public:
		SctEvent_SCI_AgConnectionStatusUpdate_DEVICE_DISCONNECTED(PmVoiceRecHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AgVRUpdate_VR_ACTIVATED : public SctEvent
{
	public:
		SctEvent_SCI_AgVRUpdate_VR_ACTIVATED(PmVoiceRecHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AgVRUpdate_VR_DEACTIVATED : public SctEvent
{
	public:
		SctEvent_SCI_AgVRUpdate_VR_DEACTIVATED(PmVoiceRecHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AgVRUpdate_HFP_CALL_ADDED : public SctEvent
{
	public:
		SctEvent_SCI_AgVRUpdate_HFP_CALL_ADDED(PmVoiceRecHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AgVRUpdate_VR_ACTIVATION_FAILURE : public TypedSctEvent<void *>
{
	public:
		SctEvent_SCI_AgVRUpdate_VR_ACTIVATION_FAILURE(PmVoiceRecHandlerSmEventName name, void * value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_AgVRUpdate_VR_DEACTIVATION_FAILURE : public TypedSctEvent<void *>
{
	public:
		SctEvent_SCI_AgVRUpdate_VR_DEACTIVATION_FAILURE(PmVoiceRecHandlerSmEventName name, void * value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_AgAudioUpdate_SCO_CONNECTED : public TypedSctEvent<SCOStatus>
{
	public:
		SctEvent_SCI_AgAudioUpdate_SCO_CONNECTED(PmVoiceRecHandlerSmEventName name, SCOStatus value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_AgAudioUpdate_SCO_DISCONNECTED : public TypedSctEvent<SCOStatus>
{
	public:
		SctEvent_SCI_AgAudioUpdate_SCO_DISCONNECTED(PmVoiceRecHandlerSmEventName name, SCOStatus value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_AMResponse_VOICEREC_CHANNEL_GRANTED : public SctEvent
{
	public:
		SctEvent_SCI_AMResponse_VOICEREC_CHANNEL_GRANTED(PmVoiceRecHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AMResponse_VOICEREC_CHANNEL_DENIED : public TypedSctEvent<void *>
{
	public:
		SctEvent_SCI_AMResponse_VOICEREC_CHANNEL_DENIED(PmVoiceRecHandlerSmEventName name, void * value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_AMResponse_PLAY_AUDIO_SUCCESS : public SctEvent
{
	public:
		SctEvent_SCI_AMResponse_PLAY_AUDIO_SUCCESS(PmVoiceRecHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AMResponse_PLAY_AUDIO_FAILURE : public TypedSctEvent<void *>
{
	public:
		SctEvent_SCI_AMResponse_PLAY_AUDIO_FAILURE(PmVoiceRecHandlerSmEventName name, void * value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_AMResponse_PAUSE_AUDIO_SUCCESS : public SctEvent
{
	public:
		SctEvent_SCI_AMResponse_PAUSE_AUDIO_SUCCESS(PmVoiceRecHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AMResponse_PAUSE_AUDIO_FAILURE : public TypedSctEvent<void *>
{
	public:
		SctEvent_SCI_AMResponse_PAUSE_AUDIO_FAILURE(PmVoiceRecHandlerSmEventName name, void * value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_AMResponse_STOP_AUDIO_SUCCESS : public SctEvent
{
	public:
		SctEvent_SCI_AMResponse_STOP_AUDIO_SUCCESS(PmVoiceRecHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AMResponse_STOP_AUDIO_FAILURE : public TypedSctEvent<void *>
{
	public:
		SctEvent_SCI_AMResponse_STOP_AUDIO_FAILURE(PmVoiceRecHandlerSmEventName name, void * value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_AMResponse_VOICEREC_CHANNEL_RELEASED_EXT_TRIGGER : public SctEvent
{
	public:
		SctEvent_SCI_AMResponse_VOICEREC_CHANNEL_RELEASED_EXT_TRIGGER(PmVoiceRecHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AMResponse_PHONE_CHANNEL_GRANTED : public SctEvent
{
	public:
		SctEvent_SCI_AMResponse_PHONE_CHANNEL_GRANTED(PmVoiceRecHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AMResponse_PHONE_CHANNEL_DENIED : public SctEvent
{
	public:
		SctEvent_SCI_AMResponse_PHONE_CHANNEL_DENIED(PmVoiceRecHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AMResponse_WAITINGMODE_CHANNEL_GRANTED : public SctEvent
{
	public:
		SctEvent_SCI_AMResponse_WAITINGMODE_CHANNEL_GRANTED(PmVoiceRecHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AMResponse_WAITINGMODE_CHANNEL_DENIED : public SctEvent
{
	public:
		SctEvent_SCI_AMResponse_WAITINGMODE_CHANNEL_DENIED(PmVoiceRecHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_Timer_EXTENDED_VRSESSION_TIMER_CALLBACK : public SctEvent
{
	public:
		SctEvent_SCI_Timer_EXTENDED_VRSESSION_TIMER_CALLBACK(PmVoiceRecHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_MediaPlayer_MEDIAREADYTOPLAY : public SctEvent
{
	public:
		SctEvent_SCI_MediaPlayer_MEDIAREADYTOPLAY(PmVoiceRecHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_InternalSCI_SWITCHED_TO_PASSIVE : public SctEvent
{
	public:
		SctEvent_InternalSCI_SWITCHED_TO_PASSIVE(PmVoiceRecHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_InternalSCI_MOVE_TO_NEXT_STATE : public SctEvent
{
	public:
		SctEvent_InternalSCI_MOVE_TO_NEXT_STATE(PmVoiceRecHandlerSmEventName name) : SctEvent(name){};
};

}
#endif /* SCT_EVENTS_PMVOICERECHANDLERSM_H */


/*! Define indices of states in the StateConfVector */
#define SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM 0
#define SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM 0
#define SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_STARTINGVR 0
#define SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_STARTINGVR_STARTINGVR_REGION_WAITINGFORCHANNELALLOCATION 0
#define SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_STARTINGVR_STARTINGVR_REGION_ACTIVATINGVRINAG 0
#define SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_STARTINGVR_STARTINGVR_REGION_WAITINGFORSTREAMING 0
#define SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_STARTINGVR_STARTINGVR_REGION_WAITINGFORSTREAMING_WAITINGFORSTREAMING_REGION_WAITINGFORSCO 0
#define SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_STARTINGVR_STARTINGVR_REGION_WAITINGFORSTREAMING_WAITINGFORSTREAMING_REGION_WAITINGFORSTREAMING 0
#define SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_STARTINGVR_STARTINGVR_REGION_WAITINGFORAGRESPONSETODEACTIVATEVR 0
#define SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_STOPPINGVR 0
#define SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_STOPPINGVR_STOPPINGVR_REGION_WAITINGFORAGRESPONSE 0
#define SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_STOPPINGVR_STOPPINGVR_REGION_WAITINGFORVOICERECCHANNELRELEASE 0
#define SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_STOPPINGVR_STOPPINGVR_REGION_WAITINGFORVOICERECCHANNELRELEASE_WAITINGFORVOICERECCHANNELRELEASE_REGION_WAITINGFORCHANNELRELEASE 0
#define SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_STOPPINGVR_STOPPINGVR_REGION_WAITINGFORVOICERECCHANNELRELEASE_WAITINGFORVOICERECCHANNELRELEASE_REGION_WAITINGFORCHANNELRELEASETOSTARTEXTVR 0
#define SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_STOPPINGVR_STOPPINGVR_REGION_WAITINGFORVOICERECCHANNELRELEASE_WAITINGFORVOICERECCHANNELRELEASE_REGION_WAITINGFORCHANNELRELEASETOSTARTVR 0
#define SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_STOPPINGVR_STOPPINGVR_REGION_WAITFORSCORELEASE 0
#define SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_ACTIVEVR 0
#define SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_ACTIVEVR_ACTIVEVR_REGION_ACTIVE 0
#define SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_ACTIVEVR_ACTIVEVR_REGION_WAITINGFORTIMEREXPIRY 0
#define SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_ACTIVEVR_ACTIVEVR_REGION_WAITINGFORDEACTIVATIONINDTORELCHANNEL 0
#define SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_SWITCHTOPASSIVE 0
#define SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_SWITCHTOPASSIVE_SWITCHTOPASSIVE_REGION_POSTINGREQUESTTOAUDIOMANAGER 0
#define SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_SWITCHTOPASSIVE_SWITCHTOPASSIVE_REGION_WAITINGFORDEACTIVATIONINDANDSCODISCONNECT 0
#define SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_SWITCHTOPASSIVE_SWITCHTOPASSIVE_REGION_WAITINGFORDEACTIVATIONINDANDSCODISCONNECT_WAITFORDEACTINDWAITINGFORDEACTIVATIONIND_REGION_WAITINGFORDEACTIVATIONIND 0
#define SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_SWITCHTOPASSIVE_SWITCHTOPASSIVE_REGION_WAITINGFORDEACTIVATIONINDANDSCODISCONNECT_WAITFORDEACTINDWAITINGFORDEACTIVATIONIND_REGION_DEACTIVATIONINDRECEIVED 0
#define SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_SWITCHTOPASSIVE_SWITCHTOPASSIVE_REGION_WAITINGFORDEACTIVATIONINDANDSCODISCONNECT_WAITFORSCODISCONNECTION_REGION_WAITFORSCODISCONNECTION 1
#define SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_SWITCHTOPASSIVE_SWITCHTOPASSIVE_REGION_WAITINGFORDEACTIVATIONINDANDSCODISCONNECT_WAITFORSCODISCONNECTION_REGION_SCODISCONNECTIONRECEIVED 1
#define SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_SWITCHTOPASSIVE_SWITCHTOPASSIVE_REGION_WAITFORSCODISCONNECT 0
#define SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_IDLEVOICERECOGNITIONSM 0
#define SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_EXTERNALVRSM 0
#define SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_EXTERNALVRSM_EXTERNALVRSM_REGION_STARTINGEXTERNALVR 0
#define SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_EXTERNALVRSM_EXTERNALVRSM_REGION_ACTIVEEXTERNALVR 0
#define SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_EXTERNALVRSM_EXTERNALVRSM_REGION_READYEXTERNALVR 0
#define SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_EXTERNALVRSM_EXTERNALVRSM_REGION_READYEXTERNALVR_READYEXTERNALVR_REGION_EXTERNALVRREADYANDWAITINGFORSCO 0
#define SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_EXTERNALVRSM_EXTERNALVRSM_REGION_READYEXTERNALVR_READYEXTERNALVR_REGION_WAITINGFORSTREAMING 0
#define SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_EXTERNALVRSM_EXTERNALVRSM_REGION_STOPPINGEXTERNALVR 0
#define SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_EXTERNALVRSM_EXTERNALVRSM_REGION_STOPPINGEXTERNALVR_STOPPINGEXTERNALVR_REGION_WAITINGFORCHANNELRELEASE 0
#define SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_EXTERNALVRSM_EXTERNALVRSM_REGION_STOPPINGEXTERNALVR_STOPPINGEXTERNALVR_REGION_WAITINGFORCHANNELRELEASETOSTARTEXTVR 0
#define SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_EXTERNALVRSM_EXTERNALVRSM_REGION_STOPPINGEXTERNALVR_STOPPINGEXTERNALVR_REGION_WAITINGFORCHANNELRELEASETOSTARTVR 0


class PmVoiceRecHandlerSm : public StatemachineInterface
{
	public:
		PmVoiceRecHandlerSm();
		
		~PmVoiceRecHandlerSm();
		
		/*! Enumeration of all states */ 
		typedef enum
		{
			PmVoiceRecHandlerSm_last_state,
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm,
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM,
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR,
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForChannelAllocation,
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_ActivatingVRinAg,
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming,
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForSCO,
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForStreaming,
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForAgResponseToDeactivateVR,
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR,
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForAgResponse,
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease,
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelRelease,
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartExtVR,
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartVR,
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitForSCORelease,
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR,
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_Active,
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForTimerExpiry,
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForDeactivationIndToRelChannel,
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive,
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_PostingRequestToAudioManager,
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect,
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_WaitingForDeactivationInd,
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_DeactivationIndReceived,
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_WaitForSCODisconnection,
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_SCODisconnectionReceived,
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitForSCODisconnect,
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_IdleVoiceRecognitionSM,
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM,
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StartingExternalVR,
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ActiveExternalVR,
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR,
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_ExternalVRReadyAndWaitingForSCO,
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_WaitingForStreaming,
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR,
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelRelease,
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartExtVR,
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartVR
		} PmVoiceRecHandlerSmStates;
					
		static const sc_integer numStates = 39;
		
		//! Inner class for UserAction interface scope.
		class SCI_UserAction
		{
			public:
				SCI_UserAction(PmVoiceRecHandlerSm * parent):
					START_VR_raised(false),
					STOP_VR_raised(false),
					START_EXT_VR_raised(false),
					STOP_EXT_VR_raised(false),
					SWITCH_TO_PASSIVE_raised(false),
					SWITCH_TO_PASSIVE_value(),
					SWITCH_TO_PASSIVE_CLIENT_REQ_raised(false),
					parent(parent)
				{}
				
				/*! Raises the in event 'START_VR' that is defined in the interface scope 'UserAction'. */
				void raise_sTART_VR();
				
				
				/*! Raises the in event 'STOP_VR' that is defined in the interface scope 'UserAction'. */
				void raise_sTOP_VR();
				
				
				/*! Raises the in event 'START_EXT_VR' that is defined in the interface scope 'UserAction'. */
				void raise_sTART_EXT_VR();
				
				
				/*! Raises the in event 'STOP_EXT_VR' that is defined in the interface scope 'UserAction'. */
				void raise_sTOP_EXT_VR();
				
				
				/*! Raises the in event 'SWITCH_TO_PASSIVE' that is defined in the interface scope 'UserAction'. */
				void raise_sWITCH_TO_PASSIVE(AudioChannel value);
				
				
				/*! Raises the in event 'SWITCH_TO_PASSIVE_CLIENT_REQ' that is defined in the interface scope 'UserAction'. */
				void raise_sWITCH_TO_PASSIVE_CLIENT_REQ();
				
				
				
				
				
				
			private:
				friend class PmVoiceRecHandlerSm;
				/*! Raises the in event 'START_VR' that is defined in the interface scope 'UserAction'. */
				void internal_raise_sTART_VR();
				sc_boolean START_VR_raised;
				/*! Raises the in event 'STOP_VR' that is defined in the interface scope 'UserAction'. */
				void internal_raise_sTOP_VR();
				sc_boolean STOP_VR_raised;
				/*! Raises the in event 'START_EXT_VR' that is defined in the interface scope 'UserAction'. */
				void internal_raise_sTART_EXT_VR();
				sc_boolean START_EXT_VR_raised;
				/*! Raises the in event 'STOP_EXT_VR' that is defined in the interface scope 'UserAction'. */
				void internal_raise_sTOP_EXT_VR();
				sc_boolean STOP_EXT_VR_raised;
				/*! Raises the in event 'SWITCH_TO_PASSIVE' that is defined in the interface scope 'UserAction'. */
				void internal_raise_sWITCH_TO_PASSIVE(AudioChannel value);
				sc_boolean SWITCH_TO_PASSIVE_raised;
				AudioChannel SWITCH_TO_PASSIVE_value;
				/*! Raises the in event 'SWITCH_TO_PASSIVE_CLIENT_REQ' that is defined in the interface scope 'UserAction'. */
				void internal_raise_sWITCH_TO_PASSIVE_CLIENT_REQ();
				sc_boolean SWITCH_TO_PASSIVE_CLIENT_REQ_raised;
				PmVoiceRecHandlerSm * parent;
				void dispatch_event(pmvoicerechandlersm_events::SctEvent * event);
				
				
		};
				//! Inner class for UserAction interface scope operation callbacks.
				class SCI_UserAction_OCB
				{
					public:
						virtual ~SCI_UserAction_OCB() = 0;
						
						virtual void activateVR() = 0;
						
						virtual void deactivateVR() = 0;
						
						virtual void tempFunc(sc_boolean success) = 0;
						
						
				};
				
				/*! Set the working instance of the operation callback interface 'SCI_UserAction_OCB'. */
				void setSCI_UserAction_OCB(SCI_UserAction_OCB* operationCallback);
		
		/*! Returns an instance of the interface class 'SCI_UserAction'. */
		SCI_UserAction* getSCI_UserAction();
		
		//! Inner class for AgConnectionStatusUpdate interface scope.
		class SCI_AgConnectionStatusUpdate
		{
			public:
				SCI_AgConnectionStatusUpdate(PmVoiceRecHandlerSm * parent):
					DEVICE_DISCONNECTED_raised(false),
					parent(parent)
				{}
				
				/*! Raises the in event 'DEVICE_DISCONNECTED' that is defined in the interface scope 'AgConnectionStatusUpdate'. */
				void raise_dEVICE_DISCONNECTED();
				
				
				
			private:
				friend class PmVoiceRecHandlerSm;
				/*! Raises the in event 'DEVICE_DISCONNECTED' that is defined in the interface scope 'AgConnectionStatusUpdate'. */
				void internal_raise_dEVICE_DISCONNECTED();
				sc_boolean DEVICE_DISCONNECTED_raised;
				PmVoiceRecHandlerSm * parent;
				void dispatch_event(pmvoicerechandlersm_events::SctEvent * event);
				
				
		};
		
		/*! Returns an instance of the interface class 'SCI_AgConnectionStatusUpdate'. */
		SCI_AgConnectionStatusUpdate* getSCI_AgConnectionStatusUpdate();
		
		//! Inner class for AgVRUpdate interface scope.
		class SCI_AgVRUpdate
		{
			public:
				SCI_AgVRUpdate(PmVoiceRecHandlerSm * parent):
					VR_ACTIVATED_raised(false),
					VR_DEACTIVATED_raised(false),
					HFP_CALL_ADDED_raised(false),
					VR_ACTIVATION_FAILURE_raised(false),
					VR_ACTIVATION_FAILURE_value(),
					VR_DEACTIVATION_FAILURE_raised(false),
					VR_DEACTIVATION_FAILURE_value(),
					parent(parent)
				{}
				
				/*! Gets the value of the variable 'vrState' that is defined in the interface scope 'AgVRUpdate'. */
				sc_boolean get_vrState() const;
				
				/*! Sets the value of the variable 'vrState' that is defined in the interface scope 'AgVRUpdate'. */
				void set_vrState(sc_boolean value);
				
				
				/*! Raises the in event 'VR_ACTIVATED' that is defined in the interface scope 'AgVRUpdate'. */
				void raise_vR_ACTIVATED();
				
				
				/*! Raises the in event 'VR_DEACTIVATED' that is defined in the interface scope 'AgVRUpdate'. */
				void raise_vR_DEACTIVATED();
				
				
				/*! Raises the in event 'HFP_CALL_ADDED' that is defined in the interface scope 'AgVRUpdate'. */
				void raise_hFP_CALL_ADDED();
				
				
				/*! Raises the in event 'VR_ACTIVATION_FAILURE' that is defined in the interface scope 'AgVRUpdate'. */
				void raise_vR_ACTIVATION_FAILURE(void * value);
				
				
				/*! Raises the in event 'VR_DEACTIVATION_FAILURE' that is defined in the interface scope 'AgVRUpdate'. */
				void raise_vR_DEACTIVATION_FAILURE(void * value);
				
				
				
			private:
				friend class PmVoiceRecHandlerSm;
				sc_boolean vrState;
				/*! Raises the in event 'VR_ACTIVATED' that is defined in the interface scope 'AgVRUpdate'. */
				void internal_raise_vR_ACTIVATED();
				sc_boolean VR_ACTIVATED_raised;
				/*! Raises the in event 'VR_DEACTIVATED' that is defined in the interface scope 'AgVRUpdate'. */
				void internal_raise_vR_DEACTIVATED();
				sc_boolean VR_DEACTIVATED_raised;
				/*! Raises the in event 'HFP_CALL_ADDED' that is defined in the interface scope 'AgVRUpdate'. */
				void internal_raise_hFP_CALL_ADDED();
				sc_boolean HFP_CALL_ADDED_raised;
				/*! Raises the in event 'VR_ACTIVATION_FAILURE' that is defined in the interface scope 'AgVRUpdate'. */
				void internal_raise_vR_ACTIVATION_FAILURE(void * value);
				sc_boolean VR_ACTIVATION_FAILURE_raised;
				void * VR_ACTIVATION_FAILURE_value;
				/*! Raises the in event 'VR_DEACTIVATION_FAILURE' that is defined in the interface scope 'AgVRUpdate'. */
				void internal_raise_vR_DEACTIVATION_FAILURE(void * value);
				sc_boolean VR_DEACTIVATION_FAILURE_raised;
				void * VR_DEACTIVATION_FAILURE_value;
				PmVoiceRecHandlerSm * parent;
				void dispatch_event(pmvoicerechandlersm_events::SctEvent * event);
				
				
		};
		
		/*! Returns an instance of the interface class 'SCI_AgVRUpdate'. */
		SCI_AgVRUpdate* getSCI_AgVRUpdate();
		
		//! Inner class for AgAudioUpdate interface scope.
		class SCI_AgAudioUpdate
		{
			public:
				SCI_AgAudioUpdate(PmVoiceRecHandlerSm * parent):
					SCO_CONNECTED_raised(false),
					SCO_CONNECTED_value(),
					SCO_DISCONNECTED_raised(false),
					SCO_DISCONNECTED_value(),
					parent(parent)
				{}
				
				/*! Gets the value of the variable 'scoStatus' that is defined in the interface scope 'AgAudioUpdate'. */
				SCOStatus get_scoStatus() const;
				
				/*! Sets the value of the variable 'scoStatus' that is defined in the interface scope 'AgAudioUpdate'. */
				void set_scoStatus(SCOStatus value);
				
				
				/*! Raises the in event 'SCO_CONNECTED' that is defined in the interface scope 'AgAudioUpdate'. */
				void raise_sCO_CONNECTED(SCOStatus value);
				
				
				/*! Raises the in event 'SCO_DISCONNECTED' that is defined in the interface scope 'AgAudioUpdate'. */
				void raise_sCO_DISCONNECTED(SCOStatus value);
				
				
				
			private:
				friend class PmVoiceRecHandlerSm;
				SCOStatus scoStatus;
				/*! Raises the in event 'SCO_CONNECTED' that is defined in the interface scope 'AgAudioUpdate'. */
				void internal_raise_sCO_CONNECTED(SCOStatus value);
				sc_boolean SCO_CONNECTED_raised;
				SCOStatus SCO_CONNECTED_value;
				/*! Raises the in event 'SCO_DISCONNECTED' that is defined in the interface scope 'AgAudioUpdate'. */
				void internal_raise_sCO_DISCONNECTED(SCOStatus value);
				sc_boolean SCO_DISCONNECTED_raised;
				SCOStatus SCO_DISCONNECTED_value;
				PmVoiceRecHandlerSm * parent;
				void dispatch_event(pmvoicerechandlersm_events::SctEvent * event);
				
				
		};
		
		/*! Returns an instance of the interface class 'SCI_AgAudioUpdate'. */
		SCI_AgAudioUpdate* getSCI_AgAudioUpdate();
		
		//! Inner class for AMRequest interface scope.
		class SCI_AMRequest
		{
			public:
				SCI_AMRequest(PmVoiceRecHandlerSm * parent):
					parent(parent)
				{}
				
				/*! Gets the value of the variable 'audioChannnelId' that is defined in the interface scope 'AMRequest'. */
				AudioChannel get_audioChannnelId() const;
				
				/*! Sets the value of the variable 'audioChannnelId' that is defined in the interface scope 'AMRequest'. */
				void set_audioChannnelId(AudioChannel value);
				
				
				
				
				
				
				
			private:
				friend class PmVoiceRecHandlerSm;
				AudioChannel audioChannnelId;
				PmVoiceRecHandlerSm * parent;
				void dispatch_event(pmvoicerechandlersm_events::SctEvent * event);
				
				
		};
				//! Inner class for AMRequest interface scope operation callbacks.
				class SCI_AMRequest_OCB
				{
					public:
						virtual ~SCI_AMRequest_OCB() = 0;
						
						virtual void requestAudioChannel() = 0;
						
						virtual void playHfAudio(SCOStatus scoStatus) = 0;
						
						virtual void stopOrPauseHfAudio(AudioChannel audioChannelId) = 0;
						
						virtual void stopAudio() = 0;
						
						
				};
				
				/*! Set the working instance of the operation callback interface 'SCI_AMRequest_OCB'. */
				void setSCI_AMRequest_OCB(SCI_AMRequest_OCB* operationCallback);
		
		/*! Returns an instance of the interface class 'SCI_AMRequest'. */
		SCI_AMRequest* getSCI_AMRequest();
		
		//! Inner class for AMResponse interface scope.
		class SCI_AMResponse
		{
			public:
				SCI_AMResponse(PmVoiceRecHandlerSm * parent):
					VOICEREC_CHANNEL_GRANTED_raised(false),
					VOICEREC_CHANNEL_DENIED_raised(false),
					VOICEREC_CHANNEL_DENIED_value(),
					PLAY_AUDIO_SUCCESS_raised(false),
					PLAY_AUDIO_FAILURE_raised(false),
					PLAY_AUDIO_FAILURE_value(),
					PAUSE_AUDIO_SUCCESS_raised(false),
					PAUSE_AUDIO_FAILURE_raised(false),
					PAUSE_AUDIO_FAILURE_value(),
					STOP_AUDIO_SUCCESS_raised(false),
					STOP_AUDIO_FAILURE_raised(false),
					STOP_AUDIO_FAILURE_value(),
					VOICEREC_CHANNEL_RELEASED_EXT_TRIGGER_raised(false),
					PHONE_CHANNEL_GRANTED_raised(false),
					PHONE_CHANNEL_DENIED_raised(false),
					WAITINGMODE_CHANNEL_GRANTED_raised(false),
					WAITINGMODE_CHANNEL_DENIED_raised(false),
					parent(parent)
				{}
				
				/*! Raises the in event 'VOICEREC_CHANNEL_GRANTED' that is defined in the interface scope 'AMResponse'. */
				void raise_vOICEREC_CHANNEL_GRANTED();
				
				
				/*! Raises the in event 'VOICEREC_CHANNEL_DENIED' that is defined in the interface scope 'AMResponse'. */
				void raise_vOICEREC_CHANNEL_DENIED(void * value);
				
				
				/*! Raises the in event 'PLAY_AUDIO_SUCCESS' that is defined in the interface scope 'AMResponse'. */
				void raise_pLAY_AUDIO_SUCCESS();
				
				
				/*! Raises the in event 'PLAY_AUDIO_FAILURE' that is defined in the interface scope 'AMResponse'. */
				void raise_pLAY_AUDIO_FAILURE(void * value);
				
				
				/*! Raises the in event 'PAUSE_AUDIO_SUCCESS' that is defined in the interface scope 'AMResponse'. */
				void raise_pAUSE_AUDIO_SUCCESS();
				
				
				/*! Raises the in event 'PAUSE_AUDIO_FAILURE' that is defined in the interface scope 'AMResponse'. */
				void raise_pAUSE_AUDIO_FAILURE(void * value);
				
				
				/*! Raises the in event 'STOP_AUDIO_SUCCESS' that is defined in the interface scope 'AMResponse'. */
				void raise_sTOP_AUDIO_SUCCESS();
				
				
				/*! Raises the in event 'STOP_AUDIO_FAILURE' that is defined in the interface scope 'AMResponse'. */
				void raise_sTOP_AUDIO_FAILURE(void * value);
				
				
				/*! Raises the in event 'VOICEREC_CHANNEL_RELEASED_EXT_TRIGGER' that is defined in the interface scope 'AMResponse'. */
				void raise_vOICEREC_CHANNEL_RELEASED_EXT_TRIGGER();
				
				
				/*! Raises the in event 'PHONE_CHANNEL_GRANTED' that is defined in the interface scope 'AMResponse'. */
				void raise_pHONE_CHANNEL_GRANTED();
				
				
				/*! Raises the in event 'PHONE_CHANNEL_DENIED' that is defined in the interface scope 'AMResponse'. */
				void raise_pHONE_CHANNEL_DENIED();
				
				
				/*! Raises the in event 'WAITINGMODE_CHANNEL_GRANTED' that is defined in the interface scope 'AMResponse'. */
				void raise_wAITINGMODE_CHANNEL_GRANTED();
				
				
				/*! Raises the in event 'WAITINGMODE_CHANNEL_DENIED' that is defined in the interface scope 'AMResponse'. */
				void raise_wAITINGMODE_CHANNEL_DENIED();
				
				
				
			private:
				friend class PmVoiceRecHandlerSm;
				/*! Raises the in event 'VOICEREC_CHANNEL_GRANTED' that is defined in the interface scope 'AMResponse'. */
				void internal_raise_vOICEREC_CHANNEL_GRANTED();
				sc_boolean VOICEREC_CHANNEL_GRANTED_raised;
				/*! Raises the in event 'VOICEREC_CHANNEL_DENIED' that is defined in the interface scope 'AMResponse'. */
				void internal_raise_vOICEREC_CHANNEL_DENIED(void * value);
				sc_boolean VOICEREC_CHANNEL_DENIED_raised;
				void * VOICEREC_CHANNEL_DENIED_value;
				/*! Raises the in event 'PLAY_AUDIO_SUCCESS' that is defined in the interface scope 'AMResponse'. */
				void internal_raise_pLAY_AUDIO_SUCCESS();
				sc_boolean PLAY_AUDIO_SUCCESS_raised;
				/*! Raises the in event 'PLAY_AUDIO_FAILURE' that is defined in the interface scope 'AMResponse'. */
				void internal_raise_pLAY_AUDIO_FAILURE(void * value);
				sc_boolean PLAY_AUDIO_FAILURE_raised;
				void * PLAY_AUDIO_FAILURE_value;
				/*! Raises the in event 'PAUSE_AUDIO_SUCCESS' that is defined in the interface scope 'AMResponse'. */
				void internal_raise_pAUSE_AUDIO_SUCCESS();
				sc_boolean PAUSE_AUDIO_SUCCESS_raised;
				/*! Raises the in event 'PAUSE_AUDIO_FAILURE' that is defined in the interface scope 'AMResponse'. */
				void internal_raise_pAUSE_AUDIO_FAILURE(void * value);
				sc_boolean PAUSE_AUDIO_FAILURE_raised;
				void * PAUSE_AUDIO_FAILURE_value;
				/*! Raises the in event 'STOP_AUDIO_SUCCESS' that is defined in the interface scope 'AMResponse'. */
				void internal_raise_sTOP_AUDIO_SUCCESS();
				sc_boolean STOP_AUDIO_SUCCESS_raised;
				/*! Raises the in event 'STOP_AUDIO_FAILURE' that is defined in the interface scope 'AMResponse'. */
				void internal_raise_sTOP_AUDIO_FAILURE(void * value);
				sc_boolean STOP_AUDIO_FAILURE_raised;
				void * STOP_AUDIO_FAILURE_value;
				/*! Raises the in event 'VOICEREC_CHANNEL_RELEASED_EXT_TRIGGER' that is defined in the interface scope 'AMResponse'. */
				void internal_raise_vOICEREC_CHANNEL_RELEASED_EXT_TRIGGER();
				sc_boolean VOICEREC_CHANNEL_RELEASED_EXT_TRIGGER_raised;
				/*! Raises the in event 'PHONE_CHANNEL_GRANTED' that is defined in the interface scope 'AMResponse'. */
				void internal_raise_pHONE_CHANNEL_GRANTED();
				sc_boolean PHONE_CHANNEL_GRANTED_raised;
				/*! Raises the in event 'PHONE_CHANNEL_DENIED' that is defined in the interface scope 'AMResponse'. */
				void internal_raise_pHONE_CHANNEL_DENIED();
				sc_boolean PHONE_CHANNEL_DENIED_raised;
				/*! Raises the in event 'WAITINGMODE_CHANNEL_GRANTED' that is defined in the interface scope 'AMResponse'. */
				void internal_raise_wAITINGMODE_CHANNEL_GRANTED();
				sc_boolean WAITINGMODE_CHANNEL_GRANTED_raised;
				/*! Raises the in event 'WAITINGMODE_CHANNEL_DENIED' that is defined in the interface scope 'AMResponse'. */
				void internal_raise_wAITINGMODE_CHANNEL_DENIED();
				sc_boolean WAITINGMODE_CHANNEL_DENIED_raised;
				PmVoiceRecHandlerSm * parent;
				void dispatch_event(pmvoicerechandlersm_events::SctEvent * event);
				
				
		};
		
		/*! Returns an instance of the interface class 'SCI_AMResponse'. */
		SCI_AMResponse* getSCI_AMResponse();
		
		//! Inner class for SmHandler interface scope.
		class SCI_SmHandler
		{
			public:
				SCI_SmHandler(PmVoiceRecHandlerSm * parent):
					parent(parent)
				{}
				
				
				
				
				
				
				
				
				
				
				
				
				
				
			private:
				friend class PmVoiceRecHandlerSm;
				PmVoiceRecHandlerSm * parent;
				void dispatch_event(pmvoicerechandlersm_events::SctEvent * event);
				
				
		};
				//! Inner class for SmHandler interface scope operation callbacks.
				class SCI_SmHandler_OCB
				{
					public:
						virtual ~SCI_SmHandler_OCB() = 0;
						
						virtual void updateVRState(VRStatusEnumType vrState) = 0;
						
						virtual void updateVRStartError(void * pmResult) = 0;
						
						virtual void updateVRStopError(void * pmResult) = 0;
						
						virtual void updateVRInterruptedReason(VRInterruptedReason vrInterruptedReason) = 0;
						
						virtual void updateExternalVRState(ExternalVRStatusEnumType extVRState) = 0;
						
						virtual void updateExternalVRStartError(void * pmResult) = 0;
						
						virtual void updateExtVRInterruptedReason(VRInterruptedReason extVRInterruptedReason) = 0;
						
						virtual void updateSwitchToPassiveError(void * pmResult) = 0;
						
						virtual void updateSwitchToPassiveNotHandledError() = 0;
						
						virtual void updateswitchToPassiveResponse(sc_string msg) = 0;
						
						virtual void processVRStopped() = 0;
						
						virtual void postGetCallsRequest2Btstack() = 0;
						
						
				};
				
				/*! Set the working instance of the operation callback interface 'SCI_SmHandler_OCB'. */
				void setSCI_SmHandler_OCB(SCI_SmHandler_OCB* operationCallback);
		
		/*! Returns an instance of the interface class 'SCI_SmHandler'. */
		SCI_SmHandler* getSCI_SmHandler();
		
		//! Inner class for Timer interface scope.
		class SCI_Timer
		{
			public:
				SCI_Timer(PmVoiceRecHandlerSm * parent):
					EXTENDED_VRSESSION_TIMER_CALLBACK_raised(false),
					parent(parent)
				{}
				
				/*! Raises the in event 'EXTENDED_VRSESSION_TIMER_CALLBACK' that is defined in the interface scope 'Timer'. */
				void raise_eXTENDED_VRSESSION_TIMER_CALLBACK();
				
				
				
				
				
			private:
				friend class PmVoiceRecHandlerSm;
				/*! Raises the in event 'EXTENDED_VRSESSION_TIMER_CALLBACK' that is defined in the interface scope 'Timer'. */
				void internal_raise_eXTENDED_VRSESSION_TIMER_CALLBACK();
				sc_boolean EXTENDED_VRSESSION_TIMER_CALLBACK_raised;
				PmVoiceRecHandlerSm * parent;
				void dispatch_event(pmvoicerechandlersm_events::SctEvent * event);
				
				
		};
				//! Inner class for Timer interface scope operation callbacks.
				class SCI_Timer_OCB
				{
					public:
						virtual ~SCI_Timer_OCB() = 0;
						
						virtual void stopExtendVRTimer() = 0;
						
						virtual void startExtendVRTimer() = 0;
						
						
				};
				
				/*! Set the working instance of the operation callback interface 'SCI_Timer_OCB'. */
				void setSCI_Timer_OCB(SCI_Timer_OCB* operationCallback);
		
		/*! Returns an instance of the interface class 'SCI_Timer'. */
		SCI_Timer* getSCI_Timer();
		
		//! Inner class for MediaPlayer interface scope.
		class SCI_MediaPlayer
		{
			public:
				SCI_MediaPlayer(PmVoiceRecHandlerSm * parent):
					MEDIAREADYTOPLAY_raised(false),
					parent(parent)
				{}
				
				/*! Raises the in event 'MEDIAREADYTOPLAY' that is defined in the interface scope 'MediaPlayer'. */
				void raise_mEDIAREADYTOPLAY();
				
				
				
			private:
				friend class PmVoiceRecHandlerSm;
				/*! Raises the in event 'MEDIAREADYTOPLAY' that is defined in the interface scope 'MediaPlayer'. */
				void internal_raise_mEDIAREADYTOPLAY();
				sc_boolean MEDIAREADYTOPLAY_raised;
				PmVoiceRecHandlerSm * parent;
				void dispatch_event(pmvoicerechandlersm_events::SctEvent * event);
				
				
		};
		
		/*! Returns an instance of the interface class 'SCI_MediaPlayer'. */
		SCI_MediaPlayer* getSCI_MediaPlayer();
		
		
		/*
		 * Functions inherited from StatemachineInterface
		 */
		virtual void init();
		
		virtual void enter();
		
		virtual void exit();
		
		virtual void runCycle();
		
		/*!
		* Checks if the state machine is active (until 2.4.1 this method was used for states).
		* A state machine is active if it has been entered. It is inactive if it has not been entered at all or if it has been exited.
		*/
		virtual sc_boolean isActive() const;
		
		
		/*!
		* Checks if all active states are final. 
		* If there are no active states then the state machine is considered being inactive. In this case this method returns false.
		*/
		virtual sc_boolean isFinal() const;
		
		void setTraceObserver(ysc::TraceObserver<PmVoiceRecHandlerSmStates>* tracingcallback);
		
		ysc::TraceObserver<PmVoiceRecHandlerSmStates>* getTraceObserver();
		
		/*! Checks if the specified state is active (until 2.4.1 the used method for states was calles isActive()). */
		sc_boolean isStateActive(PmVoiceRecHandlerSmStates state) const;
		
		
		
	protected:
		
		
	private:
		PmVoiceRecHandlerSm(const PmVoiceRecHandlerSm &rhs);
		PmVoiceRecHandlerSm& operator=(const PmVoiceRecHandlerSm&);
		
		//! Inner class for internal interface scope.
		class InternalSCI
		{
			public:
				InternalSCI(PmVoiceRecHandlerSm * parent):
					SWITCHED_TO_PASSIVE_raised(false),
					MOVE_TO_NEXT_STATE_raised(false),
					parent(parent)
				{}
				
				/*! Raises the in event 'SWITCHED_TO_PASSIVE' that is defined in the internal scope. */
				void raise_sWITCHED_TO_PASSIVE();
				
				/*! Checks if the out event 'SWITCHED_TO_PASSIVE' that is defined in the internal scope has been raised. */
				sc_boolean isRaised_sWITCHED_TO_PASSIVE() const;
				
				
				/*! Raises the in event 'MOVE_TO_NEXT_STATE' that is defined in the internal scope. */
				void raise_mOVE_TO_NEXT_STATE();
				
				/*! Checks if the out event 'MOVE_TO_NEXT_STATE' that is defined in the internal scope has been raised. */
				sc_boolean isRaised_mOVE_TO_NEXT_STATE() const;
				
				
				
			private:
				friend class PmVoiceRecHandlerSm;
				/*! Raises the in event 'SWITCHED_TO_PASSIVE' that is defined in the internal scope. */
				void internal_raise_sWITCHED_TO_PASSIVE();
				sc_boolean SWITCHED_TO_PASSIVE_raised;
				/*! Raises the in event 'MOVE_TO_NEXT_STATE' that is defined in the internal scope. */
				void internal_raise_mOVE_TO_NEXT_STATE();
				sc_boolean MOVE_TO_NEXT_STATE_raised;
				PmVoiceRecHandlerSm * parent;
				void dispatch_event(pmvoicerechandlersm_events::SctEvent * event);
				
				
		};
		
		//! the maximum number of orthogonal states defines the dimension of the state configuration vector.
		static const sc_ushort maxOrthogonalStates = 2;
		
		
		ysc::TraceObserver<PmVoiceRecHandlerSmStates>* ifaceTraceObserver;
		
		PmVoiceRecHandlerSmStates stateConfVector[maxOrthogonalStates];
		
		sc_ushort stateConfVectorPosition;
		
		SCI_UserAction ifaceUserAction;
		SCI_UserAction_OCB* ifaceUserAction_OCB;
		SCI_AgConnectionStatusUpdate ifaceAgConnectionStatusUpdate;
		SCI_AgVRUpdate ifaceAgVRUpdate;
		SCI_AgAudioUpdate ifaceAgAudioUpdate;
		SCI_AMRequest ifaceAMRequest;
		SCI_AMRequest_OCB* ifaceAMRequest_OCB;
		SCI_AMResponse ifaceAMResponse;
		SCI_SmHandler ifaceSmHandler;
		SCI_SmHandler_OCB* ifaceSmHandler_OCB;
		SCI_Timer ifaceTimer;
		SCI_Timer_OCB* ifaceTimer_OCB;
		SCI_MediaPlayer ifaceMediaPlayer;
		InternalSCI ifaceInternalSCI;
		
		// prototypes of all internal functions
		
		sc_boolean check_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region__choice_0_tr0_tr0();
		sc_boolean check_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region__choice_0_tr0_tr0();
		sc_boolean check_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region__choice_1_tr0_tr0();
		sc_boolean check_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region__choice_2_tr0_tr0();
		sc_boolean check_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region__choice_0_tr1_tr1();
		sc_boolean check_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region__choice_0_tr1_tr1();
		sc_boolean check_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region__choice_0_tr1_tr1();
		sc_boolean check_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region__choice_1_tr0_tr0();
		sc_boolean check_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region__choice_0_tr1_tr1();
		void effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_tr1();
		void effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_tr0();
		void effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_tr1();
		void effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_tr2();
		void effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_tr6();
		void effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_tr0();
		void effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_tr2();
		void effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_tr4();
		void effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_tr0();
		void effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_tr0();
		void effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_tr1();
		void effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_tr2();
		void effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_tr6();
		void effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_tr0();
		void effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_tr5();
		void effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_tr2();
		void effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_tr4();
		void effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_tr1();
		void effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_tr7();
		void effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region__choice_0_tr0();
		void effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region__choice_0_tr1();
		void effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region__choice_0_tr0();
		void effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region__choice_0_tr1();
		void effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region__choice_1_tr0();
		void effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region__choice_1_tr1();
		void effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region__choice_2_tr0();
		void effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region__choice_2_tr1();
		void effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region__choice_0_tr1();
		void effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region__choice_0_tr0();
		void effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region__choice_0_tr1();
		void effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region__choice_0_tr0();
		void effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region__choice_0_tr1();
		void effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region__choice_0_tr0();
		void effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region__choice_1_tr0();
		void effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region__choice_1_tr1();
		void effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region__choice_0_tr1();
		void effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region__choice_0_tr0();
		void enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm();
		void enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR();
		void enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForChannelAllocation();
		void enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_ActivatingVRinAg();
		void enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForStreaming();
		void enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR();
		void enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForAgResponse();
		void enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease();
		void enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR();
		void enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForTimerExpiry();
		void enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_PostingRequestToAudioManager();
		void enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_DeactivationIndReceived();
		void enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_SCODisconnectionReceived();
		void enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_IdleVoiceRecognitionSM();
		void enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StartingExternalVR();
		void enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ActiveExternalVR();
		void enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR();
		void enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_WaitingForStreaming();
		void enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR();
		void exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM();
		void exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_EntryTPoReleaseChannel2();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_EntryToIdleOrDeactivateVR();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_EntryToReleaseChannel();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForChannelAllocation_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_ActivatingVRinAg_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForSCO_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForStreaming_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForAgResponseToDeactivateVR_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_DeactivateVREntry();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_EntryToActivateVR();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_EntryToIdleOrWaitForSCORelease();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForAgResponse_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelRelease_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartExtVR_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartVR_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitForSCORelease_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_EntryToActive();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_EntryToReleaseChannel();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_Active_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForTimerExpiry_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForDeactivationIndToRelChannel_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_EntryToCheckSCOStatus();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_EntryToIdle();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_EntryToIdleOrPostingRequestToAudioManager();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_PostingRequestToAudioManager_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_WaitingForDeactivationInd_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_DeactivationIndReceived_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_WaitForSCODisconnection_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_SCODisconnectionReceived_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitForSCODisconnect_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_IdleVoiceRecognitionSM_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_EntryToIdle1();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_EntryToIdle3();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_EntryToIdle5();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_EntryToStoppingExternalVR();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StartingExternalVR_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ActiveExternalVR_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_ExternalVRReadyAndWaitingForSCO_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_WaitingForStreaming_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelRelease_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartExtVR_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartVR_default();
		void enseq_PmVoiceRecHandlerSm_Region_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_EntryToIdleOrDeactivateVR();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_EntryTPoReleaseChannel2();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_EntryToReleaseChannel();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_DeactivateVREntry();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_EntryToActivateVR();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_EntryToIdleOrWaitForSCORelease();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_EntryToActive();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_EntryToReleaseChannel();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_EntryToCheckSCOStatus();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_EntryToIdle();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_EntryToIdleOrPostingRequestToAudioManager();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_EntryToIdle1();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_EntryToIdle3();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_EntryToIdle5();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_EntryToStoppingExternalVR();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_default();
		void enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_default();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForChannelAllocation();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_ActivatingVRinAg();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForSCO();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForStreaming();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForAgResponseToDeactivateVR();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForAgResponse();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelRelease();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartExtVR();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartVR();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitForSCORelease();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_Active();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForTimerExpiry();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForDeactivationIndToRelChannel();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_PostingRequestToAudioManager();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_WaitingForDeactivationInd();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_DeactivationIndReceived();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_WaitForSCODisconnection();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_SCODisconnectionReceived();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitForSCODisconnect();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_IdleVoiceRecognitionSM();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StartingExternalVR();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ActiveExternalVR();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_ExternalVRReadyAndWaitingForSCO();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_WaitingForStreaming();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelRelease();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartExtVR();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartVR();
		void exseq_PmVoiceRecHandlerSm_Region();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region();
		void exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region__choice_0();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region__choice_0();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region__choice_1();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region__choice_2();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region__choice_0();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region__choice_0();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region__choice_0();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region__choice_1();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region__choice_0();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region__entry_Default();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region__entry_Default();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_EntryToIdleOrDeactivateVR();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_EntryTPoReleaseChannel2();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_EntryToReleaseChannel();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_DeactivateVREntry();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region__entry_Default();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region__entry_Default();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_EntryToActivateVR();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_EntryToIdleOrWaitForSCORelease();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region__entry_Default();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_EntryToActive();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_EntryToReleaseChannel();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region__entry_Default();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region__entry_Default();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_EntryToCheckSCOStatus();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_EntryToIdle();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_EntryToIdleOrPostingRequestToAudioManager();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region__entry_Default();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region__entry_Default();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region__entry_Default();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_EntryToIdle1();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_EntryToIdle3();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_EntryToIdle5();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_EntryToStoppingExternalVR();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region__entry_Default();
		void react_PmVoiceRecHandlerSm_Region__entry_Default();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_DeactivateVR();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_Idle();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_ReleaseChannel();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_ExitWaitingForStreaming();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_Idle();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_ActivateVR();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_ActivateExtVR();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_Idle();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_Idle();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_DeactivateVR();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_ReleaseChannel();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_exit_WaitingForTimerExpiry4();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_Idle();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_Idle();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_exit_WaitingForDeactivationIndAndSCODisconnect0();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_Idle();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_Idle();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_ActivateExtVR();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ActivateVR();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region__sync0();
		void react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region__sync1();
		sc_boolean react();
		sc_boolean PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_react(const sc_boolean try_transition);
		sc_boolean PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_react(const sc_boolean try_transition);
		sc_boolean PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_react(const sc_boolean try_transition);
		sc_boolean PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForChannelAllocation_react(const sc_boolean try_transition);
		sc_boolean PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_ActivatingVRinAg_react(const sc_boolean try_transition);
		sc_boolean PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_react(const sc_boolean try_transition);
		sc_boolean PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForSCO_react(const sc_boolean try_transition);
		sc_boolean PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForStreaming_react(const sc_boolean try_transition);
		sc_boolean PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForAgResponseToDeactivateVR_react(const sc_boolean try_transition);
		sc_boolean PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_react(const sc_boolean try_transition);
		sc_boolean PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForAgResponse_react(const sc_boolean try_transition);
		sc_boolean PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_react(const sc_boolean try_transition);
		sc_boolean PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelRelease_react(const sc_boolean try_transition);
		sc_boolean PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartExtVR_react(const sc_boolean try_transition);
		sc_boolean PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartVR_react(const sc_boolean try_transition);
		sc_boolean PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitForSCORelease_react(const sc_boolean try_transition);
		sc_boolean PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_react(const sc_boolean try_transition);
		sc_boolean PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_Active_react(const sc_boolean try_transition);
		sc_boolean PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForTimerExpiry_react(const sc_boolean try_transition);
		sc_boolean PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForDeactivationIndToRelChannel_react(const sc_boolean try_transition);
		sc_boolean PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_react(const sc_boolean try_transition);
		sc_boolean PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_PostingRequestToAudioManager_react(const sc_boolean try_transition);
		sc_boolean PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_react(const sc_boolean try_transition);
		sc_boolean PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_WaitingForDeactivationInd_react(const sc_boolean try_transition);
		sc_boolean PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_DeactivationIndReceived_react(const sc_boolean try_transition);
		sc_boolean PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_WaitForSCODisconnection_react(const sc_boolean try_transition);
		sc_boolean PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_SCODisconnectionReceived_react(const sc_boolean try_transition);
		sc_boolean PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitForSCODisconnect_react(const sc_boolean try_transition);
		sc_boolean PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_IdleVoiceRecognitionSM_react(const sc_boolean try_transition);
		sc_boolean PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_react(const sc_boolean try_transition);
		sc_boolean PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StartingExternalVR_react(const sc_boolean try_transition);
		sc_boolean PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ActiveExternalVR_react(const sc_boolean try_transition);
		sc_boolean PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_react(const sc_boolean try_transition);
		sc_boolean PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_ExternalVRReadyAndWaitingForSCO_react(const sc_boolean try_transition);
		sc_boolean PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_WaitingForStreaming_react(const sc_boolean try_transition);
		sc_boolean PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_react(const sc_boolean try_transition);
		sc_boolean PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelRelease_react(const sc_boolean try_transition);
		sc_boolean PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartExtVR_react(const sc_boolean try_transition);
		sc_boolean PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartVR_react(const sc_boolean try_transition);
		void clearInEvents();
		void clearOutEvents();
		
		
		std::deque<pmvoicerechandlersm_events::SctEvent*> internalEventQueue;
		pmvoicerechandlersm_events::SctEvent* getNextEvent();
		void dispatch_event(pmvoicerechandlersm_events::SctEvent * event);
		std::deque<pmvoicerechandlersm_events::SctEvent*> inEventQueue;
		sc_boolean isRunningCycle;
		
		
};


inline PmVoiceRecHandlerSm::SCI_UserAction_OCB::~SCI_UserAction_OCB() {}
inline PmVoiceRecHandlerSm::SCI_AMRequest_OCB::~SCI_AMRequest_OCB() {}
inline PmVoiceRecHandlerSm::SCI_SmHandler_OCB::~SCI_SmHandler_OCB() {}
inline PmVoiceRecHandlerSm::SCI_Timer_OCB::~SCI_Timer_OCB() {}


#endif /* PMVOICERECHANDLERSM_H_ */
