/* *
 * @file PmVoiceRecHandlerSm.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Generated code from PmVoiceRecHandlerSm.sct
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 * */

#include "PmVoiceRecHandlerSm.h"

/*! \file Implementation of the state machine 'PmVoiceRecHandlerSm'
*/




PmVoiceRecHandlerSm::PmVoiceRecHandlerSm()  :
ifaceTraceObserver(0),
stateConfVectorPosition(0),
ifaceUserAction(this),
ifaceUserAction_OCB(sc_null),
ifaceAgConnectionStatusUpdate(this),
ifaceAgVRUpdate(this),
ifaceAgAudioUpdate(this),
ifaceAMRequest(this),
ifaceAMRequest_OCB(sc_null),
ifaceAMResponse(this),
ifaceSmHandler(this),
ifaceSmHandler_OCB(sc_null),
ifaceTimer(this),
ifaceTimer_OCB(sc_null),
ifaceMediaPlayer(this),
ifaceInternalSCI(this),
isRunningCycle(false)
{
}

PmVoiceRecHandlerSm::~PmVoiceRecHandlerSm()
{
}


using namespace pmvoicerechandlersm_events;

SctEvent* PmVoiceRecHandlerSm::getNextEvent()
{
	SctEvent* nextEvent = 0;
	
	if(!internalEventQueue.empty()) {
		nextEvent = internalEventQueue.front();
		internalEventQueue.pop_front();
	}
	else if(!inEventQueue.empty()) {
		nextEvent = inEventQueue.front();
		inEventQueue.pop_front();
	}
	
	return nextEvent;
}

void PmVoiceRecHandlerSm::dispatch_event(SctEvent * event)
{
	if(event == 0) {
		return;
	}
	switch(event->name)
	{
		case SCI_UserAction_START_VR:
		case SCI_UserAction_STOP_VR:
		case SCI_UserAction_START_EXT_VR:
		case SCI_UserAction_STOP_EXT_VR:
		case SCI_UserAction_SWITCH_TO_PASSIVE:
		case SCI_UserAction_SWITCH_TO_PASSIVE_CLIENT_REQ:
		{
			ifaceUserAction.dispatch_event(event);
			break;
		}
		case SCI_AgConnectionStatusUpdate_DEVICE_DISCONNECTED:
		{
			ifaceAgConnectionStatusUpdate.dispatch_event(event);
			break;
		}
		case SCI_AgVRUpdate_VR_ACTIVATED:
		case SCI_AgVRUpdate_VR_DEACTIVATED:
		case SCI_AgVRUpdate_HFP_CALL_ADDED:
		case SCI_AgVRUpdate_VR_ACTIVATION_FAILURE:
		case SCI_AgVRUpdate_VR_DEACTIVATION_FAILURE:
		{
			ifaceAgVRUpdate.dispatch_event(event);
			break;
		}
		case SCI_AgAudioUpdate_SCO_CONNECTED:
		case SCI_AgAudioUpdate_SCO_DISCONNECTED:
		{
			ifaceAgAudioUpdate.dispatch_event(event);
			break;
		}
		case SCI_AMResponse_VOICEREC_CHANNEL_GRANTED:
		case SCI_AMResponse_VOICEREC_CHANNEL_DENIED:
		case SCI_AMResponse_PLAY_AUDIO_SUCCESS:
		case SCI_AMResponse_PLAY_AUDIO_FAILURE:
		case SCI_AMResponse_PAUSE_AUDIO_SUCCESS:
		case SCI_AMResponse_PAUSE_AUDIO_FAILURE:
		case SCI_AMResponse_STOP_AUDIO_SUCCESS:
		case SCI_AMResponse_STOP_AUDIO_FAILURE:
		case SCI_AMResponse_VOICEREC_CHANNEL_RELEASED_EXT_TRIGGER:
		case SCI_AMResponse_PHONE_CHANNEL_GRANTED:
		case SCI_AMResponse_PHONE_CHANNEL_DENIED:
		case SCI_AMResponse_WAITINGMODE_CHANNEL_GRANTED:
		case SCI_AMResponse_WAITINGMODE_CHANNEL_DENIED:
		{
			ifaceAMResponse.dispatch_event(event);
			break;
		}
		case SCI_Timer_EXTENDED_VRSESSION_TIMER_CALLBACK:
		{
			ifaceTimer.dispatch_event(event);
			break;
		}
		case SCI_MediaPlayer_MEDIAREADYTOPLAY:
		{
			ifaceMediaPlayer.dispatch_event(event);
			break;
		}
		case InternalSCI_SWITCHED_TO_PASSIVE:
		case InternalSCI_MOVE_TO_NEXT_STATE:
		{
			ifaceInternalSCI.dispatch_event(event);
			break;
		}
		default:
			break;
	}
}

void PmVoiceRecHandlerSm::SCI_UserAction::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		case SCI_UserAction_START_VR:
		{
			internal_raise_sTART_VR();
			break;
		}
		case SCI_UserAction_STOP_VR:
		{
			internal_raise_sTOP_VR();
			break;
		}
		case SCI_UserAction_START_EXT_VR:
		{
			internal_raise_sTART_EXT_VR();
			break;
		}
		case SCI_UserAction_STOP_EXT_VR:
		{
			internal_raise_sTOP_EXT_VR();
			break;
		}
		case SCI_UserAction_SWITCH_TO_PASSIVE:
		{
			SctEvent_SCI_UserAction_SWITCH_TO_PASSIVE * e = static_cast<SctEvent_SCI_UserAction_SWITCH_TO_PASSIVE*>(event);
			if(e != 0) {
				internal_raise_sWITCH_TO_PASSIVE(e->value);
			}
			break;
		}
		case SCI_UserAction_SWITCH_TO_PASSIVE_CLIENT_REQ:
		{
			internal_raise_sWITCH_TO_PASSIVE_CLIENT_REQ();
			break;
		}
		default:
			break;
	}
}
void PmVoiceRecHandlerSm::SCI_AgConnectionStatusUpdate::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		case SCI_AgConnectionStatusUpdate_DEVICE_DISCONNECTED:
		{
			internal_raise_dEVICE_DISCONNECTED();
			break;
		}
		default:
			break;
	}
}
void PmVoiceRecHandlerSm::SCI_AgVRUpdate::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		case SCI_AgVRUpdate_VR_ACTIVATED:
		{
			internal_raise_vR_ACTIVATED();
			break;
		}
		case SCI_AgVRUpdate_VR_DEACTIVATED:
		{
			internal_raise_vR_DEACTIVATED();
			break;
		}
		case SCI_AgVRUpdate_HFP_CALL_ADDED:
		{
			internal_raise_hFP_CALL_ADDED();
			break;
		}
		case SCI_AgVRUpdate_VR_ACTIVATION_FAILURE:
		{
			SctEvent_SCI_AgVRUpdate_VR_ACTIVATION_FAILURE * e = static_cast<SctEvent_SCI_AgVRUpdate_VR_ACTIVATION_FAILURE*>(event);
			if(e != 0) {
				internal_raise_vR_ACTIVATION_FAILURE(e->value);
			}
			break;
		}
		case SCI_AgVRUpdate_VR_DEACTIVATION_FAILURE:
		{
			SctEvent_SCI_AgVRUpdate_VR_DEACTIVATION_FAILURE * e = static_cast<SctEvent_SCI_AgVRUpdate_VR_DEACTIVATION_FAILURE*>(event);
			if(e != 0) {
				internal_raise_vR_DEACTIVATION_FAILURE(e->value);
			}
			break;
		}
		default:
			break;
	}
}
void PmVoiceRecHandlerSm::SCI_AgAudioUpdate::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		case SCI_AgAudioUpdate_SCO_CONNECTED:
		{
			SctEvent_SCI_AgAudioUpdate_SCO_CONNECTED * e = static_cast<SctEvent_SCI_AgAudioUpdate_SCO_CONNECTED*>(event);
			if(e != 0) {
				internal_raise_sCO_CONNECTED(e->value);
			}
			break;
		}
		case SCI_AgAudioUpdate_SCO_DISCONNECTED:
		{
			SctEvent_SCI_AgAudioUpdate_SCO_DISCONNECTED * e = static_cast<SctEvent_SCI_AgAudioUpdate_SCO_DISCONNECTED*>(event);
			if(e != 0) {
				internal_raise_sCO_DISCONNECTED(e->value);
			}
			break;
		}
		default:
			break;
	}
}
void PmVoiceRecHandlerSm::SCI_AMRequest::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		default:
			break;
	}
}
void PmVoiceRecHandlerSm::SCI_AMResponse::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		case SCI_AMResponse_VOICEREC_CHANNEL_GRANTED:
		{
			internal_raise_vOICEREC_CHANNEL_GRANTED();
			break;
		}
		case SCI_AMResponse_VOICEREC_CHANNEL_DENIED:
		{
			SctEvent_SCI_AMResponse_VOICEREC_CHANNEL_DENIED * e = static_cast<SctEvent_SCI_AMResponse_VOICEREC_CHANNEL_DENIED*>(event);
			if(e != 0) {
				internal_raise_vOICEREC_CHANNEL_DENIED(e->value);
			}
			break;
		}
		case SCI_AMResponse_PLAY_AUDIO_SUCCESS:
		{
			internal_raise_pLAY_AUDIO_SUCCESS();
			break;
		}
		case SCI_AMResponse_PLAY_AUDIO_FAILURE:
		{
			SctEvent_SCI_AMResponse_PLAY_AUDIO_FAILURE * e = static_cast<SctEvent_SCI_AMResponse_PLAY_AUDIO_FAILURE*>(event);
			if(e != 0) {
				internal_raise_pLAY_AUDIO_FAILURE(e->value);
			}
			break;
		}
		case SCI_AMResponse_PAUSE_AUDIO_SUCCESS:
		{
			internal_raise_pAUSE_AUDIO_SUCCESS();
			break;
		}
		case SCI_AMResponse_PAUSE_AUDIO_FAILURE:
		{
			SctEvent_SCI_AMResponse_PAUSE_AUDIO_FAILURE * e = static_cast<SctEvent_SCI_AMResponse_PAUSE_AUDIO_FAILURE*>(event);
			if(e != 0) {
				internal_raise_pAUSE_AUDIO_FAILURE(e->value);
			}
			break;
		}
		case SCI_AMResponse_STOP_AUDIO_SUCCESS:
		{
			internal_raise_sTOP_AUDIO_SUCCESS();
			break;
		}
		case SCI_AMResponse_STOP_AUDIO_FAILURE:
		{
			SctEvent_SCI_AMResponse_STOP_AUDIO_FAILURE * e = static_cast<SctEvent_SCI_AMResponse_STOP_AUDIO_FAILURE*>(event);
			if(e != 0) {
				internal_raise_sTOP_AUDIO_FAILURE(e->value);
			}
			break;
		}
		case SCI_AMResponse_VOICEREC_CHANNEL_RELEASED_EXT_TRIGGER:
		{
			internal_raise_vOICEREC_CHANNEL_RELEASED_EXT_TRIGGER();
			break;
		}
		case SCI_AMResponse_PHONE_CHANNEL_GRANTED:
		{
			internal_raise_pHONE_CHANNEL_GRANTED();
			break;
		}
		case SCI_AMResponse_PHONE_CHANNEL_DENIED:
		{
			internal_raise_pHONE_CHANNEL_DENIED();
			break;
		}
		case SCI_AMResponse_WAITINGMODE_CHANNEL_GRANTED:
		{
			internal_raise_wAITINGMODE_CHANNEL_GRANTED();
			break;
		}
		case SCI_AMResponse_WAITINGMODE_CHANNEL_DENIED:
		{
			internal_raise_wAITINGMODE_CHANNEL_DENIED();
			break;
		}
		default:
			break;
	}
}
void PmVoiceRecHandlerSm::SCI_SmHandler::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		default:
			break;
	}
}
void PmVoiceRecHandlerSm::SCI_Timer::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		case SCI_Timer_EXTENDED_VRSESSION_TIMER_CALLBACK:
		{
			internal_raise_eXTENDED_VRSESSION_TIMER_CALLBACK();
			break;
		}
		default:
			break;
	}
}
void PmVoiceRecHandlerSm::SCI_MediaPlayer::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		case SCI_MediaPlayer_MEDIAREADYTOPLAY:
		{
			internal_raise_mEDIAREADYTOPLAY();
			break;
		}
		default:
			break;
	}
}
void PmVoiceRecHandlerSm::InternalSCI::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		case InternalSCI_SWITCHED_TO_PASSIVE:
		{
			internal_raise_sWITCHED_TO_PASSIVE();
			break;
		}
		case InternalSCI_MOVE_TO_NEXT_STATE:
		{
			internal_raise_mOVE_TO_NEXT_STATE();
			break;
		}
		default:
			break;
	}
}


void PmVoiceRecHandlerSm::init()
{
	for (sc_ushort i = 0; i < maxOrthogonalStates; ++i)
		stateConfVector[i] = PmVoiceRecHandlerSm_last_state;
	
	stateConfVectorPosition = 0;

	clearInEvents();
	clearOutEvents();
	
	/* Default init sequence for statechart PmVoiceRecHandlerSm */
	ifaceAgVRUpdate.vrState = false;
	ifaceAgAudioUpdate.scoStatus = SCO_NOT_ESTABLISHED;
	ifaceAMRequest.audioChannnelId = AM_VOICERECOGNITION;
}

void PmVoiceRecHandlerSm::enter()
{
	/* Default enter sequence for statechart PmVoiceRecHandlerSm */
	enseq_PmVoiceRecHandlerSm_Region_default();
}

void PmVoiceRecHandlerSm::exit()
{
	/* Default exit sequence for statechart PmVoiceRecHandlerSm */
	exseq_PmVoiceRecHandlerSm_Region();
}

sc_boolean PmVoiceRecHandlerSm::isActive() const
{
	return stateConfVector[0] != PmVoiceRecHandlerSm_last_state||stateConfVector[1] != PmVoiceRecHandlerSm_last_state;
}

/* 
 * Always returns 'false' since this state machine can never become final.
 */
sc_boolean PmVoiceRecHandlerSm::isFinal() const
{
   return false;}

void PmVoiceRecHandlerSm::runCycle()
{
	if (isRunningCycle == false)
	{
		isRunningCycle = true;
		clearOutEvents();
						
		SctEvent * currentEvent = getNextEvent();
		
		do
		{
			/* Set event flags as usual */
			dispatch_event(currentEvent);
			
			for (stateConfVectorPosition = 0;
				stateConfVectorPosition < maxOrthogonalStates;
				stateConfVectorPosition++)
				{
					
				switch (stateConfVector[stateConfVectorPosition])
				{
				case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForChannelAllocation :
				{
					PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForChannelAllocation_react(true);
					break;
				}
				case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_ActivatingVRinAg :
				{
					PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_ActivatingVRinAg_react(true);
					break;
				}
				case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForSCO :
				{
					PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForSCO_react(true);
					break;
				}
				case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForStreaming :
				{
					PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForStreaming_react(true);
					break;
				}
				case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForAgResponseToDeactivateVR :
				{
					PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForAgResponseToDeactivateVR_react(true);
					break;
				}
				case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForAgResponse :
				{
					PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForAgResponse_react(true);
					break;
				}
				case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelRelease :
				{
					PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelRelease_react(true);
					break;
				}
				case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartExtVR :
				{
					PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartExtVR_react(true);
					break;
				}
				case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartVR :
				{
					PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartVR_react(true);
					break;
				}
				case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitForSCORelease :
				{
					PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitForSCORelease_react(true);
					break;
				}
				case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_Active :
				{
					PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_Active_react(true);
					break;
				}
				case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForTimerExpiry :
				{
					PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForTimerExpiry_react(true);
					break;
				}
				case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForDeactivationIndToRelChannel :
				{
					PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForDeactivationIndToRelChannel_react(true);
					break;
				}
				case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_PostingRequestToAudioManager :
				{
					PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_PostingRequestToAudioManager_react(true);
					break;
				}
				case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_WaitingForDeactivationInd :
				{
					PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_WaitingForDeactivationInd_react(true);
					break;
				}
				case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_DeactivationIndReceived :
				{
					PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_DeactivationIndReceived_react(true);
					break;
				}
				case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_WaitForSCODisconnection :
				{
					PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_WaitForSCODisconnection_react(true);
					break;
				}
				case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_SCODisconnectionReceived :
				{
					PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_SCODisconnectionReceived_react(true);
					break;
				}
				case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitForSCODisconnect :
				{
					PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitForSCODisconnect_react(true);
					break;
				}
				case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_IdleVoiceRecognitionSM :
				{
					PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_IdleVoiceRecognitionSM_react(true);
					break;
				}
				case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StartingExternalVR :
				{
					PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StartingExternalVR_react(true);
					break;
				}
				case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ActiveExternalVR :
				{
					PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ActiveExternalVR_react(true);
					break;
				}
				case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_ExternalVRReadyAndWaitingForSCO :
				{
					PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_ExternalVRReadyAndWaitingForSCO_react(true);
					break;
				}
				case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_WaitingForStreaming :
				{
					PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_WaitingForStreaming_react(true);
					break;
				}
				case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelRelease :
				{
					PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelRelease_react(true);
					break;
				}
				case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartExtVR :
				{
					PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartExtVR_react(true);
					break;
				}
				case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartVR :
				{
					PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartVR_react(true);
					break;
				}
				default:
					break;
				}
			}
			
			/* Delete event from memory */
			delete currentEvent;
			clearInEvents();
		} while((currentEvent = getNextEvent()));
		
		isRunningCycle = false;
	}
}

void PmVoiceRecHandlerSm::clearInEvents()
{
	ifaceUserAction.START_VR_raised = false;
	ifaceUserAction.STOP_VR_raised = false;
	ifaceUserAction.START_EXT_VR_raised = false;
	ifaceUserAction.STOP_EXT_VR_raised = false;
	ifaceUserAction.SWITCH_TO_PASSIVE_raised = false;
	ifaceUserAction.SWITCH_TO_PASSIVE_CLIENT_REQ_raised = false;
	ifaceAgConnectionStatusUpdate.DEVICE_DISCONNECTED_raised = false;
	ifaceAgVRUpdate.VR_ACTIVATED_raised = false;
	ifaceAgVRUpdate.VR_DEACTIVATED_raised = false;
	ifaceAgVRUpdate.HFP_CALL_ADDED_raised = false;
	ifaceAgVRUpdate.VR_ACTIVATION_FAILURE_raised = false;
	ifaceAgVRUpdate.VR_DEACTIVATION_FAILURE_raised = false;
	ifaceAgAudioUpdate.SCO_CONNECTED_raised = false;
	ifaceAgAudioUpdate.SCO_DISCONNECTED_raised = false;
	ifaceAMResponse.VOICEREC_CHANNEL_GRANTED_raised = false;
	ifaceAMResponse.VOICEREC_CHANNEL_DENIED_raised = false;
	ifaceAMResponse.PLAY_AUDIO_SUCCESS_raised = false;
	ifaceAMResponse.PLAY_AUDIO_FAILURE_raised = false;
	ifaceAMResponse.PAUSE_AUDIO_SUCCESS_raised = false;
	ifaceAMResponse.PAUSE_AUDIO_FAILURE_raised = false;
	ifaceAMResponse.STOP_AUDIO_SUCCESS_raised = false;
	ifaceAMResponse.STOP_AUDIO_FAILURE_raised = false;
	ifaceAMResponse.VOICEREC_CHANNEL_RELEASED_EXT_TRIGGER_raised = false;
	ifaceAMResponse.PHONE_CHANNEL_GRANTED_raised = false;
	ifaceAMResponse.PHONE_CHANNEL_DENIED_raised = false;
	ifaceAMResponse.WAITINGMODE_CHANNEL_GRANTED_raised = false;
	ifaceAMResponse.WAITINGMODE_CHANNEL_DENIED_raised = false;
	ifaceTimer.EXTENDED_VRSESSION_TIMER_CALLBACK_raised = false;
	ifaceMediaPlayer.MEDIAREADYTOPLAY_raised = false;
	ifaceInternalSCI.SWITCHED_TO_PASSIVE_raised = false; 
	ifaceInternalSCI.MOVE_TO_NEXT_STATE_raised = false; 
}

void PmVoiceRecHandlerSm::clearOutEvents()
{
}


sc_boolean PmVoiceRecHandlerSm::isStateActive(PmVoiceRecHandlerSmStates state) const
{
	switch (state)
	{
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm : 
			return (sc_boolean) (stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM] >= PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm
				&& stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM] <= PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartVR);
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM : 
			return (sc_boolean) (stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM] >= PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM
				&& stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM] <= PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitForSCODisconnect);
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR : 
			return (sc_boolean) (stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_STARTINGVR] >= PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR
				&& stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_STARTINGVR] <= PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForAgResponseToDeactivateVR);
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForChannelAllocation : 
			return (sc_boolean) (stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_STARTINGVR_STARTINGVR_REGION_WAITINGFORCHANNELALLOCATION] == PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForChannelAllocation
			);
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_ActivatingVRinAg : 
			return (sc_boolean) (stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_STARTINGVR_STARTINGVR_REGION_ACTIVATINGVRINAG] == PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_ActivatingVRinAg
			);
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming : 
			return (sc_boolean) (stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_STARTINGVR_STARTINGVR_REGION_WAITINGFORSTREAMING] >= PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming
				&& stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_STARTINGVR_STARTINGVR_REGION_WAITINGFORSTREAMING] <= PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForStreaming);
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForSCO : 
			return (sc_boolean) (stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_STARTINGVR_STARTINGVR_REGION_WAITINGFORSTREAMING_WAITINGFORSTREAMING_REGION_WAITINGFORSCO] == PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForSCO
			);
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForStreaming : 
			return (sc_boolean) (stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_STARTINGVR_STARTINGVR_REGION_WAITINGFORSTREAMING_WAITINGFORSTREAMING_REGION_WAITINGFORSTREAMING] == PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForStreaming
			);
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForAgResponseToDeactivateVR : 
			return (sc_boolean) (stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_STARTINGVR_STARTINGVR_REGION_WAITINGFORAGRESPONSETODEACTIVATEVR] == PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForAgResponseToDeactivateVR
			);
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR : 
			return (sc_boolean) (stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_STOPPINGVR] >= PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR
				&& stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_STOPPINGVR] <= PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitForSCORelease);
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForAgResponse : 
			return (sc_boolean) (stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_STOPPINGVR_STOPPINGVR_REGION_WAITINGFORAGRESPONSE] == PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForAgResponse
			);
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease : 
			return (sc_boolean) (stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_STOPPINGVR_STOPPINGVR_REGION_WAITINGFORVOICERECCHANNELRELEASE] >= PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease
				&& stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_STOPPINGVR_STOPPINGVR_REGION_WAITINGFORVOICERECCHANNELRELEASE] <= PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartVR);
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelRelease : 
			return (sc_boolean) (stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_STOPPINGVR_STOPPINGVR_REGION_WAITINGFORVOICERECCHANNELRELEASE_WAITINGFORVOICERECCHANNELRELEASE_REGION_WAITINGFORCHANNELRELEASE] == PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelRelease
			);
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartExtVR : 
			return (sc_boolean) (stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_STOPPINGVR_STOPPINGVR_REGION_WAITINGFORVOICERECCHANNELRELEASE_WAITINGFORVOICERECCHANNELRELEASE_REGION_WAITINGFORCHANNELRELEASETOSTARTEXTVR] == PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartExtVR
			);
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartVR : 
			return (sc_boolean) (stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_STOPPINGVR_STOPPINGVR_REGION_WAITINGFORVOICERECCHANNELRELEASE_WAITINGFORVOICERECCHANNELRELEASE_REGION_WAITINGFORCHANNELRELEASETOSTARTVR] == PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartVR
			);
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitForSCORelease : 
			return (sc_boolean) (stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_STOPPINGVR_STOPPINGVR_REGION_WAITFORSCORELEASE] == PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitForSCORelease
			);
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR : 
			return (sc_boolean) (stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_ACTIVEVR] >= PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR
				&& stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_ACTIVEVR] <= PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForDeactivationIndToRelChannel);
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_Active : 
			return (sc_boolean) (stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_ACTIVEVR_ACTIVEVR_REGION_ACTIVE] == PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_Active
			);
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForTimerExpiry : 
			return (sc_boolean) (stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_ACTIVEVR_ACTIVEVR_REGION_WAITINGFORTIMEREXPIRY] == PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForTimerExpiry
			);
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForDeactivationIndToRelChannel : 
			return (sc_boolean) (stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_ACTIVEVR_ACTIVEVR_REGION_WAITINGFORDEACTIVATIONINDTORELCHANNEL] == PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForDeactivationIndToRelChannel
			);
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive : 
			return (sc_boolean) (stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_SWITCHTOPASSIVE] >= PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive
				&& stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_SWITCHTOPASSIVE] <= PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitForSCODisconnect);
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_PostingRequestToAudioManager : 
			return (sc_boolean) (stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_SWITCHTOPASSIVE_SWITCHTOPASSIVE_REGION_POSTINGREQUESTTOAUDIOMANAGER] == PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_PostingRequestToAudioManager
			);
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect : 
			return (sc_boolean) (stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_SWITCHTOPASSIVE_SWITCHTOPASSIVE_REGION_WAITINGFORDEACTIVATIONINDANDSCODISCONNECT] >= PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect
				&& stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_SWITCHTOPASSIVE_SWITCHTOPASSIVE_REGION_WAITINGFORDEACTIVATIONINDANDSCODISCONNECT] <= PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_SCODisconnectionReceived);
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_WaitingForDeactivationInd : 
			return (sc_boolean) (stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_SWITCHTOPASSIVE_SWITCHTOPASSIVE_REGION_WAITINGFORDEACTIVATIONINDANDSCODISCONNECT_WAITFORDEACTINDWAITINGFORDEACTIVATIONIND_REGION_WAITINGFORDEACTIVATIONIND] == PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_WaitingForDeactivationInd
			);
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_DeactivationIndReceived : 
			return (sc_boolean) (stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_SWITCHTOPASSIVE_SWITCHTOPASSIVE_REGION_WAITINGFORDEACTIVATIONINDANDSCODISCONNECT_WAITFORDEACTINDWAITINGFORDEACTIVATIONIND_REGION_DEACTIVATIONINDRECEIVED] == PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_DeactivationIndReceived
			);
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_WaitForSCODisconnection : 
			return (sc_boolean) (stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_SWITCHTOPASSIVE_SWITCHTOPASSIVE_REGION_WAITINGFORDEACTIVATIONINDANDSCODISCONNECT_WAITFORSCODISCONNECTION_REGION_WAITFORSCODISCONNECTION] == PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_WaitForSCODisconnection
			);
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_SCODisconnectionReceived : 
			return (sc_boolean) (stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_SWITCHTOPASSIVE_SWITCHTOPASSIVE_REGION_WAITINGFORDEACTIVATIONINDANDSCODISCONNECT_WAITFORSCODISCONNECTION_REGION_SCODISCONNECTIONRECEIVED] == PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_SCODisconnectionReceived
			);
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitForSCODisconnect : 
			return (sc_boolean) (stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_VOICERECSM_VOICERECSM_REGION_SWITCHTOPASSIVE_SWITCHTOPASSIVE_REGION_WAITFORSCODISCONNECT] == PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitForSCODisconnect
			);
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_IdleVoiceRecognitionSM : 
			return (sc_boolean) (stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_IDLEVOICERECOGNITIONSM] == PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_IdleVoiceRecognitionSM
			);
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM : 
			return (sc_boolean) (stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_EXTERNALVRSM] >= PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM
				&& stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_EXTERNALVRSM] <= PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartVR);
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StartingExternalVR : 
			return (sc_boolean) (stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_EXTERNALVRSM_EXTERNALVRSM_REGION_STARTINGEXTERNALVR] == PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StartingExternalVR
			);
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ActiveExternalVR : 
			return (sc_boolean) (stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_EXTERNALVRSM_EXTERNALVRSM_REGION_ACTIVEEXTERNALVR] == PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ActiveExternalVR
			);
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR : 
			return (sc_boolean) (stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_EXTERNALVRSM_EXTERNALVRSM_REGION_READYEXTERNALVR] >= PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR
				&& stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_EXTERNALVRSM_EXTERNALVRSM_REGION_READYEXTERNALVR] <= PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_WaitingForStreaming);
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_ExternalVRReadyAndWaitingForSCO : 
			return (sc_boolean) (stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_EXTERNALVRSM_EXTERNALVRSM_REGION_READYEXTERNALVR_READYEXTERNALVR_REGION_EXTERNALVRREADYANDWAITINGFORSCO] == PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_ExternalVRReadyAndWaitingForSCO
			);
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_WaitingForStreaming : 
			return (sc_boolean) (stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_EXTERNALVRSM_EXTERNALVRSM_REGION_READYEXTERNALVR_READYEXTERNALVR_REGION_WAITINGFORSTREAMING] == PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_WaitingForStreaming
			);
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR : 
			return (sc_boolean) (stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_EXTERNALVRSM_EXTERNALVRSM_REGION_STOPPINGEXTERNALVR] >= PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR
				&& stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_EXTERNALVRSM_EXTERNALVRSM_REGION_STOPPINGEXTERNALVR] <= PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartVR);
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelRelease : 
			return (sc_boolean) (stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_EXTERNALVRSM_EXTERNALVRSM_REGION_STOPPINGEXTERNALVR_STOPPINGEXTERNALVR_REGION_WAITINGFORCHANNELRELEASE] == PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelRelease
			);
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartExtVR : 
			return (sc_boolean) (stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_EXTERNALVRSM_EXTERNALVRSM_REGION_STOPPINGEXTERNALVR_STOPPINGEXTERNALVR_REGION_WAITINGFORCHANNELRELEASETOSTARTEXTVR] == PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartExtVR
			);
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartVR : 
			return (sc_boolean) (stateConfVector[SCVI_PMVOICERECHANDLERSM_REGION_VOICERECOGNITIONHANDLERSM_VOICERECOGNITIONHANDLERSM_REGION_EXTERNALVRSM_EXTERNALVRSM_REGION_STOPPINGEXTERNALVR_STOPPINGEXTERNALVR_REGION_WAITINGFORCHANNELRELEASETOSTARTVR] == PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartVR
			);
		default: return false;
	}
}

PmVoiceRecHandlerSm::SCI_UserAction* PmVoiceRecHandlerSm::getSCI_UserAction()
{
	return &ifaceUserAction;
}
/* Functions for event START_VR in interface SCI_UserAction */
void PmVoiceRecHandlerSm::SCI_UserAction::raise_sTART_VR()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_UserAction_START_VR(SCI_UserAction_START_VR));
	parent->runCycle();
}
void PmVoiceRecHandlerSm::SCI_UserAction::internal_raise_sTART_VR()
{
	START_VR_raised = true;
}
/* Functions for event STOP_VR in interface SCI_UserAction */
void PmVoiceRecHandlerSm::SCI_UserAction::raise_sTOP_VR()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_UserAction_STOP_VR(SCI_UserAction_STOP_VR));
	parent->runCycle();
}
void PmVoiceRecHandlerSm::SCI_UserAction::internal_raise_sTOP_VR()
{
	STOP_VR_raised = true;
}
/* Functions for event START_EXT_VR in interface SCI_UserAction */
void PmVoiceRecHandlerSm::SCI_UserAction::raise_sTART_EXT_VR()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_UserAction_START_EXT_VR(SCI_UserAction_START_EXT_VR));
	parent->runCycle();
}
void PmVoiceRecHandlerSm::SCI_UserAction::internal_raise_sTART_EXT_VR()
{
	START_EXT_VR_raised = true;
}
/* Functions for event STOP_EXT_VR in interface SCI_UserAction */
void PmVoiceRecHandlerSm::SCI_UserAction::raise_sTOP_EXT_VR()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_UserAction_STOP_EXT_VR(SCI_UserAction_STOP_EXT_VR));
	parent->runCycle();
}
void PmVoiceRecHandlerSm::SCI_UserAction::internal_raise_sTOP_EXT_VR()
{
	STOP_EXT_VR_raised = true;
}
/* Functions for event SWITCH_TO_PASSIVE in interface SCI_UserAction */
void PmVoiceRecHandlerSm::SCI_UserAction::raise_sWITCH_TO_PASSIVE(AudioChannel value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_UserAction_SWITCH_TO_PASSIVE(SCI_UserAction_SWITCH_TO_PASSIVE, value));
	parent->runCycle();
}
void PmVoiceRecHandlerSm::SCI_UserAction::internal_raise_sWITCH_TO_PASSIVE(AudioChannel value)
{
	SWITCH_TO_PASSIVE_value = value;
	SWITCH_TO_PASSIVE_raised = true;
}
/* Functions for event SWITCH_TO_PASSIVE_CLIENT_REQ in interface SCI_UserAction */
void PmVoiceRecHandlerSm::SCI_UserAction::raise_sWITCH_TO_PASSIVE_CLIENT_REQ()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_UserAction_SWITCH_TO_PASSIVE_CLIENT_REQ(SCI_UserAction_SWITCH_TO_PASSIVE_CLIENT_REQ));
	parent->runCycle();
}
void PmVoiceRecHandlerSm::SCI_UserAction::internal_raise_sWITCH_TO_PASSIVE_CLIENT_REQ()
{
	SWITCH_TO_PASSIVE_CLIENT_REQ_raised = true;
}
void PmVoiceRecHandlerSm::setSCI_UserAction_OCB(SCI_UserAction_OCB* operationCallback)
{
	ifaceUserAction_OCB = operationCallback;
}
PmVoiceRecHandlerSm::SCI_AgConnectionStatusUpdate* PmVoiceRecHandlerSm::getSCI_AgConnectionStatusUpdate()
{
	return &ifaceAgConnectionStatusUpdate;
}
/* Functions for event DEVICE_DISCONNECTED in interface SCI_AgConnectionStatusUpdate */
void PmVoiceRecHandlerSm::SCI_AgConnectionStatusUpdate::raise_dEVICE_DISCONNECTED()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgConnectionStatusUpdate_DEVICE_DISCONNECTED(SCI_AgConnectionStatusUpdate_DEVICE_DISCONNECTED));
	parent->runCycle();
}
void PmVoiceRecHandlerSm::SCI_AgConnectionStatusUpdate::internal_raise_dEVICE_DISCONNECTED()
{
	DEVICE_DISCONNECTED_raised = true;
}
PmVoiceRecHandlerSm::SCI_AgVRUpdate* PmVoiceRecHandlerSm::getSCI_AgVRUpdate()
{
	return &ifaceAgVRUpdate;
}
/* Functions for event VR_ACTIVATED in interface SCI_AgVRUpdate */
void PmVoiceRecHandlerSm::SCI_AgVRUpdate::raise_vR_ACTIVATED()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgVRUpdate_VR_ACTIVATED(SCI_AgVRUpdate_VR_ACTIVATED));
	parent->runCycle();
}
void PmVoiceRecHandlerSm::SCI_AgVRUpdate::internal_raise_vR_ACTIVATED()
{
	VR_ACTIVATED_raised = true;
}
/* Functions for event VR_DEACTIVATED in interface SCI_AgVRUpdate */
void PmVoiceRecHandlerSm::SCI_AgVRUpdate::raise_vR_DEACTIVATED()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgVRUpdate_VR_DEACTIVATED(SCI_AgVRUpdate_VR_DEACTIVATED));
	parent->runCycle();
}
void PmVoiceRecHandlerSm::SCI_AgVRUpdate::internal_raise_vR_DEACTIVATED()
{
	VR_DEACTIVATED_raised = true;
}
/* Functions for event HFP_CALL_ADDED in interface SCI_AgVRUpdate */
void PmVoiceRecHandlerSm::SCI_AgVRUpdate::raise_hFP_CALL_ADDED()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgVRUpdate_HFP_CALL_ADDED(SCI_AgVRUpdate_HFP_CALL_ADDED));
	parent->runCycle();
}
void PmVoiceRecHandlerSm::SCI_AgVRUpdate::internal_raise_hFP_CALL_ADDED()
{
	HFP_CALL_ADDED_raised = true;
}
/* Functions for event VR_ACTIVATION_FAILURE in interface SCI_AgVRUpdate */
void PmVoiceRecHandlerSm::SCI_AgVRUpdate::raise_vR_ACTIVATION_FAILURE(void * value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgVRUpdate_VR_ACTIVATION_FAILURE(SCI_AgVRUpdate_VR_ACTIVATION_FAILURE, value));
	parent->runCycle();
}
void PmVoiceRecHandlerSm::SCI_AgVRUpdate::internal_raise_vR_ACTIVATION_FAILURE(void * value)
{
	VR_ACTIVATION_FAILURE_value = value;
	VR_ACTIVATION_FAILURE_raised = true;
}
/* Functions for event VR_DEACTIVATION_FAILURE in interface SCI_AgVRUpdate */
void PmVoiceRecHandlerSm::SCI_AgVRUpdate::raise_vR_DEACTIVATION_FAILURE(void * value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgVRUpdate_VR_DEACTIVATION_FAILURE(SCI_AgVRUpdate_VR_DEACTIVATION_FAILURE, value));
	parent->runCycle();
}
void PmVoiceRecHandlerSm::SCI_AgVRUpdate::internal_raise_vR_DEACTIVATION_FAILURE(void * value)
{
	VR_DEACTIVATION_FAILURE_value = value;
	VR_DEACTIVATION_FAILURE_raised = true;
}
sc_boolean PmVoiceRecHandlerSm::SCI_AgVRUpdate::get_vrState() const
{
	return vrState;
}

void PmVoiceRecHandlerSm::SCI_AgVRUpdate::set_vrState(sc_boolean value)
{
	this->vrState = value;
}

PmVoiceRecHandlerSm::SCI_AgAudioUpdate* PmVoiceRecHandlerSm::getSCI_AgAudioUpdate()
{
	return &ifaceAgAudioUpdate;
}
/* Functions for event SCO_CONNECTED in interface SCI_AgAudioUpdate */
void PmVoiceRecHandlerSm::SCI_AgAudioUpdate::raise_sCO_CONNECTED(SCOStatus value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgAudioUpdate_SCO_CONNECTED(SCI_AgAudioUpdate_SCO_CONNECTED, value));
	parent->runCycle();
}
void PmVoiceRecHandlerSm::SCI_AgAudioUpdate::internal_raise_sCO_CONNECTED(SCOStatus value)
{
	SCO_CONNECTED_value = value;
	SCO_CONNECTED_raised = true;
}
/* Functions for event SCO_DISCONNECTED in interface SCI_AgAudioUpdate */
void PmVoiceRecHandlerSm::SCI_AgAudioUpdate::raise_sCO_DISCONNECTED(SCOStatus value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgAudioUpdate_SCO_DISCONNECTED(SCI_AgAudioUpdate_SCO_DISCONNECTED, value));
	parent->runCycle();
}
void PmVoiceRecHandlerSm::SCI_AgAudioUpdate::internal_raise_sCO_DISCONNECTED(SCOStatus value)
{
	SCO_DISCONNECTED_value = value;
	SCO_DISCONNECTED_raised = true;
}
SCOStatus PmVoiceRecHandlerSm::SCI_AgAudioUpdate::get_scoStatus() const
{
	return scoStatus;
}

void PmVoiceRecHandlerSm::SCI_AgAudioUpdate::set_scoStatus(SCOStatus value)
{
	this->scoStatus = value;
}

PmVoiceRecHandlerSm::SCI_AMRequest* PmVoiceRecHandlerSm::getSCI_AMRequest()
{
	return &ifaceAMRequest;
}
AudioChannel PmVoiceRecHandlerSm::SCI_AMRequest::get_audioChannnelId() const
{
	return audioChannnelId;
}

void PmVoiceRecHandlerSm::SCI_AMRequest::set_audioChannnelId(AudioChannel value)
{
	this->audioChannnelId = value;
}

void PmVoiceRecHandlerSm::setSCI_AMRequest_OCB(SCI_AMRequest_OCB* operationCallback)
{
	ifaceAMRequest_OCB = operationCallback;
}
PmVoiceRecHandlerSm::SCI_AMResponse* PmVoiceRecHandlerSm::getSCI_AMResponse()
{
	return &ifaceAMResponse;
}
/* Functions for event VOICEREC_CHANNEL_GRANTED in interface SCI_AMResponse */
void PmVoiceRecHandlerSm::SCI_AMResponse::raise_vOICEREC_CHANNEL_GRANTED()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AMResponse_VOICEREC_CHANNEL_GRANTED(SCI_AMResponse_VOICEREC_CHANNEL_GRANTED));
	parent->runCycle();
}
void PmVoiceRecHandlerSm::SCI_AMResponse::internal_raise_vOICEREC_CHANNEL_GRANTED()
{
	VOICEREC_CHANNEL_GRANTED_raised = true;
}
/* Functions for event VOICEREC_CHANNEL_DENIED in interface SCI_AMResponse */
void PmVoiceRecHandlerSm::SCI_AMResponse::raise_vOICEREC_CHANNEL_DENIED(void * value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AMResponse_VOICEREC_CHANNEL_DENIED(SCI_AMResponse_VOICEREC_CHANNEL_DENIED, value));
	parent->runCycle();
}
void PmVoiceRecHandlerSm::SCI_AMResponse::internal_raise_vOICEREC_CHANNEL_DENIED(void * value)
{
	VOICEREC_CHANNEL_DENIED_value = value;
	VOICEREC_CHANNEL_DENIED_raised = true;
}
/* Functions for event PLAY_AUDIO_SUCCESS in interface SCI_AMResponse */
void PmVoiceRecHandlerSm::SCI_AMResponse::raise_pLAY_AUDIO_SUCCESS()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AMResponse_PLAY_AUDIO_SUCCESS(SCI_AMResponse_PLAY_AUDIO_SUCCESS));
	parent->runCycle();
}
void PmVoiceRecHandlerSm::SCI_AMResponse::internal_raise_pLAY_AUDIO_SUCCESS()
{
	PLAY_AUDIO_SUCCESS_raised = true;
}
/* Functions for event PLAY_AUDIO_FAILURE in interface SCI_AMResponse */
void PmVoiceRecHandlerSm::SCI_AMResponse::raise_pLAY_AUDIO_FAILURE(void * value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AMResponse_PLAY_AUDIO_FAILURE(SCI_AMResponse_PLAY_AUDIO_FAILURE, value));
	parent->runCycle();
}
void PmVoiceRecHandlerSm::SCI_AMResponse::internal_raise_pLAY_AUDIO_FAILURE(void * value)
{
	PLAY_AUDIO_FAILURE_value = value;
	PLAY_AUDIO_FAILURE_raised = true;
}
/* Functions for event PAUSE_AUDIO_SUCCESS in interface SCI_AMResponse */
void PmVoiceRecHandlerSm::SCI_AMResponse::raise_pAUSE_AUDIO_SUCCESS()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AMResponse_PAUSE_AUDIO_SUCCESS(SCI_AMResponse_PAUSE_AUDIO_SUCCESS));
	parent->runCycle();
}
void PmVoiceRecHandlerSm::SCI_AMResponse::internal_raise_pAUSE_AUDIO_SUCCESS()
{
	PAUSE_AUDIO_SUCCESS_raised = true;
}
/* Functions for event PAUSE_AUDIO_FAILURE in interface SCI_AMResponse */
void PmVoiceRecHandlerSm::SCI_AMResponse::raise_pAUSE_AUDIO_FAILURE(void * value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AMResponse_PAUSE_AUDIO_FAILURE(SCI_AMResponse_PAUSE_AUDIO_FAILURE, value));
	parent->runCycle();
}
void PmVoiceRecHandlerSm::SCI_AMResponse::internal_raise_pAUSE_AUDIO_FAILURE(void * value)
{
	PAUSE_AUDIO_FAILURE_value = value;
	PAUSE_AUDIO_FAILURE_raised = true;
}
/* Functions for event STOP_AUDIO_SUCCESS in interface SCI_AMResponse */
void PmVoiceRecHandlerSm::SCI_AMResponse::raise_sTOP_AUDIO_SUCCESS()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AMResponse_STOP_AUDIO_SUCCESS(SCI_AMResponse_STOP_AUDIO_SUCCESS));
	parent->runCycle();
}
void PmVoiceRecHandlerSm::SCI_AMResponse::internal_raise_sTOP_AUDIO_SUCCESS()
{
	STOP_AUDIO_SUCCESS_raised = true;
}
/* Functions for event STOP_AUDIO_FAILURE in interface SCI_AMResponse */
void PmVoiceRecHandlerSm::SCI_AMResponse::raise_sTOP_AUDIO_FAILURE(void * value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AMResponse_STOP_AUDIO_FAILURE(SCI_AMResponse_STOP_AUDIO_FAILURE, value));
	parent->runCycle();
}
void PmVoiceRecHandlerSm::SCI_AMResponse::internal_raise_sTOP_AUDIO_FAILURE(void * value)
{
	STOP_AUDIO_FAILURE_value = value;
	STOP_AUDIO_FAILURE_raised = true;
}
/* Functions for event VOICEREC_CHANNEL_RELEASED_EXT_TRIGGER in interface SCI_AMResponse */
void PmVoiceRecHandlerSm::SCI_AMResponse::raise_vOICEREC_CHANNEL_RELEASED_EXT_TRIGGER()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AMResponse_VOICEREC_CHANNEL_RELEASED_EXT_TRIGGER(SCI_AMResponse_VOICEREC_CHANNEL_RELEASED_EXT_TRIGGER));
	parent->runCycle();
}
void PmVoiceRecHandlerSm::SCI_AMResponse::internal_raise_vOICEREC_CHANNEL_RELEASED_EXT_TRIGGER()
{
	VOICEREC_CHANNEL_RELEASED_EXT_TRIGGER_raised = true;
}
/* Functions for event PHONE_CHANNEL_GRANTED in interface SCI_AMResponse */
void PmVoiceRecHandlerSm::SCI_AMResponse::raise_pHONE_CHANNEL_GRANTED()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AMResponse_PHONE_CHANNEL_GRANTED(SCI_AMResponse_PHONE_CHANNEL_GRANTED));
	parent->runCycle();
}
void PmVoiceRecHandlerSm::SCI_AMResponse::internal_raise_pHONE_CHANNEL_GRANTED()
{
	PHONE_CHANNEL_GRANTED_raised = true;
}
/* Functions for event PHONE_CHANNEL_DENIED in interface SCI_AMResponse */
void PmVoiceRecHandlerSm::SCI_AMResponse::raise_pHONE_CHANNEL_DENIED()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AMResponse_PHONE_CHANNEL_DENIED(SCI_AMResponse_PHONE_CHANNEL_DENIED));
	parent->runCycle();
}
void PmVoiceRecHandlerSm::SCI_AMResponse::internal_raise_pHONE_CHANNEL_DENIED()
{
	PHONE_CHANNEL_DENIED_raised = true;
}
/* Functions for event WAITINGMODE_CHANNEL_GRANTED in interface SCI_AMResponse */
void PmVoiceRecHandlerSm::SCI_AMResponse::raise_wAITINGMODE_CHANNEL_GRANTED()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AMResponse_WAITINGMODE_CHANNEL_GRANTED(SCI_AMResponse_WAITINGMODE_CHANNEL_GRANTED));
	parent->runCycle();
}
void PmVoiceRecHandlerSm::SCI_AMResponse::internal_raise_wAITINGMODE_CHANNEL_GRANTED()
{
	WAITINGMODE_CHANNEL_GRANTED_raised = true;
}
/* Functions for event WAITINGMODE_CHANNEL_DENIED in interface SCI_AMResponse */
void PmVoiceRecHandlerSm::SCI_AMResponse::raise_wAITINGMODE_CHANNEL_DENIED()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AMResponse_WAITINGMODE_CHANNEL_DENIED(SCI_AMResponse_WAITINGMODE_CHANNEL_DENIED));
	parent->runCycle();
}
void PmVoiceRecHandlerSm::SCI_AMResponse::internal_raise_wAITINGMODE_CHANNEL_DENIED()
{
	WAITINGMODE_CHANNEL_DENIED_raised = true;
}
PmVoiceRecHandlerSm::SCI_SmHandler* PmVoiceRecHandlerSm::getSCI_SmHandler()
{
	return &ifaceSmHandler;
}
void PmVoiceRecHandlerSm::setSCI_SmHandler_OCB(SCI_SmHandler_OCB* operationCallback)
{
	ifaceSmHandler_OCB = operationCallback;
}
PmVoiceRecHandlerSm::SCI_Timer* PmVoiceRecHandlerSm::getSCI_Timer()
{
	return &ifaceTimer;
}
/* Functions for event EXTENDED_VRSESSION_TIMER_CALLBACK in interface SCI_Timer */
void PmVoiceRecHandlerSm::SCI_Timer::raise_eXTENDED_VRSESSION_TIMER_CALLBACK()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_Timer_EXTENDED_VRSESSION_TIMER_CALLBACK(SCI_Timer_EXTENDED_VRSESSION_TIMER_CALLBACK));
	parent->runCycle();
}
void PmVoiceRecHandlerSm::SCI_Timer::internal_raise_eXTENDED_VRSESSION_TIMER_CALLBACK()
{
	EXTENDED_VRSESSION_TIMER_CALLBACK_raised = true;
}
void PmVoiceRecHandlerSm::setSCI_Timer_OCB(SCI_Timer_OCB* operationCallback)
{
	ifaceTimer_OCB = operationCallback;
}
PmVoiceRecHandlerSm::SCI_MediaPlayer* PmVoiceRecHandlerSm::getSCI_MediaPlayer()
{
	return &ifaceMediaPlayer;
}
/* Functions for event MEDIAREADYTOPLAY in interface SCI_MediaPlayer */
void PmVoiceRecHandlerSm::SCI_MediaPlayer::raise_mEDIAREADYTOPLAY()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_MediaPlayer_MEDIAREADYTOPLAY(SCI_MediaPlayer_MEDIAREADYTOPLAY));
	parent->runCycle();
}
void PmVoiceRecHandlerSm::SCI_MediaPlayer::internal_raise_mEDIAREADYTOPLAY()
{
	MEDIAREADYTOPLAY_raised = true;
}
/* Functions for event SWITCHED_TO_PASSIVE in interface InternalSCI */
void PmVoiceRecHandlerSm::InternalSCI::raise_sWITCHED_TO_PASSIVE()
{
	parent->internalEventQueue.push_back(new SctEvent_InternalSCI_SWITCHED_TO_PASSIVE(InternalSCI_SWITCHED_TO_PASSIVE));
	parent->runCycle();
}
void PmVoiceRecHandlerSm::InternalSCI::internal_raise_sWITCHED_TO_PASSIVE()
{
	SWITCHED_TO_PASSIVE_raised = true;
}
sc_boolean PmVoiceRecHandlerSm::InternalSCI::isRaised_sWITCHED_TO_PASSIVE() const
{
	return SWITCHED_TO_PASSIVE_raised;
}
/* Functions for event MOVE_TO_NEXT_STATE in interface InternalSCI */
void PmVoiceRecHandlerSm::InternalSCI::raise_mOVE_TO_NEXT_STATE()
{
	parent->internalEventQueue.push_back(new SctEvent_InternalSCI_MOVE_TO_NEXT_STATE(InternalSCI_MOVE_TO_NEXT_STATE));
	parent->runCycle();
}
void PmVoiceRecHandlerSm::InternalSCI::internal_raise_mOVE_TO_NEXT_STATE()
{
	MOVE_TO_NEXT_STATE_raised = true;
}
sc_boolean PmVoiceRecHandlerSm::InternalSCI::isRaised_mOVE_TO_NEXT_STATE() const
{
	return MOVE_TO_NEXT_STATE_raised;
}

void PmVoiceRecHandlerSm::setTraceObserver(ysc::TraceObserver<PmVoiceRecHandlerSmStates>* tracingcallback) {
	ifaceTraceObserver = tracingcallback;
}

ysc::TraceObserver<PmVoiceRecHandlerSm::PmVoiceRecHandlerSmStates>* PmVoiceRecHandlerSm::getTraceObserver() {
	return ifaceTraceObserver;
}

// implementations of all internal functions

sc_boolean PmVoiceRecHandlerSm::check_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region__choice_0_tr0_tr0()
{
	return (ifaceAgVRUpdate.vrState) == (false);
}

sc_boolean PmVoiceRecHandlerSm::check_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region__choice_0_tr0_tr0()
{
	return (ifaceAgAudioUpdate.scoStatus) == (SCO_NOT_ESTABLISHED);
}

sc_boolean PmVoiceRecHandlerSm::check_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region__choice_1_tr0_tr0()
{
	return (ifaceAgVRUpdate.vrState) == (false);
}

sc_boolean PmVoiceRecHandlerSm::check_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region__choice_2_tr0_tr0()
{
	return (ifaceAgVRUpdate.vrState) == (false);
}

sc_boolean PmVoiceRecHandlerSm::check_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region__choice_0_tr1_tr1()
{
	return (ifaceAgAudioUpdate.scoStatus) == (SCO_NOT_ESTABLISHED);
}

sc_boolean PmVoiceRecHandlerSm::check_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region__choice_0_tr1_tr1()
{
	return (ifaceAgAudioUpdate.scoStatus) == (SCO_NOT_ESTABLISHED);
}

sc_boolean PmVoiceRecHandlerSm::check_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region__choice_0_tr1_tr1()
{
	return (ifaceAgAudioUpdate.scoStatus) == (SCO_NOT_ESTABLISHED);
}

sc_boolean PmVoiceRecHandlerSm::check_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region__choice_1_tr0_tr0()
{
	return (AM_VOICERECOGNITION) == (ifaceAMRequest.audioChannnelId);
}

sc_boolean PmVoiceRecHandlerSm::check_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region__choice_0_tr1_tr1()
{
	return (ifaceAgAudioUpdate.scoStatus) == (SCO_NOT_ESTABLISHED);
}

void PmVoiceRecHandlerSm::effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_tr1()
{
	exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM();
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_IdleVoiceRecognitionSM_default();
	PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_react(false);
}

void PmVoiceRecHandlerSm::effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_tr0()
{
	exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR();
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_Idle();
}

void PmVoiceRecHandlerSm::effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_tr1()
{
	exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR();
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_DeactivateVREntry();
	PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_react(false);
}

void PmVoiceRecHandlerSm::effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_tr2()
{
	exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR();
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_default();
	PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_react(false);
}

void PmVoiceRecHandlerSm::effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_tr6()
{
	exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR();
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_default();
	PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_react(false);
}

void PmVoiceRecHandlerSm::effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_tr0()
{
	exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR();
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_Idle();
}

void PmVoiceRecHandlerSm::effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_tr2()
{
	exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR();
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_default();
	PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_react(false);
}

void PmVoiceRecHandlerSm::effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_tr4()
{
	exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM();
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_default();
	PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_react(false);
}

void PmVoiceRecHandlerSm::effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_tr0()
{
	exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease();
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region__choice_0();
}

void PmVoiceRecHandlerSm::effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_tr0()
{
	exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR();
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_Idle();
}

void PmVoiceRecHandlerSm::effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_tr1()
{
	exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR();
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_DeactivateVREntry();
	PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_react(false);
}

void PmVoiceRecHandlerSm::effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_tr2()
{
	exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR();
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_default();
	PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_react(false);
}

void PmVoiceRecHandlerSm::effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_tr6()
{
	exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR();
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_EntryToCheckSCOStatus();
	PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_react(false);
}

void PmVoiceRecHandlerSm::effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_tr0()
{
	exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive();
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_Idle();
}

void PmVoiceRecHandlerSm::effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_tr5()
{
	exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive();
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_default();
	PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_react(false);
}

void PmVoiceRecHandlerSm::effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_tr2()
{
	exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM();
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_IdleVoiceRecognitionSM_default();
	PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_react(false);
}

void PmVoiceRecHandlerSm::effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_tr4()
{
	exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM();
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_default();
	PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_react(false);
}

void PmVoiceRecHandlerSm::effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_tr1()
{
	exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR();
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_Idle();
}

void PmVoiceRecHandlerSm::effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_tr7()
{
	exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR();
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StartingExternalVR_default();
	PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_react(false);
}

void PmVoiceRecHandlerSm::effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region__choice_0_tr0()
{
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_ActivatingVRinAg_default();
}

void PmVoiceRecHandlerSm::effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region__choice_0_tr1()
{
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_default();
}

void PmVoiceRecHandlerSm::effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region__choice_0_tr0()
{
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForSCO_default();
}

void PmVoiceRecHandlerSm::effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region__choice_0_tr1()
{
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForStreaming_default();
}

void PmVoiceRecHandlerSm::effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region__choice_1_tr0()
{
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_Idle();
}

void PmVoiceRecHandlerSm::effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region__choice_1_tr1()
{
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_DeactivateVR();
}

void PmVoiceRecHandlerSm::effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region__choice_2_tr0()
{
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_ReleaseChannel();
}

void PmVoiceRecHandlerSm::effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region__choice_2_tr1()
{
	ifaceUserAction_OCB->deactivateVR();
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_ReleaseChannel();
}

void PmVoiceRecHandlerSm::effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region__choice_0_tr1()
{
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_Idle();
}

void PmVoiceRecHandlerSm::effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region__choice_0_tr0()
{
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitForSCORelease_default();
}

void PmVoiceRecHandlerSm::effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region__choice_0_tr1()
{
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_SCODisconnectionReceived_default();
}

void PmVoiceRecHandlerSm::effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region__choice_0_tr0()
{
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_WaitForSCODisconnection_default();
}

void PmVoiceRecHandlerSm::effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region__choice_0_tr1()
{
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_PostingRequestToAudioManager_default();
}

void PmVoiceRecHandlerSm::effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region__choice_0_tr0()
{
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitForSCODisconnect_default();
}

void PmVoiceRecHandlerSm::effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region__choice_1_tr0()
{
	ifaceSmHandler_OCB->updateswitchToPassiveResponse((sc_string) "Channel released due to Ext trigger");
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_Idle();
}

void PmVoiceRecHandlerSm::effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region__choice_1_tr1()
{
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_PostingRequestToAudioManager_default();
}

void PmVoiceRecHandlerSm::effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region__choice_0_tr1()
{
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_ExternalVRReadyAndWaitingForSCO_default();
}

void PmVoiceRecHandlerSm::effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region__choice_0_tr0()
{
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_WaitingForStreaming_default();
}

/* Entry action for state 'VoiceRecognitionHandlerSm'. */
void PmVoiceRecHandlerSm::enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm()
{
	/* Entry action for state 'VoiceRecognitionHandlerSm'. */
	ifaceUserAction_OCB->tempFunc(false);
}

/* Entry action for state 'StartingVR'. */
void PmVoiceRecHandlerSm::enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR()
{
	/* Entry action for state 'StartingVR'. */
	ifaceSmHandler_OCB->updateVRState(VR_SESSION_STARTING);
}

/* Entry action for state 'WaitingForChannelAllocation'. */
void PmVoiceRecHandlerSm::enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForChannelAllocation()
{
	/* Entry action for state 'WaitingForChannelAllocation'. */
	ifaceAMRequest_OCB->requestAudioChannel();
}

/* Entry action for state 'ActivatingVRinAg'. */
void PmVoiceRecHandlerSm::enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_ActivatingVRinAg()
{
	/* Entry action for state 'ActivatingVRinAg'. */
	ifaceUserAction_OCB->activateVR();
}

/* Entry action for state 'WaitingForStreaming'. */
void PmVoiceRecHandlerSm::enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForStreaming()
{
	/* Entry action for state 'WaitingForStreaming'. */
	ifaceAMRequest_OCB->playHfAudio(ifaceAgAudioUpdate.scoStatus);
}

/* Entry action for state 'StoppingVR'. */
void PmVoiceRecHandlerSm::enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR()
{
	/* Entry action for state 'StoppingVR'. */
	ifaceSmHandler_OCB->updateVRState(VR_SESSION_ENDING);
}

/* Entry action for state 'WaitingForAgResponse'. */
void PmVoiceRecHandlerSm::enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForAgResponse()
{
	/* Entry action for state 'WaitingForAgResponse'. */
	ifaceUserAction_OCB->deactivateVR();
}

/* Entry action for state 'WaitingForVoiceRecChannelRelease'. */
void PmVoiceRecHandlerSm::enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease()
{
	/* Entry action for state 'WaitingForVoiceRecChannelRelease'. */
	ifaceAMRequest_OCB->stopAudio();
}

/* Entry action for state 'ActiveVR'. */
void PmVoiceRecHandlerSm::enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR()
{
	/* Entry action for state 'ActiveVR'. */
	ifaceSmHandler_OCB->updateVRState(VR_SESSION_ACTIVE);
}

/* Entry action for state 'WaitingForTimerExpiry'. */
void PmVoiceRecHandlerSm::enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForTimerExpiry()
{
	/* Entry action for state 'WaitingForTimerExpiry'. */
	ifaceTimer_OCB->startExtendVRTimer();
}

/* Entry action for state 'PostingRequestToAudioManager'. */
void PmVoiceRecHandlerSm::enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_PostingRequestToAudioManager()
{
	/* Entry action for state 'PostingRequestToAudioManager'. */
	ifaceAMRequest_OCB->stopOrPauseHfAudio(ifaceAMRequest.audioChannnelId);
	internalEventQueue.push_back(new SctEvent_InternalSCI_MOVE_TO_NEXT_STATE(InternalSCI_MOVE_TO_NEXT_STATE));
}

/* Entry action for state 'DeactivationIndReceived'. */
void PmVoiceRecHandlerSm::enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_DeactivationIndReceived()
{
	/* Entry action for state 'DeactivationIndReceived'. */
	internalEventQueue.push_back(new SctEvent_InternalSCI_SWITCHED_TO_PASSIVE(InternalSCI_SWITCHED_TO_PASSIVE));
}

/* Entry action for state 'SCODisconnectionReceived'. */
void PmVoiceRecHandlerSm::enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_SCODisconnectionReceived()
{
	/* Entry action for state 'SCODisconnectionReceived'. */
	internalEventQueue.push_back(new SctEvent_InternalSCI_SWITCHED_TO_PASSIVE(InternalSCI_SWITCHED_TO_PASSIVE));
}

/* Entry action for state 'IdleVoiceRecognitionSM'. */
void PmVoiceRecHandlerSm::enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_IdleVoiceRecognitionSM()
{
	/* Entry action for state 'IdleVoiceRecognitionSM'. */
	ifaceAgVRUpdate.vrState = false;
}

/* Entry action for state 'StartingExternalVR'. */
void PmVoiceRecHandlerSm::enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StartingExternalVR()
{
	/* Entry action for state 'StartingExternalVR'. */
	ifaceAMRequest_OCB->requestAudioChannel();
}

/* Entry action for state 'ActiveExternalVR'. */
void PmVoiceRecHandlerSm::enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ActiveExternalVR()
{
	/* Entry action for state 'ActiveExternalVR'. */
	ifaceSmHandler_OCB->updateExternalVRState(EXT_VR_SESSION_ACTIVE);
}

/* Entry action for state 'ReadyExternalVR'. */
void PmVoiceRecHandlerSm::enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR()
{
	/* Entry action for state 'ReadyExternalVR'. */
	ifaceSmHandler_OCB->updateExternalVRState(EXT_VR_SESSION_READY);
}

/* Entry action for state 'WaitingForStreaming'. */
void PmVoiceRecHandlerSm::enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_WaitingForStreaming()
{
	/* Entry action for state 'WaitingForStreaming'. */
	ifaceAMRequest_OCB->playHfAudio(ifaceAgAudioUpdate.scoStatus);
}

/* Entry action for state 'StoppingExternalVR'. */
void PmVoiceRecHandlerSm::enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR()
{
	/* Entry action for state 'StoppingExternalVR'. */
	ifaceAMRequest_OCB->stopAudio();
}

/* Exit action for state 'voiceRecSM'. */
void PmVoiceRecHandlerSm::exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM()
{
	/* Exit action for state 'voiceRecSM'. */
	ifaceSmHandler_OCB->updateVRState(VR_SESSION_IDLE);
	ifaceSmHandler_OCB->processVRStopped();
}

/* Exit action for state 'externalVRSM'. */
void PmVoiceRecHandlerSm::exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM()
{
	/* Exit action for state 'externalVRSM'. */
	ifaceSmHandler_OCB->updateExternalVRState(EXT_VR_SESSION_IDLE);
	ifaceSmHandler_OCB->postGetCallsRequest2Btstack();
	ifaceSmHandler_OCB->processVRStopped();
}

/* 'default' enter sequence for state VoiceRecognitionHandlerSm */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_default()
{
	/* 'default' enter sequence for state VoiceRecognitionHandlerSm */
	enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm);
	}
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_default();
}

/* 'default' enter sequence for state voiceRecSM */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_default()
{
	/* 'default' enter sequence for state voiceRecSM */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM);
	}
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_default();
}

/* 'EntryTPoReleaseChannel2' enter sequence for state StartingVR */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_EntryTPoReleaseChannel2()
{
	/* 'EntryTPoReleaseChannel2' enter sequence for state StartingVR */
	enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR);
	}
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_EntryTPoReleaseChannel2();
}

/* 'EntryToIdleOrDeactivateVR' enter sequence for state StartingVR */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_EntryToIdleOrDeactivateVR()
{
	/* 'EntryToIdleOrDeactivateVR' enter sequence for state StartingVR */
	enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR);
	}
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_EntryToIdleOrDeactivateVR();
}

/* 'EntryToReleaseChannel' enter sequence for state StartingVR */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_EntryToReleaseChannel()
{
	/* 'EntryToReleaseChannel' enter sequence for state StartingVR */
	enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR);
	}
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_EntryToReleaseChannel();
}

/* 'default' enter sequence for state StartingVR */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_default()
{
	/* 'default' enter sequence for state StartingVR */
	enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR);
	}
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_default();
}

/* 'default' enter sequence for state WaitingForChannelAllocation */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForChannelAllocation_default()
{
	/* 'default' enter sequence for state WaitingForChannelAllocation */
	enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForChannelAllocation();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForChannelAllocation);
	}
	stateConfVector[0] = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForChannelAllocation;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state ActivatingVRinAg */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_ActivatingVRinAg_default()
{
	/* 'default' enter sequence for state ActivatingVRinAg */
	enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_ActivatingVRinAg();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_ActivatingVRinAg);
	}
	stateConfVector[0] = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_ActivatingVRinAg;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitingForStreaming */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_default()
{
	/* 'default' enter sequence for state WaitingForStreaming */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming);
	}
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_default();
}

/* 'default' enter sequence for state WaitingForSCO */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForSCO_default()
{
	/* 'default' enter sequence for state WaitingForSCO */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForSCO);
	}
	stateConfVector[0] = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForSCO;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitingForStreaming */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForStreaming_default()
{
	/* 'default' enter sequence for state WaitingForStreaming */
	enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForStreaming();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForStreaming);
	}
	stateConfVector[0] = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForStreaming;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitingForAgResponseToDeactivateVR */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForAgResponseToDeactivateVR_default()
{
	/* 'default' enter sequence for state WaitingForAgResponseToDeactivateVR */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForAgResponseToDeactivateVR);
	}
	stateConfVector[0] = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForAgResponseToDeactivateVR;
	stateConfVectorPosition = 0;
}

/* 'DeactivateVREntry' enter sequence for state StoppingVR */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_DeactivateVREntry()
{
	/* 'DeactivateVREntry' enter sequence for state StoppingVR */
	enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR);
	}
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_DeactivateVREntry();
}

/* 'EntryToActivateVR' enter sequence for state StoppingVR */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_EntryToActivateVR()
{
	/* 'EntryToActivateVR' enter sequence for state StoppingVR */
	enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR);
	}
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_EntryToActivateVR();
}

/* 'EntryToIdleOrWaitForSCORelease' enter sequence for state StoppingVR */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_EntryToIdleOrWaitForSCORelease()
{
	/* 'EntryToIdleOrWaitForSCORelease' enter sequence for state StoppingVR */
	enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR);
	}
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_EntryToIdleOrWaitForSCORelease();
}

/* 'default' enter sequence for state StoppingVR */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_default()
{
	/* 'default' enter sequence for state StoppingVR */
	enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR);
	}
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_default();
}

/* 'default' enter sequence for state WaitingForAgResponse */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForAgResponse_default()
{
	/* 'default' enter sequence for state WaitingForAgResponse */
	enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForAgResponse();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForAgResponse);
	}
	stateConfVector[0] = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForAgResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitingForVoiceRecChannelRelease */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_default()
{
	/* 'default' enter sequence for state WaitingForVoiceRecChannelRelease */
	enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease);
	}
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_default();
}

/* 'default' enter sequence for state WaitingForChannelRelease */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelRelease_default()
{
	/* 'default' enter sequence for state WaitingForChannelRelease */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelRelease);
	}
	stateConfVector[0] = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelRelease;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitingForChannelReleaseToStartExtVR */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartExtVR_default()
{
	/* 'default' enter sequence for state WaitingForChannelReleaseToStartExtVR */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartExtVR);
	}
	stateConfVector[0] = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartExtVR;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitingForChannelReleaseToStartVR */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartVR_default()
{
	/* 'default' enter sequence for state WaitingForChannelReleaseToStartVR */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartVR);
	}
	stateConfVector[0] = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartVR;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForSCORelease */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitForSCORelease_default()
{
	/* 'default' enter sequence for state WaitForSCORelease */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitForSCORelease);
	}
	stateConfVector[0] = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitForSCORelease;
	stateConfVectorPosition = 0;
}

/* 'EntryToActive' enter sequence for state ActiveVR */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_EntryToActive()
{
	/* 'EntryToActive' enter sequence for state ActiveVR */
	enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR);
	}
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_EntryToActive();
}

/* 'EntryToReleaseChannel' enter sequence for state ActiveVR */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_EntryToReleaseChannel()
{
	/* 'EntryToReleaseChannel' enter sequence for state ActiveVR */
	enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR);
	}
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_EntryToReleaseChannel();
}

/* 'default' enter sequence for state ActiveVR */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_default()
{
	/* 'default' enter sequence for state ActiveVR */
	enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR);
	}
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_default();
}

/* 'default' enter sequence for state Active */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_Active_default()
{
	/* 'default' enter sequence for state Active */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_Active);
	}
	stateConfVector[0] = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_Active;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitingForTimerExpiry */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForTimerExpiry_default()
{
	/* 'default' enter sequence for state WaitingForTimerExpiry */
	enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForTimerExpiry();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForTimerExpiry);
	}
	stateConfVector[0] = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForTimerExpiry;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitingForDeactivationIndToRelChannel */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForDeactivationIndToRelChannel_default()
{
	/* 'default' enter sequence for state WaitingForDeactivationIndToRelChannel */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForDeactivationIndToRelChannel);
	}
	stateConfVector[0] = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForDeactivationIndToRelChannel;
	stateConfVectorPosition = 0;
}

/* 'EntryToCheckSCOStatus' enter sequence for state SwitchToPassive */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_EntryToCheckSCOStatus()
{
	/* 'EntryToCheckSCOStatus' enter sequence for state SwitchToPassive */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive);
	}
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_EntryToCheckSCOStatus();
}

/* 'EntryToIdle' enter sequence for state SwitchToPassive */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_EntryToIdle()
{
	/* 'EntryToIdle' enter sequence for state SwitchToPassive */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive);
	}
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_EntryToIdle();
}

/* 'EntryToIdleOrPostingRequestToAudioManager' enter sequence for state SwitchToPassive */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_EntryToIdleOrPostingRequestToAudioManager()
{
	/* 'EntryToIdleOrPostingRequestToAudioManager' enter sequence for state SwitchToPassive */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive);
	}
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_EntryToIdleOrPostingRequestToAudioManager();
}

/* 'default' enter sequence for state SwitchToPassive */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_default()
{
	/* 'default' enter sequence for state SwitchToPassive */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive);
	}
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_default();
}

/* 'default' enter sequence for state PostingRequestToAudioManager */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_PostingRequestToAudioManager_default()
{
	/* 'default' enter sequence for state PostingRequestToAudioManager */
	enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_PostingRequestToAudioManager();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_PostingRequestToAudioManager);
	}
	stateConfVector[0] = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_PostingRequestToAudioManager;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitingForDeactivationInd */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_WaitingForDeactivationInd_default()
{
	/* 'default' enter sequence for state WaitingForDeactivationInd */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_WaitingForDeactivationInd);
	}
	stateConfVector[0] = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_WaitingForDeactivationInd;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state DeactivationIndReceived */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_DeactivationIndReceived_default()
{
	/* 'default' enter sequence for state DeactivationIndReceived */
	enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_DeactivationIndReceived();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_DeactivationIndReceived);
	}
	stateConfVector[0] = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_DeactivationIndReceived;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForSCODisconnection */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_WaitForSCODisconnection_default()
{
	/* 'default' enter sequence for state WaitForSCODisconnection */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_WaitForSCODisconnection);
	}
	stateConfVector[1] = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_WaitForSCODisconnection;
	stateConfVectorPosition = 1;
}

/* 'default' enter sequence for state SCODisconnectionReceived */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_SCODisconnectionReceived_default()
{
	/* 'default' enter sequence for state SCODisconnectionReceived */
	enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_SCODisconnectionReceived();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_SCODisconnectionReceived);
	}
	stateConfVector[1] = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_SCODisconnectionReceived;
	stateConfVectorPosition = 1;
}

/* 'default' enter sequence for state WaitForSCODisconnect */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitForSCODisconnect_default()
{
	/* 'default' enter sequence for state WaitForSCODisconnect */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitForSCODisconnect);
	}
	stateConfVector[0] = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitForSCODisconnect;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state IdleVoiceRecognitionSM */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_IdleVoiceRecognitionSM_default()
{
	/* 'default' enter sequence for state IdleVoiceRecognitionSM */
	enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_IdleVoiceRecognitionSM();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_IdleVoiceRecognitionSM);
	}
	stateConfVector[0] = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_IdleVoiceRecognitionSM;
	stateConfVectorPosition = 0;
}

/* 'EntryToIdle1' enter sequence for state externalVRSM */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_EntryToIdle1()
{
	/* 'EntryToIdle1' enter sequence for state externalVRSM */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM);
	}
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_EntryToIdle1();
}

/* 'EntryToIdle3' enter sequence for state externalVRSM */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_EntryToIdle3()
{
	/* 'EntryToIdle3' enter sequence for state externalVRSM */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM);
	}
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_EntryToIdle3();
}

/* 'EntryToIdle5' enter sequence for state externalVRSM */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_EntryToIdle5()
{
	/* 'EntryToIdle5' enter sequence for state externalVRSM */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM);
	}
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_EntryToIdle5();
}

/* 'EntryToStoppingExternalVR' enter sequence for state externalVRSM */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_EntryToStoppingExternalVR()
{
	/* 'EntryToStoppingExternalVR' enter sequence for state externalVRSM */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM);
	}
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_EntryToStoppingExternalVR();
}

/* 'default' enter sequence for state externalVRSM */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_default()
{
	/* 'default' enter sequence for state externalVRSM */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM);
	}
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_default();
}

/* 'default' enter sequence for state StartingExternalVR */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StartingExternalVR_default()
{
	/* 'default' enter sequence for state StartingExternalVR */
	enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StartingExternalVR();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StartingExternalVR);
	}
	stateConfVector[0] = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StartingExternalVR;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state ActiveExternalVR */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ActiveExternalVR_default()
{
	/* 'default' enter sequence for state ActiveExternalVR */
	enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ActiveExternalVR();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ActiveExternalVR);
	}
	stateConfVector[0] = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ActiveExternalVR;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state ReadyExternalVR */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_default()
{
	/* 'default' enter sequence for state ReadyExternalVR */
	enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR);
	}
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_default();
}

/* 'default' enter sequence for state ExternalVRReadyAndWaitingForSCO */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_ExternalVRReadyAndWaitingForSCO_default()
{
	/* 'default' enter sequence for state ExternalVRReadyAndWaitingForSCO */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_ExternalVRReadyAndWaitingForSCO);
	}
	stateConfVector[0] = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_ExternalVRReadyAndWaitingForSCO;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitingForStreaming */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_WaitingForStreaming_default()
{
	/* 'default' enter sequence for state WaitingForStreaming */
	enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_WaitingForStreaming();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_WaitingForStreaming);
	}
	stateConfVector[0] = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_WaitingForStreaming;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state StoppingExternalVR */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_default()
{
	/* 'default' enter sequence for state StoppingExternalVR */
	enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR);
	}
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_default();
}

/* 'default' enter sequence for state WaitingForChannelRelease */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelRelease_default()
{
	/* 'default' enter sequence for state WaitingForChannelRelease */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelRelease);
	}
	stateConfVector[0] = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelRelease;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitingForChannelReleaseToStartExtVR */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartExtVR_default()
{
	/* 'default' enter sequence for state WaitingForChannelReleaseToStartExtVR */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartExtVR);
	}
	stateConfVector[0] = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartExtVR;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitingForChannelReleaseToStartVR */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartVR_default()
{
	/* 'default' enter sequence for state WaitingForChannelReleaseToStartVR */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartVR);
	}
	stateConfVector[0] = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartVR;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for region PmVoiceRecHandlerSm_Region */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_default()
{
	/* 'default' enter sequence for region PmVoiceRecHandlerSm_Region */
	react_PmVoiceRecHandlerSm_Region__entry_Default();
}

/* 'default' enter sequence for region VoiceRecognitionHandlerSm_Region */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_default()
{
	/* 'default' enter sequence for region VoiceRecognitionHandlerSm_Region */
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region__entry_Default();
}

/* 'default' enter sequence for region voiceRecSM_Region */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_default()
{
	/* 'default' enter sequence for region voiceRecSM_Region */
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region__entry_Default();
}

/* 'default' enter sequence for region StartingVR_Region */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_default()
{
	/* 'default' enter sequence for region StartingVR_Region */
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region__entry_Default();
}

/* 'EntryToIdleOrDeactivateVR' enter sequence for region StartingVR_Region */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_EntryToIdleOrDeactivateVR()
{
	/* 'EntryToIdleOrDeactivateVR' enter sequence for region StartingVR_Region */
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_EntryToIdleOrDeactivateVR();
}

/* 'EntryTPoReleaseChannel2' enter sequence for region StartingVR_Region */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_EntryTPoReleaseChannel2()
{
	/* 'EntryTPoReleaseChannel2' enter sequence for region StartingVR_Region */
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_EntryTPoReleaseChannel2();
}

/* 'EntryToReleaseChannel' enter sequence for region StartingVR_Region */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_EntryToReleaseChannel()
{
	/* 'EntryToReleaseChannel' enter sequence for region StartingVR_Region */
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_EntryToReleaseChannel();
}

/* 'default' enter sequence for region WaitingForStreaming_Region */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_default()
{
	/* 'default' enter sequence for region WaitingForStreaming_Region */
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region__entry_Default();
}

/* 'DeactivateVREntry' enter sequence for region StoppingVR_Region */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_DeactivateVREntry()
{
	/* 'DeactivateVREntry' enter sequence for region StoppingVR_Region */
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_DeactivateVREntry();
}

/* 'default' enter sequence for region StoppingVR_Region */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_default()
{
	/* 'default' enter sequence for region StoppingVR_Region */
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region__entry_Default();
}

/* 'EntryToActivateVR' enter sequence for region StoppingVR_Region */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_EntryToActivateVR()
{
	/* 'EntryToActivateVR' enter sequence for region StoppingVR_Region */
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_EntryToActivateVR();
}

/* 'EntryToIdleOrWaitForSCORelease' enter sequence for region StoppingVR_Region */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_EntryToIdleOrWaitForSCORelease()
{
	/* 'EntryToIdleOrWaitForSCORelease' enter sequence for region StoppingVR_Region */
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_EntryToIdleOrWaitForSCORelease();
}

/* 'default' enter sequence for region WaitingForVoiceRecChannelRelease_Region */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_default()
{
	/* 'default' enter sequence for region WaitingForVoiceRecChannelRelease_Region */
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region__entry_Default();
}

/* 'default' enter sequence for region ActiveVR_Region */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_default()
{
	/* 'default' enter sequence for region ActiveVR_Region */
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region__entry_Default();
}

/* 'EntryToActive' enter sequence for region ActiveVR_Region */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_EntryToActive()
{
	/* 'EntryToActive' enter sequence for region ActiveVR_Region */
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_EntryToActive();
}

/* 'EntryToReleaseChannel' enter sequence for region ActiveVR_Region */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_EntryToReleaseChannel()
{
	/* 'EntryToReleaseChannel' enter sequence for region ActiveVR_Region */
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_EntryToReleaseChannel();
}

/* 'default' enter sequence for region SwitchToPassive_Region */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_default()
{
	/* 'default' enter sequence for region SwitchToPassive_Region */
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region__entry_Default();
}

/* 'EntryToCheckSCOStatus' enter sequence for region SwitchToPassive_Region */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_EntryToCheckSCOStatus()
{
	/* 'EntryToCheckSCOStatus' enter sequence for region SwitchToPassive_Region */
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_EntryToCheckSCOStatus();
}

/* 'EntryToIdle' enter sequence for region SwitchToPassive_Region */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_EntryToIdle()
{
	/* 'EntryToIdle' enter sequence for region SwitchToPassive_Region */
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_EntryToIdle();
}

/* 'EntryToIdleOrPostingRequestToAudioManager' enter sequence for region SwitchToPassive_Region */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_EntryToIdleOrPostingRequestToAudioManager()
{
	/* 'EntryToIdleOrPostingRequestToAudioManager' enter sequence for region SwitchToPassive_Region */
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_EntryToIdleOrPostingRequestToAudioManager();
}

/* 'default' enter sequence for region externalVRSM_Region */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_default()
{
	/* 'default' enter sequence for region externalVRSM_Region */
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region__entry_Default();
}

/* 'EntryToIdle1' enter sequence for region externalVRSM_Region */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_EntryToIdle1()
{
	/* 'EntryToIdle1' enter sequence for region externalVRSM_Region */
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_EntryToIdle1();
}

/* 'EntryToIdle3' enter sequence for region externalVRSM_Region */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_EntryToIdle3()
{
	/* 'EntryToIdle3' enter sequence for region externalVRSM_Region */
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_EntryToIdle3();
}

/* 'EntryToIdle5' enter sequence for region externalVRSM_Region */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_EntryToIdle5()
{
	/* 'EntryToIdle5' enter sequence for region externalVRSM_Region */
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_EntryToIdle5();
}

/* 'EntryToStoppingExternalVR' enter sequence for region externalVRSM_Region */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_EntryToStoppingExternalVR()
{
	/* 'EntryToStoppingExternalVR' enter sequence for region externalVRSM_Region */
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_EntryToStoppingExternalVR();
}

/* 'default' enter sequence for region ReadyExternalVR_Region */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_default()
{
	/* 'default' enter sequence for region ReadyExternalVR_Region */
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region__entry_Default();
}

/* 'default' enter sequence for region StoppingExternalVR_Region */
void PmVoiceRecHandlerSm::enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_default()
{
	/* 'default' enter sequence for region StoppingExternalVR_Region */
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region__entry_Default();
}

/* Default exit sequence for state voiceRecSM */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM()
{
	/* Default exit sequence for state voiceRecSM */
	exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region();
	exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM();
}

/* Default exit sequence for state StartingVR */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR()
{
	/* Default exit sequence for state StartingVR */
	exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region();
}

/* Default exit sequence for state WaitingForChannelAllocation */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForChannelAllocation()
{
	/* Default exit sequence for state WaitingForChannelAllocation */
	stateConfVector[0] = PmVoiceRecHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state ActivatingVRinAg */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_ActivatingVRinAg()
{
	/* Default exit sequence for state ActivatingVRinAg */
	stateConfVector[0] = PmVoiceRecHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitingForStreaming */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming()
{
	/* Default exit sequence for state WaitingForStreaming */
	exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region();
}

/* Default exit sequence for state WaitingForSCO */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForSCO()
{
	/* Default exit sequence for state WaitingForSCO */
	stateConfVector[0] = PmVoiceRecHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitingForStreaming */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForStreaming()
{
	/* Default exit sequence for state WaitingForStreaming */
	stateConfVector[0] = PmVoiceRecHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitingForAgResponseToDeactivateVR */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForAgResponseToDeactivateVR()
{
	/* Default exit sequence for state WaitingForAgResponseToDeactivateVR */
	stateConfVector[0] = PmVoiceRecHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state StoppingVR */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR()
{
	/* Default exit sequence for state StoppingVR */
	exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region();
}

/* Default exit sequence for state WaitingForAgResponse */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForAgResponse()
{
	/* Default exit sequence for state WaitingForAgResponse */
	stateConfVector[0] = PmVoiceRecHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitingForVoiceRecChannelRelease */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease()
{
	/* Default exit sequence for state WaitingForVoiceRecChannelRelease */
	exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region();
}

/* Default exit sequence for state WaitingForChannelRelease */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelRelease()
{
	/* Default exit sequence for state WaitingForChannelRelease */
	stateConfVector[0] = PmVoiceRecHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitingForChannelReleaseToStartExtVR */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartExtVR()
{
	/* Default exit sequence for state WaitingForChannelReleaseToStartExtVR */
	stateConfVector[0] = PmVoiceRecHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitingForChannelReleaseToStartVR */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartVR()
{
	/* Default exit sequence for state WaitingForChannelReleaseToStartVR */
	stateConfVector[0] = PmVoiceRecHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForSCORelease */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitForSCORelease()
{
	/* Default exit sequence for state WaitForSCORelease */
	stateConfVector[0] = PmVoiceRecHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state ActiveVR */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR()
{
	/* Default exit sequence for state ActiveVR */
	exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region();
}

/* Default exit sequence for state Active */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_Active()
{
	/* Default exit sequence for state Active */
	stateConfVector[0] = PmVoiceRecHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitingForTimerExpiry */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForTimerExpiry()
{
	/* Default exit sequence for state WaitingForTimerExpiry */
	stateConfVector[0] = PmVoiceRecHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitingForDeactivationIndToRelChannel */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForDeactivationIndToRelChannel()
{
	/* Default exit sequence for state WaitingForDeactivationIndToRelChannel */
	stateConfVector[0] = PmVoiceRecHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state SwitchToPassive */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive()
{
	/* Default exit sequence for state SwitchToPassive */
	exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region();
}

/* Default exit sequence for state PostingRequestToAudioManager */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_PostingRequestToAudioManager()
{
	/* Default exit sequence for state PostingRequestToAudioManager */
	stateConfVector[0] = PmVoiceRecHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitingForDeactivationIndAndSCODisconnect */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect()
{
	/* Default exit sequence for state WaitingForDeactivationIndAndSCODisconnect */
	exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region();
	exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region();
}

/* Default exit sequence for state WaitingForDeactivationInd */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_WaitingForDeactivationInd()
{
	/* Default exit sequence for state WaitingForDeactivationInd */
	stateConfVector[0] = PmVoiceRecHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state DeactivationIndReceived */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_DeactivationIndReceived()
{
	/* Default exit sequence for state DeactivationIndReceived */
	stateConfVector[0] = PmVoiceRecHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForSCODisconnection */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_WaitForSCODisconnection()
{
	/* Default exit sequence for state WaitForSCODisconnection */
	stateConfVector[1] = PmVoiceRecHandlerSm_last_state;
	stateConfVectorPosition = 1;
}

/* Default exit sequence for state SCODisconnectionReceived */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_SCODisconnectionReceived()
{
	/* Default exit sequence for state SCODisconnectionReceived */
	stateConfVector[1] = PmVoiceRecHandlerSm_last_state;
	stateConfVectorPosition = 1;
}

/* Default exit sequence for state WaitForSCODisconnect */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitForSCODisconnect()
{
	/* Default exit sequence for state WaitForSCODisconnect */
	stateConfVector[0] = PmVoiceRecHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state IdleVoiceRecognitionSM */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_IdleVoiceRecognitionSM()
{
	/* Default exit sequence for state IdleVoiceRecognitionSM */
	stateConfVector[0] = PmVoiceRecHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state externalVRSM */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM()
{
	/* Default exit sequence for state externalVRSM */
	exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region();
	exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM();
}

/* Default exit sequence for state StartingExternalVR */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StartingExternalVR()
{
	/* Default exit sequence for state StartingExternalVR */
	stateConfVector[0] = PmVoiceRecHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state ActiveExternalVR */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ActiveExternalVR()
{
	/* Default exit sequence for state ActiveExternalVR */
	stateConfVector[0] = PmVoiceRecHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state ReadyExternalVR */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR()
{
	/* Default exit sequence for state ReadyExternalVR */
	exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region();
}

/* Default exit sequence for state ExternalVRReadyAndWaitingForSCO */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_ExternalVRReadyAndWaitingForSCO()
{
	/* Default exit sequence for state ExternalVRReadyAndWaitingForSCO */
	stateConfVector[0] = PmVoiceRecHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitingForStreaming */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_WaitingForStreaming()
{
	/* Default exit sequence for state WaitingForStreaming */
	stateConfVector[0] = PmVoiceRecHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state StoppingExternalVR */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR()
{
	/* Default exit sequence for state StoppingExternalVR */
	exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region();
}

/* Default exit sequence for state WaitingForChannelRelease */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelRelease()
{
	/* Default exit sequence for state WaitingForChannelRelease */
	stateConfVector[0] = PmVoiceRecHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitingForChannelReleaseToStartExtVR */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartExtVR()
{
	/* Default exit sequence for state WaitingForChannelReleaseToStartExtVR */
	stateConfVector[0] = PmVoiceRecHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitingForChannelReleaseToStartVR */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartVR()
{
	/* Default exit sequence for state WaitingForChannelReleaseToStartVR */
	stateConfVector[0] = PmVoiceRecHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for region PmVoiceRecHandlerSm_Region */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region()
{
	/* Default exit sequence for region PmVoiceRecHandlerSm_Region */
	/* Handle exit of all possible states (of PmVoiceRecHandlerSm.PmVoiceRecHandlerSm_Region) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForChannelAllocation :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForChannelAllocation();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_ActivatingVRinAg :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_ActivatingVRinAg();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForSCO :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForSCO();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForStreaming :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForStreaming();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForAgResponseToDeactivateVR :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForAgResponseToDeactivateVR();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForAgResponse :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForAgResponse();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelRelease :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelRelease();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartExtVR :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartExtVR();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartVR :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartVR();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitForSCORelease :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitForSCORelease();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_Active :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_Active();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForTimerExpiry :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForTimerExpiry();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForDeactivationIndToRelChannel :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForDeactivationIndToRelChannel();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_PostingRequestToAudioManager :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_PostingRequestToAudioManager();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_WaitingForDeactivationInd :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_WaitingForDeactivationInd();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_DeactivationIndReceived :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_DeactivationIndReceived();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitForSCODisconnect :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitForSCODisconnect();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_IdleVoiceRecognitionSM :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_IdleVoiceRecognitionSM();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StartingExternalVR :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StartingExternalVR();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ActiveExternalVR :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ActiveExternalVR();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_ExternalVRReadyAndWaitingForSCO :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_ExternalVRReadyAndWaitingForSCO();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_WaitingForStreaming :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_WaitingForStreaming();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelRelease :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelRelease();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartExtVR :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartExtVR();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartVR :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartVR();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM();
			break;
		}
		default: break;
	}
	/* Handle exit of all possible states (of PmVoiceRecHandlerSm.PmVoiceRecHandlerSm_Region) at position 1... */
	switch(stateConfVector[ 1 ])
	{
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_WaitForSCODisconnection :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_WaitForSCODisconnection();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_SCODisconnectionReceived :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_SCODisconnectionReceived();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region VoiceRecognitionHandlerSm_Region */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region()
{
	/* Default exit sequence for region VoiceRecognitionHandlerSm_Region */
	/* Handle exit of all possible states (of PmVoiceRecHandlerSm.PmVoiceRecHandlerSm_Region.VoiceRecognitionHandlerSm.VoiceRecognitionHandlerSm_Region) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForChannelAllocation :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForChannelAllocation();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_ActivatingVRinAg :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_ActivatingVRinAg();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForSCO :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForSCO();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForStreaming :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForStreaming();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForAgResponseToDeactivateVR :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForAgResponseToDeactivateVR();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForAgResponse :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForAgResponse();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelRelease :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelRelease();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartExtVR :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartExtVR();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartVR :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartVR();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitForSCORelease :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitForSCORelease();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_Active :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_Active();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForTimerExpiry :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForTimerExpiry();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForDeactivationIndToRelChannel :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForDeactivationIndToRelChannel();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_PostingRequestToAudioManager :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_PostingRequestToAudioManager();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_WaitingForDeactivationInd :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_WaitingForDeactivationInd();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_DeactivationIndReceived :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_DeactivationIndReceived();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitForSCODisconnect :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitForSCODisconnect();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_IdleVoiceRecognitionSM :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_IdleVoiceRecognitionSM();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StartingExternalVR :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StartingExternalVR();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ActiveExternalVR :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ActiveExternalVR();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_ExternalVRReadyAndWaitingForSCO :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_ExternalVRReadyAndWaitingForSCO();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_WaitingForStreaming :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_WaitingForStreaming();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelRelease :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelRelease();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartExtVR :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartExtVR();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartVR :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartVR();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM();
			break;
		}
		default: break;
	}
	/* Handle exit of all possible states (of PmVoiceRecHandlerSm.PmVoiceRecHandlerSm_Region.VoiceRecognitionHandlerSm.VoiceRecognitionHandlerSm_Region) at position 1... */
	switch(stateConfVector[ 1 ])
	{
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_WaitForSCODisconnection :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_WaitForSCODisconnection();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_SCODisconnectionReceived :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_SCODisconnectionReceived();
			exact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region voiceRecSM_Region */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region()
{
	/* Default exit sequence for region voiceRecSM_Region */
	/* Handle exit of all possible states (of PmVoiceRecHandlerSm.PmVoiceRecHandlerSm_Region.VoiceRecognitionHandlerSm.VoiceRecognitionHandlerSm_Region.voiceRecSM.voiceRecSM_Region) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForChannelAllocation :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForChannelAllocation();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_ActivatingVRinAg :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_ActivatingVRinAg();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForSCO :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForSCO();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForStreaming :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForStreaming();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForAgResponseToDeactivateVR :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForAgResponseToDeactivateVR();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForAgResponse :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForAgResponse();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelRelease :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelRelease();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartExtVR :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartExtVR();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartVR :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartVR();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitForSCORelease :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitForSCORelease();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_Active :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_Active();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForTimerExpiry :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForTimerExpiry();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForDeactivationIndToRelChannel :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForDeactivationIndToRelChannel();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_PostingRequestToAudioManager :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_PostingRequestToAudioManager();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_WaitingForDeactivationInd :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_WaitingForDeactivationInd();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_DeactivationIndReceived :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_DeactivationIndReceived();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitForSCODisconnect :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitForSCODisconnect();
			break;
		}
		default: break;
	}
	/* Handle exit of all possible states (of PmVoiceRecHandlerSm.PmVoiceRecHandlerSm_Region.VoiceRecognitionHandlerSm.VoiceRecognitionHandlerSm_Region.voiceRecSM.voiceRecSM_Region) at position 1... */
	switch(stateConfVector[ 1 ])
	{
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_WaitForSCODisconnection :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_WaitForSCODisconnection();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_SCODisconnectionReceived :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_SCODisconnectionReceived();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region StartingVR_Region */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region()
{
	/* Default exit sequence for region StartingVR_Region */
	/* Handle exit of all possible states (of PmVoiceRecHandlerSm.PmVoiceRecHandlerSm_Region.VoiceRecognitionHandlerSm.VoiceRecognitionHandlerSm_Region.voiceRecSM.voiceRecSM_Region.StartingVR.StartingVR_Region) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForChannelAllocation :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForChannelAllocation();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_ActivatingVRinAg :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_ActivatingVRinAg();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForSCO :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForSCO();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForStreaming :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForStreaming();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForAgResponseToDeactivateVR :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForAgResponseToDeactivateVR();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region WaitingForStreaming_Region */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region()
{
	/* Default exit sequence for region WaitingForStreaming_Region */
	/* Handle exit of all possible states (of PmVoiceRecHandlerSm.PmVoiceRecHandlerSm_Region.VoiceRecognitionHandlerSm.VoiceRecognitionHandlerSm_Region.voiceRecSM.voiceRecSM_Region.StartingVR.StartingVR_Region.WaitingForStreaming.WaitingForStreaming_Region) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForSCO :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForSCO();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForStreaming :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForStreaming();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region StoppingVR_Region */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region()
{
	/* Default exit sequence for region StoppingVR_Region */
	/* Handle exit of all possible states (of PmVoiceRecHandlerSm.PmVoiceRecHandlerSm_Region.VoiceRecognitionHandlerSm.VoiceRecognitionHandlerSm_Region.voiceRecSM.voiceRecSM_Region.StoppingVR.StoppingVR_Region) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForAgResponse :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForAgResponse();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelRelease :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelRelease();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartExtVR :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartExtVR();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartVR :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartVR();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitForSCORelease :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitForSCORelease();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region WaitingForVoiceRecChannelRelease_Region */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region()
{
	/* Default exit sequence for region WaitingForVoiceRecChannelRelease_Region */
	/* Handle exit of all possible states (of PmVoiceRecHandlerSm.PmVoiceRecHandlerSm_Region.VoiceRecognitionHandlerSm.VoiceRecognitionHandlerSm_Region.voiceRecSM.voiceRecSM_Region.StoppingVR.StoppingVR_Region.WaitingForVoiceRecChannelRelease.WaitingForVoiceRecChannelRelease_Region) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelRelease :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelRelease();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartExtVR :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartExtVR();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartVR :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartVR();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region ActiveVR_Region */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region()
{
	/* Default exit sequence for region ActiveVR_Region */
	/* Handle exit of all possible states (of PmVoiceRecHandlerSm.PmVoiceRecHandlerSm_Region.VoiceRecognitionHandlerSm.VoiceRecognitionHandlerSm_Region.voiceRecSM.voiceRecSM_Region.ActiveVR.ActiveVR_Region) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_Active :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_Active();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForTimerExpiry :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForTimerExpiry();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForDeactivationIndToRelChannel :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForDeactivationIndToRelChannel();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region SwitchToPassive_Region */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region()
{
	/* Default exit sequence for region SwitchToPassive_Region */
	/* Handle exit of all possible states (of PmVoiceRecHandlerSm.PmVoiceRecHandlerSm_Region.VoiceRecognitionHandlerSm.VoiceRecognitionHandlerSm_Region.voiceRecSM.voiceRecSM_Region.SwitchToPassive.SwitchToPassive_Region) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_PostingRequestToAudioManager :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_PostingRequestToAudioManager();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_WaitingForDeactivationInd :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_WaitingForDeactivationInd();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_DeactivationIndReceived :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_DeactivationIndReceived();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitForSCODisconnect :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitForSCODisconnect();
			break;
		}
		default: break;
	}
	/* Handle exit of all possible states (of PmVoiceRecHandlerSm.PmVoiceRecHandlerSm_Region.VoiceRecognitionHandlerSm.VoiceRecognitionHandlerSm_Region.voiceRecSM.voiceRecSM_Region.SwitchToPassive.SwitchToPassive_Region) at position 1... */
	switch(stateConfVector[ 1 ])
	{
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_WaitForSCODisconnection :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_WaitForSCODisconnection();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_SCODisconnectionReceived :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_SCODisconnectionReceived();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region WaitForDeactIndWaitingForDeactivationInd_Region */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region()
{
	/* Default exit sequence for region WaitForDeactIndWaitingForDeactivationInd_Region */
	/* Handle exit of all possible states (of PmVoiceRecHandlerSm.PmVoiceRecHandlerSm_Region.VoiceRecognitionHandlerSm.VoiceRecognitionHandlerSm_Region.voiceRecSM.voiceRecSM_Region.SwitchToPassive.SwitchToPassive_Region.WaitingForDeactivationIndAndSCODisconnect.WaitForDeactIndWaitingForDeactivationInd_Region) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_WaitingForDeactivationInd :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_WaitingForDeactivationInd();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_DeactivationIndReceived :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_DeactivationIndReceived();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region WaitForSCODisconnection_Region */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region()
{
	/* Default exit sequence for region WaitForSCODisconnection_Region */
	/* Handle exit of all possible states (of PmVoiceRecHandlerSm.PmVoiceRecHandlerSm_Region.VoiceRecognitionHandlerSm.VoiceRecognitionHandlerSm_Region.voiceRecSM.voiceRecSM_Region.SwitchToPassive.SwitchToPassive_Region.WaitingForDeactivationIndAndSCODisconnect.WaitForSCODisconnection_Region) at position 1... */
	switch(stateConfVector[ 1 ])
	{
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_WaitForSCODisconnection :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_WaitForSCODisconnection();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_SCODisconnectionReceived :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_SCODisconnectionReceived();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region externalVRSM_Region */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region()
{
	/* Default exit sequence for region externalVRSM_Region */
	/* Handle exit of all possible states (of PmVoiceRecHandlerSm.PmVoiceRecHandlerSm_Region.VoiceRecognitionHandlerSm.VoiceRecognitionHandlerSm_Region.externalVRSM.externalVRSM_Region) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StartingExternalVR :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StartingExternalVR();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ActiveExternalVR :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ActiveExternalVR();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_ExternalVRReadyAndWaitingForSCO :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_ExternalVRReadyAndWaitingForSCO();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_WaitingForStreaming :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_WaitingForStreaming();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelRelease :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelRelease();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartExtVR :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartExtVR();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartVR :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartVR();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region ReadyExternalVR_Region */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region()
{
	/* Default exit sequence for region ReadyExternalVR_Region */
	/* Handle exit of all possible states (of PmVoiceRecHandlerSm.PmVoiceRecHandlerSm_Region.VoiceRecognitionHandlerSm.VoiceRecognitionHandlerSm_Region.externalVRSM.externalVRSM_Region.ReadyExternalVR.ReadyExternalVR_Region) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_ExternalVRReadyAndWaitingForSCO :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_ExternalVRReadyAndWaitingForSCO();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_WaitingForStreaming :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_WaitingForStreaming();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region StoppingExternalVR_Region */
void PmVoiceRecHandlerSm::exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region()
{
	/* Default exit sequence for region StoppingExternalVR_Region */
	/* Handle exit of all possible states (of PmVoiceRecHandlerSm.PmVoiceRecHandlerSm_Region.VoiceRecognitionHandlerSm.VoiceRecognitionHandlerSm_Region.externalVRSM.externalVRSM_Region.StoppingExternalVR.StoppingExternalVR_Region) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelRelease :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelRelease();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartExtVR :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartExtVR();
			break;
		}
		case PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartVR :
		{
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartVR();
			break;
		}
		default: break;
	}
}

/* The reactions of state null. */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region__choice_0()
{
	/* The reactions of state null. */
	if (check_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region__choice_0_tr0_tr0())
	{ 
		effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region__choice_0_tr0();
	}  else
	{
		effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region__choice_0_tr1();
	}
}

/* The reactions of state null. */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region__choice_0()
{
	/* The reactions of state null. */
	if (check_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region__choice_0_tr0_tr0())
	{ 
		effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region__choice_0_tr0();
	}  else
	{
		effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region__choice_0_tr1();
	}
}

/* The reactions of state null. */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region__choice_1()
{
	/* The reactions of state null. */
	if (check_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region__choice_1_tr0_tr0())
	{ 
		effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region__choice_1_tr0();
	}  else
	{
		effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region__choice_1_tr1();
	}
}

/* The reactions of state null. */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region__choice_2()
{
	/* The reactions of state null. */
	if (check_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region__choice_2_tr0_tr0())
	{ 
		effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region__choice_2_tr0();
	}  else
	{
		effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region__choice_2_tr1();
	}
}

/* The reactions of state null. */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region__choice_0()
{
	/* The reactions of state null. */
	if (check_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region__choice_0_tr1_tr1())
	{ 
		effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region__choice_0_tr1();
	}  else
	{
		effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region__choice_0_tr0();
	}
}

/* The reactions of state null. */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region__choice_0()
{
	/* The reactions of state null. */
	if (check_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region__choice_0_tr1_tr1())
	{ 
		effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region__choice_0_tr1();
	}  else
	{
		effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region__choice_0_tr0();
	}
}

/* The reactions of state null. */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region__choice_0()
{
	/* The reactions of state null. */
	if (check_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region__choice_0_tr1_tr1())
	{ 
		effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region__choice_0_tr1();
	}  else
	{
		effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region__choice_0_tr0();
	}
}

/* The reactions of state null. */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region__choice_1()
{
	/* The reactions of state null. */
	if (check_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region__choice_1_tr0_tr0())
	{ 
		effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region__choice_1_tr0();
	}  else
	{
		effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region__choice_1_tr1();
	}
}

/* The reactions of state null. */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region__choice_0()
{
	/* The reactions of state null. */
	if (check_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region__choice_0_tr1_tr1())
	{ 
		effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region__choice_0_tr1();
	}  else
	{
		effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region__choice_0_tr0();
	}
}

/* Default react sequence for initial entry  */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region__entry_Default()
{
	/* Default react sequence for initial entry  */
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForChannelAllocation_default();
}

/* Default react sequence for initial entry  */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region__entry_Default()
{
	/* Default react sequence for initial entry  */
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region__choice_0();
}

/* Default react sequence for initial entry EntryToIdleOrDeactivateVR */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_EntryToIdleOrDeactivateVR()
{
	/* Default react sequence for initial entry EntryToIdleOrDeactivateVR */
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region__choice_1();
}

/* Default react sequence for initial entry EntryTPoReleaseChannel2 */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_EntryTPoReleaseChannel2()
{
	/* Default react sequence for initial entry EntryTPoReleaseChannel2 */
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_ReleaseChannel();
}

/* Default react sequence for initial entry EntryToReleaseChannel */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_EntryToReleaseChannel()
{
	/* Default react sequence for initial entry EntryToReleaseChannel */
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region__choice_2();
}

/* Default react sequence for initial entry DeactivateVREntry */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_DeactivateVREntry()
{
	/* Default react sequence for initial entry DeactivateVREntry */
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForAgResponse_default();
}

/* Default react sequence for initial entry  */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region__entry_Default()
{
	/* Default react sequence for initial entry  */
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_default();
}

/* Default react sequence for initial entry  */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region__entry_Default()
{
	/* Default react sequence for initial entry  */
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelRelease_default();
}

/* Default react sequence for initial entry EntryToActivateVR */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_EntryToActivateVR()
{
	/* Default react sequence for initial entry EntryToActivateVR */
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_ActivateVR();
}

/* Default react sequence for initial entry EntryToIdleOrWaitForSCORelease */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_EntryToIdleOrWaitForSCORelease()
{
	/* Default react sequence for initial entry EntryToIdleOrWaitForSCORelease */
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region__choice_0();
}

/* Default react sequence for initial entry  */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region__entry_Default()
{
	/* Default react sequence for initial entry  */
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_Active_default();
}

/* Default react sequence for initial entry EntryToActive */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_EntryToActive()
{
	/* Default react sequence for initial entry EntryToActive */
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_Active_default();
}

/* Default react sequence for initial entry EntryToReleaseChannel */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_EntryToReleaseChannel()
{
	/* Default react sequence for initial entry EntryToReleaseChannel */
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_ReleaseChannel();
}

/* Default react sequence for initial entry  */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region__entry_Default()
{
	/* Default react sequence for initial entry  */
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_default();
}

/* Default react sequence for initial entry  */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region__entry_Default()
{
	/* Default react sequence for initial entry  */
	ifaceUserAction_OCB->deactivateVR();
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region__sync1();
}

/* Default react sequence for initial entry EntryToCheckSCOStatus */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_EntryToCheckSCOStatus()
{
	/* Default react sequence for initial entry EntryToCheckSCOStatus */
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region__choice_0();
}

/* Default react sequence for initial entry EntryToIdle */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_EntryToIdle()
{
	/* Default react sequence for initial entry EntryToIdle */
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_Idle();
}

/* Default react sequence for initial entry EntryToIdleOrPostingRequestToAudioManager */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_EntryToIdleOrPostingRequestToAudioManager()
{
	/* Default react sequence for initial entry EntryToIdleOrPostingRequestToAudioManager */
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region__choice_1();
}

/* Default react sequence for initial entry  */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region__entry_Default()
{
	/* Default react sequence for initial entry  */
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StartingExternalVR_default();
}

/* Default react sequence for initial entry  */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region__entry_Default()
{
	/* Default react sequence for initial entry  */
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region__choice_0();
}

/* Default react sequence for initial entry  */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region__entry_Default()
{
	/* Default react sequence for initial entry  */
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelRelease_default();
}

/* Default react sequence for initial entry EntryToIdle1 */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_EntryToIdle1()
{
	/* Default react sequence for initial entry EntryToIdle1 */
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_Idle();
}

/* Default react sequence for initial entry EntryToIdle3 */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_EntryToIdle3()
{
	/* Default react sequence for initial entry EntryToIdle3 */
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_Idle();
}

/* Default react sequence for initial entry EntryToIdle5 */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_EntryToIdle5()
{
	/* Default react sequence for initial entry EntryToIdle5 */
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_Idle();
}

/* Default react sequence for initial entry EntryToStoppingExternalVR */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_EntryToStoppingExternalVR()
{
	/* Default react sequence for initial entry EntryToStoppingExternalVR */
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_default();
}

/* Default react sequence for initial entry  */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region__entry_Default()
{
	/* Default react sequence for initial entry  */
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_IdleVoiceRecognitionSM_default();
}

/* Default react sequence for initial entry  */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region__entry_Default()
{
	/* Default react sequence for initial entry  */
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_default();
}

/* The reactions of exit DeactivateVR. */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_DeactivateVR()
{
	/* The reactions of exit DeactivateVR. */
	effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_tr1();
}

/* The reactions of exit Idle. */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_Idle()
{
	/* The reactions of exit Idle. */
	effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_tr0();
}

/* The reactions of exit ReleaseChannel. */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_ReleaseChannel()
{
	/* The reactions of exit ReleaseChannel. */
	effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_tr2();
}

/* The reactions of exit ExitWaitingForStreaming. */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_ExitWaitingForStreaming()
{
	/* The reactions of exit ExitWaitingForStreaming. */
	effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_tr6();
}

/* The reactions of exit Idle. */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_Idle()
{
	/* The reactions of exit Idle. */
	effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_tr0();
}

/* The reactions of exit ActivateVR. */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_ActivateVR()
{
	/* The reactions of exit ActivateVR. */
	effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_tr2();
}

/* The reactions of exit ActivateExtVR. */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_ActivateExtVR()
{
	/* The reactions of exit ActivateExtVR. */
	effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_tr4();
}

/* The reactions of exit Idle. */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_Idle()
{
	/* The reactions of exit Idle. */
	effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_tr0();
}

/* The reactions of exit Idle. */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_Idle()
{
	/* The reactions of exit Idle. */
	effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_tr0();
}

/* The reactions of exit DeactivateVR. */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_DeactivateVR()
{
	/* The reactions of exit DeactivateVR. */
	effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_tr1();
}

/* The reactions of exit ReleaseChannel. */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_ReleaseChannel()
{
	/* The reactions of exit ReleaseChannel. */
	effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_tr2();
}

/* The reactions of exit exit_WaitingForTimerExpiry4. */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_exit_WaitingForTimerExpiry4()
{
	/* The reactions of exit exit_WaitingForTimerExpiry4. */
	effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_tr6();
}

/* The reactions of exit Idle. */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_Idle()
{
	/* The reactions of exit Idle. */
	effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_tr1();
}

/* The reactions of exit Idle. */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_Idle()
{
	/* The reactions of exit Idle. */
	effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_tr0();
}

/* The reactions of exit exit_WaitingForDeactivationIndAndSCODisconnect0. */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_exit_WaitingForDeactivationIndAndSCODisconnect0()
{
	/* The reactions of exit exit_WaitingForDeactivationIndAndSCODisconnect0. */
	effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_tr5();
}

/* The reactions of exit Idle. */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_Idle()
{
	/* The reactions of exit Idle. */
	effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_tr2();
}

/* The reactions of exit Idle. */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_Idle()
{
	/* The reactions of exit Idle. */
	effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_tr1();
}

/* The reactions of exit ActivateExtVR. */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_ActivateExtVR()
{
	/* The reactions of exit ActivateExtVR. */
	effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_tr7();
}

/* The reactions of exit ActivateVR. */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ActivateVR()
{
	/* The reactions of exit ActivateVR. */
	effect_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_tr4();
}

/* The reactions of state null. */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region__sync0()
{
	/* The reactions of state null. */
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_PostingRequestToAudioManager_default();
}

/* The reactions of state null. */
void PmVoiceRecHandlerSm::react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region__sync1()
{
	/* The reactions of state null. */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect);
	}
	enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_WaitingForDeactivationInd_default();
	react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region__choice_0();
}

sc_boolean PmVoiceRecHandlerSm::react() {
	/* State machine reactions. */
	return false;
}

sc_boolean PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_react(const sc_boolean try_transition) {
	/* The reactions of state VoiceRecognitionHandlerSm. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		did_transition = false;
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAgVRUpdate.VR_ACTIVATED_raised)
		{ 
			ifaceAgVRUpdate.vrState = true;
		} 
		if (ifaceAgVRUpdate.VR_DEACTIVATED_raised)
		{ 
			ifaceAgVRUpdate.vrState = false;
		} 
		if (ifaceAgAudioUpdate.SCO_CONNECTED_raised)
		{ 
			ifaceAgAudioUpdate.scoStatus = (ifaceAgAudioUpdate.SCO_CONNECTED_value);
		} 
		if (ifaceAgAudioUpdate.SCO_DISCONNECTED_raised)
		{ 
			ifaceAgAudioUpdate.scoStatus = (ifaceAgAudioUpdate.SCO_DISCONNECTED_value);
		} 
		if (ifaceUserAction.SWITCH_TO_PASSIVE_raised)
		{ 
			ifaceSmHandler_OCB->updateSwitchToPassiveNotHandledError();
			ifaceUserAction_OCB->tempFunc(false);
		} 
		did_transition = react();
	} 
	return did_transition;
}

sc_boolean PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_react(const sc_boolean try_transition) {
	/* The reactions of state voiceRecSM. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAgVRUpdate.HFP_CALL_ADDED_raised)
		{ 
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM();
			ifaceAMRequest_OCB->stopAudio();
			if(ifaceTraceObserver != sc_null) {
				ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM);
			}
			react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_Idle();
		}  else
		{
			if (ifaceAgConnectionStatusUpdate.DEVICE_DISCONNECTED_raised)
			{ 
				exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM();
				ifaceAMRequest_OCB->stopAudio();
				if(ifaceTraceObserver != sc_null) {
					ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM);
				}
				react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_Idle();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceUserAction.STOP_VR_raised)
		{ 
			ifaceUserAction_OCB->deactivateVR();
			ifaceSmHandler_OCB->updateVRState(VR_SESSION_ENDING);
		} 
		did_transition = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_react(const sc_boolean try_transition) {
	/* The reactions of state StartingVR. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAgVRUpdate.VR_DEACTIVATED_raised)
		{ 
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR();
			ifaceAgVRUpdate.vrState = false;
			enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_EntryTPoReleaseChannel2();
		}  else
		{
			if (ifaceAMResponse.VOICEREC_CHANNEL_RELEASED_EXT_TRIGGER_raised)
			{ 
				exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR();
				enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_EntryToIdleOrDeactivateVR();
			}  else
			{
				if (ifaceUserAction.SWITCH_TO_PASSIVE_CLIENT_REQ_raised)
				{ 
					exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR();
					enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_EntryToReleaseChannel();
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAgVRUpdate.VR_DEACTIVATION_FAILURE_raised)
		{ 
			ifaceSmHandler_OCB->updateVRStopError((ifaceAgVRUpdate.VR_DEACTIVATION_FAILURE_value));
			ifaceSmHandler_OCB->updateVRState(VR_SESSION_STARTING);
		} 
		did_transition = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForChannelAllocation_react(const sc_boolean try_transition) {
	/* The reactions of state WaitingForChannelAllocation. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAMResponse.VOICEREC_CHANNEL_GRANTED_raised)
		{ 
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForChannelAllocation();
			react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region__choice_0();
		}  else
		{
			if (ifaceAMResponse.VOICEREC_CHANNEL_DENIED_raised)
			{ 
				exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForChannelAllocation();
				ifaceSmHandler_OCB->updateVRStartError((ifaceAMResponse.VOICEREC_CHANNEL_DENIED_value));
				react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region__choice_1();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_ActivatingVRinAg_react(const sc_boolean try_transition) {
	/* The reactions of state ActivatingVRinAg. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAgVRUpdate.VR_ACTIVATED_raised)
		{ 
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_ActivatingVRinAg();
			ifaceAgVRUpdate.vrState = true;
			enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_default();
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_react(false);
		}  else
		{
			if (ifaceAgVRUpdate.VR_ACTIVATION_FAILURE_raised)
			{ 
				exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_ActivatingVRinAg();
				ifaceSmHandler_OCB->updateVRStartError((ifaceAgVRUpdate.VR_ACTIVATION_FAILURE_value));
				react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_ReleaseChannel();
			}  else
			{
				if (ifaceAMResponse.VOICEREC_CHANNEL_RELEASED_EXT_TRIGGER_raised)
				{ 
					exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_ActivatingVRinAg();
					enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForAgResponseToDeactivateVR_default();
					PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_react(false);
				}  else
				{
					if (ifaceUserAction.SWITCH_TO_PASSIVE_CLIENT_REQ_raised)
					{ 
						exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_ActivatingVRinAg();
						ifaceUserAction_OCB->deactivateVR();
						react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_ReleaseChannel();
					}  else
					{
						did_transition = false;
					}
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_react(const sc_boolean try_transition) {
	/* The reactions of state WaitingForStreaming. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAMResponse.PLAY_AUDIO_SUCCESS_raised)
		{ 
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming();
			react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_ExitWaitingForStreaming();
		}  else
		{
			if (ifaceAMResponse.STOP_AUDIO_SUCCESS_raised)
			{ 
				exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming();
				react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_DeactivateVR();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForSCO_react(const sc_boolean try_transition) {
	/* The reactions of state WaitingForSCO. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAgAudioUpdate.SCO_CONNECTED_raised)
		{ 
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForSCO();
			ifaceAgAudioUpdate.scoStatus = (ifaceAgAudioUpdate.SCO_CONNECTED_value);
			enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForStreaming_default();
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_react(false);
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_WaitingForStreaming_Region_WaitingForStreaming_react(const sc_boolean try_transition) {
	/* The reactions of state WaitingForStreaming. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		did_transition = false;
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForStreaming_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForAgResponseToDeactivateVR_react(const sc_boolean try_transition) {
	/* The reactions of state WaitingForAgResponseToDeactivateVR. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAgVRUpdate.VR_ACTIVATION_FAILURE_raised)
		{ 
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForAgResponseToDeactivateVR();
			react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_Idle();
		}  else
		{
			if (ifaceAgVRUpdate.VR_ACTIVATED_raised)
			{ 
				exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_WaitingForAgResponseToDeactivateVR();
				ifaceAgVRUpdate.vrState = true;
				react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_StartingVR_Region_DeactivateVR();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_react(const sc_boolean try_transition) {
	/* The reactions of state StoppingVR. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAgVRUpdate.VR_ACTIVATED_raised)
		{ 
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR();
			ifaceAgVRUpdate.vrState = true;
			enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StartingVR_default();
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_react(false);
		}  else
		{
			if (ifaceUserAction.START_VR_raised)
			{ 
				exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR();
				enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_EntryToActivateVR();
			}  else
			{
				if (ifaceAgConnectionStatusUpdate.DEVICE_DISCONNECTED_raised)
				{ 
					exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR();
					enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_EntryToIdleOrWaitForSCORelease();
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		if ((ifaceAgVRUpdate.VR_DEACTIVATION_FAILURE_raised) && ((ifaceAgVRUpdate.vrState) == (true)))
		{ 
			ifaceSmHandler_OCB->updateVRStopError((ifaceAgVRUpdate.VR_DEACTIVATION_FAILURE_value));
		} 
		did_transition = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForAgResponse_react(const sc_boolean try_transition) {
	/* The reactions of state WaitingForAgResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAgVRUpdate.VR_DEACTIVATED_raised)
		{ 
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForAgResponse();
			ifaceAgVRUpdate.vrState = false;
			react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region__choice_0();
		}  else
		{
			if (ifaceAgVRUpdate.VR_DEACTIVATION_FAILURE_raised)
			{ 
				exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForAgResponse();
				ifaceSmHandler_OCB->updateVRStopError((ifaceAgVRUpdate.VR_DEACTIVATION_FAILURE_value));
				react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region__choice_0();
			}  else
			{
				if (ifaceAgVRUpdate.HFP_CALL_ADDED_raised)
				{ 
					exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForAgResponse();
					react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region__choice_0();
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_react(const sc_boolean try_transition) {
	/* The reactions of state WaitingForVoiceRecChannelRelease. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceUserAction.START_VR_raised)
		{ 
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease();
			enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease();
			if(ifaceTraceObserver != sc_null) {
				ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease);
			}
			enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartVR_default();
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_react(false);
		}  else
		{
			if (ifaceAgVRUpdate.VR_ACTIVATED_raised)
			{ 
				exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease();
				ifaceAgVRUpdate.vrState = true;
				enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease();
				if(ifaceTraceObserver != sc_null) {
					ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease);
				}
				enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartVR_default();
				PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_react(false);
			}  else
			{
				if (ifaceUserAction.START_EXT_VR_raised)
				{ 
					exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease();
					enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease();
					if(ifaceTraceObserver != sc_null) {
						ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease);
					}
					enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartExtVR_default();
					PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_react(false);
				}  else
				{
					if ((ifaceUserAction.STOP_VR_raised) || (ifaceUserAction.STOP_EXT_VR_raised))
					{ 
						exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease();
						enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease();
						if(ifaceTraceObserver != sc_null) {
							ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease);
						}
						enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelRelease_default();
						PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_react(false);
					}  else
					{
						if (ifaceAgVRUpdate.VR_DEACTIVATED_raised)
						{ 
							exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease();
							ifaceAgVRUpdate.vrState = false;
							enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease();
							if(ifaceTraceObserver != sc_null) {
								ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease);
							}
							enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelRelease_default();
							PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_react(false);
						}  else
						{
							did_transition = false;
						}
					}
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelRelease_react(const sc_boolean try_transition) {
	/* The reactions of state WaitingForChannelRelease. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((((ifaceAMResponse.STOP_AUDIO_SUCCESS_raised) || (ifaceAMResponse.STOP_AUDIO_FAILURE_raised)) || (ifaceAMResponse.VOICEREC_CHANNEL_RELEASED_EXT_TRIGGER_raised)) || (ifaceAgVRUpdate.HFP_CALL_ADDED_raised))
		{ 
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelRelease();
			react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_Idle();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartExtVR_react(const sc_boolean try_transition) {
	/* The reactions of state WaitingForChannelReleaseToStartExtVR. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((ifaceAMResponse.STOP_AUDIO_SUCCESS_raised) || (ifaceAMResponse.STOP_AUDIO_FAILURE_raised))
		{ 
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease();
			react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_ActivateExtVR();
		}  else
		{
			if (ifaceAMResponse.VOICEREC_CHANNEL_RELEASED_EXT_TRIGGER_raised)
			{ 
				exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartExtVR();
				ifaceSmHandler_OCB->updateExtVRInterruptedReason(AUDIO_CHANNEL_RELEASED);
				react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_Idle();
			}  else
			{
				if (ifaceAgVRUpdate.HFP_CALL_ADDED_raised)
				{ 
					exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartExtVR();
					ifaceSmHandler_OCB->updateVRInterruptedReason(HFP_CALL);
					react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_Idle();
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartVR_react(const sc_boolean try_transition) {
	/* The reactions of state WaitingForChannelReleaseToStartVR. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAMResponse.VOICEREC_CHANNEL_RELEASED_EXT_TRIGGER_raised)
		{ 
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartVR();
			ifaceSmHandler_OCB->updateVRInterruptedReason(AUDIO_CHANNEL_RELEASED);
			react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_Idle();
		}  else
		{
			if (ifaceAgVRUpdate.HFP_CALL_ADDED_raised)
			{ 
				exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_WaitingForChannelReleaseToStartVR();
				ifaceSmHandler_OCB->updateVRInterruptedReason(HFP_CALL);
				react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_WaitingForVoiceRecChannelRelease_Region_Idle();
			}  else
			{
				if ((ifaceAMResponse.STOP_AUDIO_SUCCESS_raised) || (ifaceAMResponse.STOP_AUDIO_FAILURE_raised))
				{ 
					exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease();
					react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_ActivateVR();
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitingForVoiceRecChannelRelease_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitForSCORelease_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForSCORelease. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAgAudioUpdate.SCO_DISCONNECTED_raised)
		{ 
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_WaitForSCORelease();
			ifaceAgAudioUpdate.scoStatus = (ifaceAgAudioUpdate.SCO_DISCONNECTED_value);
			react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_StoppingVR_Region_Idle();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_react(const sc_boolean try_transition) {
	/* The reactions of state ActiveVR. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceUserAction.SWITCH_TO_PASSIVE_raised)
		{ 
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR();
			ifaceAMRequest.audioChannnelId = ifaceUserAction.SWITCH_TO_PASSIVE_value;
			ifaceUserAction_OCB->tempFunc(true);
			enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_default();
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_react(false);
		}  else
		{
			if (ifaceAgVRUpdate.VR_ACTIVATED_raised)
			{ 
				exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR();
				ifaceAgVRUpdate.vrState = true;
				enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_EntryToActive();
			}  else
			{
				if (ifaceUserAction.SWITCH_TO_PASSIVE_CLIENT_REQ_raised)
				{ 
					exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR();
					enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_EntryToReleaseChannel();
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceUserAction.START_VR_raised)
		{ 
			ifaceUserAction_OCB->activateVR();
		} 
		if ((ifaceAgVRUpdate.VR_DEACTIVATION_FAILURE_raised) && ((ifaceAgVRUpdate.vrState) == (true)))
		{ 
			ifaceSmHandler_OCB->updateVRStopError((ifaceAgVRUpdate.VR_DEACTIVATION_FAILURE_value));
			ifaceSmHandler_OCB->updateVRState(VR_SESSION_ACTIVE);
		} 
		did_transition = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_Active_react(const sc_boolean try_transition) {
	/* The reactions of state Active. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAgVRUpdate.VR_DEACTIVATED_raised)
		{ 
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_Active();
			ifaceAgVRUpdate.vrState = false;
			enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForTimerExpiry_default();
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_react(false);
		}  else
		{
			if (ifaceMediaPlayer.MEDIAREADYTOPLAY_raised)
			{ 
				exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_Active();
				enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForDeactivationIndToRelChannel_default();
				PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_react(false);
			}  else
			{
				if (ifaceAMResponse.VOICEREC_CHANNEL_RELEASED_EXT_TRIGGER_raised)
				{ 
					exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_Active();
					react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_DeactivateVR();
				}  else
				{
					if (ifaceUserAction.SWITCH_TO_PASSIVE_CLIENT_REQ_raised)
					{ 
						exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_Active();
						ifaceUserAction_OCB->deactivateVR();
						react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_ReleaseChannel();
					}  else
					{
						did_transition = false;
					}
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForTimerExpiry_react(const sc_boolean try_transition) {
	/* The reactions of state WaitingForTimerExpiry. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceTimer.EXTENDED_VRSESSION_TIMER_CALLBACK_raised)
		{ 
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForTimerExpiry();
			react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_ReleaseChannel();
		}  else
		{
			if (ifaceAgVRUpdate.VR_ACTIVATED_raised)
			{ 
				exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForTimerExpiry();
				ifaceAgVRUpdate.vrState = true;
				ifaceTimer_OCB->stopExtendVRTimer();
				enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_Active_default();
				PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_react(false);
			}  else
			{
				if (ifaceMediaPlayer.MEDIAREADYTOPLAY_raised)
				{ 
					exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForTimerExpiry();
					ifaceTimer_OCB->stopExtendVRTimer();
					react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_ReleaseChannel();
				}  else
				{
					if (ifaceAMResponse.VOICEREC_CHANNEL_RELEASED_EXT_TRIGGER_raised)
					{ 
						exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForTimerExpiry();
						ifaceTimer_OCB->stopExtendVRTimer();
						react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_Idle();
					}  else
					{
						if (ifaceUserAction.SWITCH_TO_PASSIVE_raised)
						{ 
							exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForTimerExpiry();
							ifaceAMRequest.audioChannnelId = ifaceUserAction.SWITCH_TO_PASSIVE_value;
							ifaceTimer_OCB->stopExtendVRTimer();
							react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_exit_WaitingForTimerExpiry4();
						}  else
						{
							did_transition = false;
						}
					}
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForDeactivationIndToRelChannel_react(const sc_boolean try_transition) {
	/* The reactions of state WaitingForDeactivationIndToRelChannel. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAgVRUpdate.VR_DEACTIVATED_raised)
		{ 
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForDeactivationIndToRelChannel();
			ifaceAgVRUpdate.vrState = false;
			react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_ReleaseChannel();
		}  else
		{
			if (ifaceAMResponse.VOICEREC_CHANNEL_RELEASED_EXT_TRIGGER_raised)
			{ 
				exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_WaitingForDeactivationIndToRelChannel();
				react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_ActiveVR_Region_DeactivateVR();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_react(const sc_boolean try_transition) {
	/* The reactions of state SwitchToPassive. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAgConnectionStatusUpdate.DEVICE_DISCONNECTED_raised)
		{ 
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive();
			ifaceAMRequest_OCB->stopOrPauseHfAudio(ifaceAMRequest.audioChannnelId);
			ifaceSmHandler_OCB->updateswitchToPassiveResponse((sc_string) "OK");
			enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_EntryToIdle();
		}  else
		{
			if (ifaceAMResponse.VOICEREC_CHANNEL_RELEASED_EXT_TRIGGER_raised)
			{ 
				exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive();
				ifaceSmHandler_OCB->updateVRState(VR_SESSION_IDLE);
				enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_EntryToIdleOrPostingRequestToAudioManager();
			}  else
			{
				if (ifaceAgVRUpdate.VR_DEACTIVATION_FAILURE_raised)
				{ 
					exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive();
					ifaceSmHandler_OCB->updateVRStopError((ifaceAgVRUpdate.VR_DEACTIVATION_FAILURE_value));
					ifaceSmHandler_OCB->updateVRState(VR_SESSION_ACTIVE);
					enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_ActiveVR_default();
					PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_react(false);
				}  else
				{
					if (ifaceUserAction.SWITCH_TO_PASSIVE_CLIENT_REQ_raised)
					{ 
						exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive();
						enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_StoppingVR_default();
						PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_react(false);
					}  else
					{
						did_transition = false;
					}
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceUserAction.SWITCH_TO_PASSIVE_raised)
		{ 
			ifaceAMRequest.audioChannnelId = ifaceUserAction.SWITCH_TO_PASSIVE_value;
		} 
		did_transition = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_PostingRequestToAudioManager_react(const sc_boolean try_transition) {
	/* The reactions of state PostingRequestToAudioManager. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceInternalSCI.MOVE_TO_NEXT_STATE_raised)
		{ 
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_PostingRequestToAudioManager();
			ifaceSmHandler_OCB->updateVRState(VR_SESSION_IDLE);
			ifaceSmHandler_OCB->updateswitchToPassiveResponse((sc_string) "OK");
			react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_Idle();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_react(const sc_boolean try_transition) {
	/* The reactions of state WaitingForDeactivationIndAndSCODisconnect. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAgVRUpdate.VR_DEACTIVATION_FAILURE_raised)
		{ 
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect();
			ifaceSmHandler_OCB->updateSwitchToPassiveError(ifaceAgVRUpdate.VR_DEACTIVATION_FAILURE_value);
			react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_exit_WaitingForDeactivationIndAndSCODisconnect0();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_WaitingForDeactivationInd_react(const sc_boolean try_transition) {
	/* The reactions of state WaitingForDeactivationInd. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAgVRUpdate.VR_DEACTIVATED_raised)
		{ 
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_WaitingForDeactivationInd();
			ifaceAgVRUpdate.vrState = false;
			enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_DeactivationIndReceived_default();
		}  else
		{
			did_transition = false;
		}
	} 
	return did_transition;
}

sc_boolean PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_DeactivationIndReceived_react(const sc_boolean try_transition) {
	/* The reactions of state DeactivationIndReceived. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (((ifaceInternalSCI.SWITCHED_TO_PASSIVE_raised) && (isStateActive(PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_SCODisconnectionReceived))) && (ifaceInternalSCI.SWITCHED_TO_PASSIVE_raised))
		{ 
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect();
			react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region__sync0();
		}  else
		{
			did_transition = false;
		}
	} 
	return did_transition;
}

sc_boolean PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_WaitForSCODisconnection_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForSCODisconnection. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAgAudioUpdate.SCO_DISCONNECTED_raised)
		{ 
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_WaitForSCODisconnection();
			ifaceAgAudioUpdate.scoStatus = (ifaceAgAudioUpdate.SCO_DISCONNECTED_value);
			enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_SCODisconnectionReceived_default();
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_react(false);
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForSCODisconnection_Region_SCODisconnectionReceived_react(const sc_boolean try_transition) {
	/* The reactions of state SCODisconnectionReceived. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (((ifaceInternalSCI.SWITCHED_TO_PASSIVE_raised) && (isStateActive(PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_WaitForDeactIndWaitingForDeactivationInd_Region_DeactivationIndReceived))) && (ifaceInternalSCI.SWITCHED_TO_PASSIVE_raised))
		{ 
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect();
			react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region__sync0();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitingForDeactivationIndAndSCODisconnect_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitForSCODisconnect_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForSCODisconnect. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAgAudioUpdate.SCO_DISCONNECTED_raised)
		{ 
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_WaitForSCODisconnect();
			ifaceAgAudioUpdate.scoStatus = (ifaceAgAudioUpdate.SCO_DISCONNECTED_value);
			enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_SwitchToPassive_Region_PostingRequestToAudioManager_default();
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_react(false);
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_voiceRecSM_Region_SwitchToPassive_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_IdleVoiceRecognitionSM_react(const sc_boolean try_transition) {
	/* The reactions of state IdleVoiceRecognitionSM. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceUserAction.START_VR_raised)
		{ 
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_IdleVoiceRecognitionSM();
			enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_default();
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_react(false);
		}  else
		{
			if (ifaceAgVRUpdate.VR_ACTIVATED_raised)
			{ 
				exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_IdleVoiceRecognitionSM();
				ifaceAgVRUpdate.vrState = true;
				enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_voiceRecSM_default();
				PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_react(false);
			}  else
			{
				if (ifaceUserAction.START_EXT_VR_raised)
				{ 
					exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_IdleVoiceRecognitionSM();
					enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_default();
					PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_react(false);
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_react(const sc_boolean try_transition) {
	/* The reactions of state externalVRSM. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceUserAction.STOP_EXT_VR_raised)
		{ 
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM();
			enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_EntryToStoppingExternalVR();
		}  else
		{
			if (ifaceAMResponse.VOICEREC_CHANNEL_RELEASED_EXT_TRIGGER_raised)
			{ 
				exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM();
				ifaceSmHandler_OCB->updateExtVRInterruptedReason(AUDIO_CHANNEL_RELEASED);
				enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_EntryToIdle1();
			}  else
			{
				if (ifaceAgVRUpdate.HFP_CALL_ADDED_raised)
				{ 
					exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM();
					ifaceSmHandler_OCB->updateExtVRInterruptedReason(HFP_CALL);
					ifaceAMRequest_OCB->stopAudio();
					enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_EntryToIdle3();
				}  else
				{
					if (ifaceAgConnectionStatusUpdate.DEVICE_DISCONNECTED_raised)
					{ 
						exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM();
						ifaceAMRequest_OCB->stopAudio();
						enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_EntryToIdle5();
					}  else
					{
						did_transition = false;
					}
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StartingExternalVR_react(const sc_boolean try_transition) {
	/* The reactions of state StartingExternalVR. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAMResponse.VOICEREC_CHANNEL_DENIED_raised)
		{ 
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StartingExternalVR();
			ifaceSmHandler_OCB->updateExternalVRStartError(ifaceAMResponse.VOICEREC_CHANNEL_DENIED_value);
			react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_Idle();
		}  else
		{
			if (ifaceAMResponse.VOICEREC_CHANNEL_GRANTED_raised)
			{ 
				exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StartingExternalVR();
				enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_default();
				PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_react(false);
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ActiveExternalVR_react(const sc_boolean try_transition) {
	/* The reactions of state ActiveExternalVR. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAgAudioUpdate.SCO_DISCONNECTED_raised)
		{ 
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ActiveExternalVR();
			ifaceAgAudioUpdate.scoStatus = ifaceAgAudioUpdate.SCO_DISCONNECTED_value;
			ifaceAMRequest_OCB->stopOrPauseHfAudio(AM_VOICERECOGNITION);
			enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_default();
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_react(false);
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_react(const sc_boolean try_transition) {
	/* The reactions of state ReadyExternalVR. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAMResponse.PLAY_AUDIO_SUCCESS_raised)
		{ 
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR();
			enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ActiveExternalVR_default();
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_react(false);
		}  else
		{
			if (ifaceAMResponse.PLAY_AUDIO_FAILURE_raised)
			{ 
				exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR();
				ifaceSmHandler_OCB->updateExternalVRStartError(ifaceAMResponse.PLAY_AUDIO_FAILURE_value);
				react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_Idle();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_ExternalVRReadyAndWaitingForSCO_react(const sc_boolean try_transition) {
	/* The reactions of state ExternalVRReadyAndWaitingForSCO. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAgAudioUpdate.SCO_CONNECTED_raised)
		{ 
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_ExternalVRReadyAndWaitingForSCO();
			ifaceAgAudioUpdate.scoStatus = ifaceAgAudioUpdate.SCO_CONNECTED_value;
			enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_WaitingForStreaming_default();
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_react(false);
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_WaitingForStreaming_react(const sc_boolean try_transition) {
	/* The reactions of state WaitingForStreaming. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAgAudioUpdate.SCO_DISCONNECTED_raised)
		{ 
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_WaitingForStreaming();
			ifaceAgAudioUpdate.scoStatus = ifaceAgAudioUpdate.SCO_DISCONNECTED_value;
			ifaceAMRequest_OCB->stopOrPauseHfAudio(AM_VOICERECOGNITION);
			enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_ReadyExternalVR_Region_ExternalVRReadyAndWaitingForSCO_default();
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_react(false);
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ReadyExternalVR_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_react(const sc_boolean try_transition) {
	/* The reactions of state StoppingExternalVR. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((ifaceUserAction.STOP_EXT_VR_raised) || (ifaceUserAction.STOP_VR_raised))
		{ 
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR();
			enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR();
			if(ifaceTraceObserver != sc_null) {
				ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR);
			}
			enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelRelease_default();
			PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_react(false);
		}  else
		{
			if (ifaceUserAction.START_EXT_VR_raised)
			{ 
				exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR();
				enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR();
				if(ifaceTraceObserver != sc_null) {
					ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR);
				}
				enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartExtVR_default();
				PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_react(false);
			}  else
			{
				if (ifaceUserAction.START_VR_raised)
				{ 
					exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR();
					enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR();
					if(ifaceTraceObserver != sc_null) {
						ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR);
					}
					enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartVR_default();
					PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_react(false);
				}  else
				{
					if (ifaceAgVRUpdate.VR_ACTIVATED_raised)
					{ 
						exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR();
						ifaceAgVRUpdate.vrState = true;
						enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR();
						if(ifaceTraceObserver != sc_null) {
							ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR);
						}
						enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartVR_default();
						PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_react(false);
					}  else
					{
						if (ifaceAgVRUpdate.VR_DEACTIVATED_raised)
						{ 
							exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR();
							ifaceAgVRUpdate.vrState = false;
							enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR();
							if(ifaceTraceObserver != sc_null) {
								ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR);
							}
							enseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelRelease_default();
							PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_react(false);
						}  else
						{
							if (ifaceAgVRUpdate.HFP_CALL_ADDED_raised)
							{ 
								exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR();
								ifaceSmHandler_OCB->updateExtVRInterruptedReason(HFP_CALL);
								enact_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR();
								if(ifaceTraceObserver != sc_null) {
									ifaceTraceObserver->stateEntered(PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR);
								}
								react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_Idle();
							}  else
							{
								if (ifaceAgConnectionStatusUpdate.DEVICE_DISCONNECTED_raised)
								{ 
									exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR();
									react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_Idle();
								}  else
								{
									did_transition = false;
								}
							}
						}
					}
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelRelease_react(const sc_boolean try_transition) {
	/* The reactions of state WaitingForChannelRelease. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((ifaceAMResponse.STOP_AUDIO_SUCCESS_raised) || (ifaceAMResponse.STOP_AUDIO_FAILURE_raised))
		{ 
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelRelease();
			react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_Idle();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartExtVR_react(const sc_boolean try_transition) {
	/* The reactions of state WaitingForChannelReleaseToStartExtVR. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((ifaceAMResponse.STOP_AUDIO_SUCCESS_raised) || (ifaceAMResponse.STOP_AUDIO_FAILURE_raised))
		{ 
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartExtVR();
			react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_ActivateExtVR();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmVoiceRecHandlerSm::PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartVR_react(const sc_boolean try_transition) {
	/* The reactions of state WaitingForChannelReleaseToStartVR. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((ifaceAMResponse.STOP_AUDIO_SUCCESS_raised) || (ifaceAMResponse.STOP_AUDIO_FAILURE_raised))
		{ 
			exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR();
			react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_ActivateVR();
		}  else
		{
			if (ifaceAgVRUpdate.HFP_CALL_ADDED_raised)
			{ 
				exseq_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_WaitingForChannelReleaseToStartVR();
				ifaceSmHandler_OCB->updateVRInterruptedReason(HFP_CALL);
				react_PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_StoppingExternalVR_Region_Idle();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = PmVoiceRecHandlerSm_Region_VoiceRecognitionHandlerSm_VoiceRecognitionHandlerSm_Region_externalVRSM_externalVRSM_Region_StoppingExternalVR_react(try_transition);
	} 
	return did_transition;
}



