/* *
 * @file PmRingtoneHandlerSm.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Generated code from PmRingtoneHandlerSm.sct
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 * */

#ifndef PMRINGTONEHANDLERSM_H_
#define PMRINGTONEHANDLERSM_H_


#include <PmCoreSmTypes.h>
#include <PmCoreIfMessageRequest.h>
#include <PmInterfaceTypesInternal.h>
#include <deque>
#include "sc_types.h"
#include "StatemachineInterface.h"
#include "scTracing.h"

/*! \file Header of the state machine 'PmRingtoneHandlerSm'.
*/


#ifndef SCT_EVENTS_PMRINGTONEHANDLERSM_H
#define SCT_EVENTS_PMRINGTONEHANDLERSM_H
#ifndef SC_INVALID_EVENT_VALUE
#define SC_INVALID_EVENT_VALUE 0
#endif

namespace pmringtonehandlersm_events
{
typedef enum  {
	pmringtonehandlersm_invalid_event = SC_INVALID_EVENT_VALUE,
	SCI_UserAction_PLAY_RINGTONE,
	SCI_UserAction_STOP_RINGTONE,
	SCI_UserAction_MUTE_RINGTONE,
	SCI_UserAction_UNMUTE_RINGTONE,
	SCI_UserAction_PAUSE_RINGTONE,
	SCI_UserAction_WAIT_FOR_STOP_RESP_AND_PLAY_RINGTONE,
	SCI_UserAction_WAIT_FOR_RT_CH_ACQUISITION_AND_PLAY_RINGTONE,
	SCI_UserAction_WAIT_FOR_PLAY_RT_RESP_AND_PLAY_RINGTONE,
	SCI_SmHandler_WAIT_FOR_STOP_RESP_AND_PLAY_RINGTONE,
	SCI_SmHandler_SWITCH_TO_ACTIVE,
	SCI_SmHandler_MOVE_TO_IDLE,
	SCI_AudioManagerResponse_RINGTONE_CHANNEL_GRANTED,
	SCI_AudioManagerResponse_RINGTONE_CHANNEL_DENIED,
	SCI_AudioManagerResponse_PLAY_AUDIO_SUCCESS,
	SCI_AudioManagerResponse_PLAY_AUDIO_FAILURE,
	SCI_AudioManagerResponse_PAUSE_AUDIO_SUCCESS,
	SCI_AudioManagerResponse_PAUSE_AUDIO_FAILURE,
	SCI_AudioManagerResponse_STOP_AUDIO_SUCCESS,
	SCI_AudioManagerResponse_STOP_AUDIO_FAILURE,
	SCI_AudioManagerResponse_RINGTONE_CHANNEL_RELEASED
} PmRingtoneHandlerSmEventName;

class SctEvent
{
	public:
		SctEvent(PmRingtoneHandlerSmEventName name) : name(name){}
		virtual ~SctEvent(){}
		const PmRingtoneHandlerSmEventName name;
		
};
		
template <typename T>
class TypedSctEvent : public SctEvent
{
	public:
		TypedSctEvent(PmRingtoneHandlerSmEventName name, T value) :
			SctEvent(name),
			value(value)
			{}
		virtual ~TypedSctEvent(){}
		const T value;
};

class SctEvent_SCI_UserAction_PLAY_RINGTONE : public SctEvent
{
	public:
		SctEvent_SCI_UserAction_PLAY_RINGTONE(PmRingtoneHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_UserAction_STOP_RINGTONE : public TypedSctEvent<pmcore::PmCoreIfMessage_StopRingtoneRequest *>
{
	public:
		SctEvent_SCI_UserAction_STOP_RINGTONE(PmRingtoneHandlerSmEventName name, pmcore::PmCoreIfMessage_StopRingtoneRequest * value) :
			TypedSctEvent(name, value) {};
};
class SctEvent_SCI_UserAction_MUTE_RINGTONE : public SctEvent
{
	public:
		SctEvent_SCI_UserAction_MUTE_RINGTONE(PmRingtoneHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_UserAction_UNMUTE_RINGTONE : public SctEvent
{
	public:
		SctEvent_SCI_UserAction_UNMUTE_RINGTONE(PmRingtoneHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_UserAction_PAUSE_RINGTONE : public SctEvent
{
	public:
		SctEvent_SCI_UserAction_PAUSE_RINGTONE(PmRingtoneHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_UserAction_WAIT_FOR_STOP_RESP_AND_PLAY_RINGTONE : public SctEvent
{
	public:
		SctEvent_SCI_UserAction_WAIT_FOR_STOP_RESP_AND_PLAY_RINGTONE(PmRingtoneHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_UserAction_WAIT_FOR_RT_CH_ACQUISITION_AND_PLAY_RINGTONE : public SctEvent
{
	public:
		SctEvent_SCI_UserAction_WAIT_FOR_RT_CH_ACQUISITION_AND_PLAY_RINGTONE(PmRingtoneHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_UserAction_WAIT_FOR_PLAY_RT_RESP_AND_PLAY_RINGTONE : public SctEvent
{
	public:
		SctEvent_SCI_UserAction_WAIT_FOR_PLAY_RT_RESP_AND_PLAY_RINGTONE(PmRingtoneHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_SmHandler_WAIT_FOR_STOP_RESP_AND_PLAY_RINGTONE : public SctEvent
{
	public:
		SctEvent_SCI_SmHandler_WAIT_FOR_STOP_RESP_AND_PLAY_RINGTONE(PmRingtoneHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_SmHandler_SWITCH_TO_ACTIVE : public SctEvent
{
	public:
		SctEvent_SCI_SmHandler_SWITCH_TO_ACTIVE(PmRingtoneHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_SmHandler_MOVE_TO_IDLE : public SctEvent
{
	public:
		SctEvent_SCI_SmHandler_MOVE_TO_IDLE(PmRingtoneHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioManagerResponse_RINGTONE_CHANNEL_GRANTED : public SctEvent
{
	public:
		SctEvent_SCI_AudioManagerResponse_RINGTONE_CHANNEL_GRANTED(PmRingtoneHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioManagerResponse_RINGTONE_CHANNEL_DENIED : public SctEvent
{
	public:
		SctEvent_SCI_AudioManagerResponse_RINGTONE_CHANNEL_DENIED(PmRingtoneHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioManagerResponse_PLAY_AUDIO_SUCCESS : public SctEvent
{
	public:
		SctEvent_SCI_AudioManagerResponse_PLAY_AUDIO_SUCCESS(PmRingtoneHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioManagerResponse_PLAY_AUDIO_FAILURE : public SctEvent
{
	public:
		SctEvent_SCI_AudioManagerResponse_PLAY_AUDIO_FAILURE(PmRingtoneHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioManagerResponse_PAUSE_AUDIO_SUCCESS : public SctEvent
{
	public:
		SctEvent_SCI_AudioManagerResponse_PAUSE_AUDIO_SUCCESS(PmRingtoneHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioManagerResponse_PAUSE_AUDIO_FAILURE : public SctEvent
{
	public:
		SctEvent_SCI_AudioManagerResponse_PAUSE_AUDIO_FAILURE(PmRingtoneHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioManagerResponse_STOP_AUDIO_SUCCESS : public SctEvent
{
	public:
		SctEvent_SCI_AudioManagerResponse_STOP_AUDIO_SUCCESS(PmRingtoneHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioManagerResponse_STOP_AUDIO_FAILURE : public SctEvent
{
	public:
		SctEvent_SCI_AudioManagerResponse_STOP_AUDIO_FAILURE(PmRingtoneHandlerSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioManagerResponse_RINGTONE_CHANNEL_RELEASED : public SctEvent
{
	public:
		SctEvent_SCI_AudioManagerResponse_RINGTONE_CHANNEL_RELEASED(PmRingtoneHandlerSmEventName name) : SctEvent(name){};
};

}
#endif /* SCT_EVENTS_PMRINGTONEHANDLERSM_H */


/*! Define indices of states in the StateConfVector */
#define SCVI_MAIN_REGION_RINGTONEHANDLER 0
#define SCVI_MAIN_REGION_RINGTONEHANDLER_RINGTONEHANDLER_REGION_IDLE 0
#define SCVI_MAIN_REGION_RINGTONEHANDLER_RINGTONEHANDLER_REGION_PLAYRINGTONE 0
#define SCVI_MAIN_REGION_RINGTONEHANDLER_RINGTONEHANDLER_REGION_PLAYRINGTONE_PLAYRINGTONE_REGION_REQUESTSTREAMING 0
#define SCVI_MAIN_REGION_RINGTONEHANDLER_RINGTONEHANDLER_REGION_PLAYRINGTONE_PLAYRINGTONE_REGION_STREAMINGSTARTED 0
#define SCVI_MAIN_REGION_RINGTONEHANDLER_RINGTONEHANDLER_REGION_PLAYRINGTONE_PLAYRINGTONE_REGION_STREAMINGPAUSED 0
#define SCVI_MAIN_REGION_RINGTONEHANDLER_RINGTONEHANDLER_REGION_PLAYRINGTONE_PLAYRINGTONE_REGION_REPLAY 0
#define SCVI_MAIN_REGION_RINGTONEHANDLER_RINGTONEHANDLER_REGION_PLAYRINGTONE_PLAYRINGTONE_REGION_WAITFORPLAYRESPTOREPLAY 0
#define SCVI_MAIN_REGION_RINGTONEHANDLER_RINGTONEHANDLER_REGION_WAITFORRINGTONECHANNELACQUISITION 0
#define SCVI_MAIN_REGION_RINGTONEHANDLER_RINGTONEHANDLER_REGION_STOPPINGRINGTONE 0
#define SCVI_MAIN_REGION_RINGTONEHANDLER_RINGTONEHANDLER_REGION_STOPPINGRINGTONE_STOPPINGRINGTONE_REGION_PLAYAFTERSTOPAUDIORESPONSE 0
#define SCVI_MAIN_REGION_RINGTONEHANDLER_RINGTONEHANDLER_REGION_STOPPINGRINGTONE_STOPPINGRINGTONE_REGION_STOPAFTERSTOPAUDIORESPONSE 0
#define SCVI_MAIN_REGION_RINGTONEHANDLER_RINGTONEHANDLER_REGION_STOPPINGRINGTONE_STOPPINGRINGTONE_REGION_REQUESTSTOPAUDIO 0


class PmRingtoneHandlerSm : public StatemachineInterface
{
	public:
		PmRingtoneHandlerSm();
		
		~PmRingtoneHandlerSm();
		
		/*! Enumeration of all states */ 
		typedef enum
		{
			PmRingtoneHandlerSm_last_state,
			Main_region_RingtoneHandler,
			Main_region_RingtoneHandler_ringtonehandler_region_Idle,
			Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone,
			Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_RequestStreaming,
			Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingStarted,
			Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingPaused,
			Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_Replay,
			Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_WaitForPlayRespToReplay,
			Main_region_RingtoneHandler_ringtonehandler_region_WaitForRingtoneChannelAcquisition,
			Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone,
			Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_PlayAfterStopAudioResponse,
			Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_StopAfterStopAudioResponse,
			Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_RequestStopAudio
		} PmRingtoneHandlerSmStates;
					
		static const sc_integer numStates = 13;
		
		//! Inner class for UserAction interface scope.
		class SCI_UserAction
		{
			public:
				SCI_UserAction(PmRingtoneHandlerSm * parent):
					PLAY_RINGTONE_raised(false),
					STOP_RINGTONE_raised(false),
					STOP_RINGTONE_value(),
					MUTE_RINGTONE_raised(false),
					UNMUTE_RINGTONE_raised(false),
					PAUSE_RINGTONE_raised(false),
					WAIT_FOR_STOP_RESP_AND_PLAY_RINGTONE_raised(false),
					WAIT_FOR_RT_CH_ACQUISITION_AND_PLAY_RINGTONE_raised(false),
					WAIT_FOR_PLAY_RT_RESP_AND_PLAY_RINGTONE_raised(false),
					parent(parent)
				{}
				
				/*! Gets the value of the variable 'ringtoneId' that is defined in the interface scope 'UserAction'. */
				pmcore::RingtoneId get_ringtoneId() const;
				
				/*! Sets the value of the variable 'ringtoneId' that is defined in the interface scope 'UserAction'. */
				void set_ringtoneId(pmcore::RingtoneId value);
				
				
				/*! Gets the value of the variable 'playCount' that is defined in the interface scope 'UserAction'. */
				pmcore::PlayCount get_playCount() const;
				
				/*! Sets the value of the variable 'playCount' that is defined in the interface scope 'UserAction'. */
				void set_playCount(pmcore::PlayCount value);
				
				
				/*! Raises the in event 'PLAY_RINGTONE' that is defined in the interface scope 'UserAction'. */
				void raise_pLAY_RINGTONE();
				
				
				/*! Raises the in event 'STOP_RINGTONE' that is defined in the interface scope 'UserAction'. */
				void raise_sTOP_RINGTONE(pmcore::PmCoreIfMessage_StopRingtoneRequest * value);
				
				
				/*! Raises the in event 'MUTE_RINGTONE' that is defined in the interface scope 'UserAction'. */
				void raise_mUTE_RINGTONE();
				
				
				/*! Raises the in event 'UNMUTE_RINGTONE' that is defined in the interface scope 'UserAction'. */
				void raise_uNMUTE_RINGTONE();
				
				
				/*! Raises the in event 'PAUSE_RINGTONE' that is defined in the interface scope 'UserAction'. */
				void raise_pAUSE_RINGTONE();
				
				
				/*! Raises the in event 'WAIT_FOR_STOP_RESP_AND_PLAY_RINGTONE' that is defined in the interface scope 'UserAction'. */
				void raise_wAIT_FOR_STOP_RESP_AND_PLAY_RINGTONE();
				
				
				/*! Raises the in event 'WAIT_FOR_RT_CH_ACQUISITION_AND_PLAY_RINGTONE' that is defined in the interface scope 'UserAction'. */
				void raise_wAIT_FOR_RT_CH_ACQUISITION_AND_PLAY_RINGTONE();
				
				
				/*! Raises the in event 'WAIT_FOR_PLAY_RT_RESP_AND_PLAY_RINGTONE' that is defined in the interface scope 'UserAction'. */
				void raise_wAIT_FOR_PLAY_RT_RESP_AND_PLAY_RINGTONE();
				
				
				
				
			private:
				friend class PmRingtoneHandlerSm;
				pmcore::RingtoneId ringtoneId;
				pmcore::PlayCount playCount;
				/*! Raises the in event 'PLAY_RINGTONE' that is defined in the interface scope 'UserAction'. */
				void internal_raise_pLAY_RINGTONE();
				sc_boolean PLAY_RINGTONE_raised;
				/*! Raises the in event 'STOP_RINGTONE' that is defined in the interface scope 'UserAction'. */
				void internal_raise_sTOP_RINGTONE(pmcore::PmCoreIfMessage_StopRingtoneRequest * value);
				sc_boolean STOP_RINGTONE_raised;
				pmcore::PmCoreIfMessage_StopRingtoneRequest * STOP_RINGTONE_value;
				/*! Raises the in event 'MUTE_RINGTONE' that is defined in the interface scope 'UserAction'. */
				void internal_raise_mUTE_RINGTONE();
				sc_boolean MUTE_RINGTONE_raised;
				/*! Raises the in event 'UNMUTE_RINGTONE' that is defined in the interface scope 'UserAction'. */
				void internal_raise_uNMUTE_RINGTONE();
				sc_boolean UNMUTE_RINGTONE_raised;
				/*! Raises the in event 'PAUSE_RINGTONE' that is defined in the interface scope 'UserAction'. */
				void internal_raise_pAUSE_RINGTONE();
				sc_boolean PAUSE_RINGTONE_raised;
				/*! Raises the in event 'WAIT_FOR_STOP_RESP_AND_PLAY_RINGTONE' that is defined in the interface scope 'UserAction'. */
				void internal_raise_wAIT_FOR_STOP_RESP_AND_PLAY_RINGTONE();
				sc_boolean WAIT_FOR_STOP_RESP_AND_PLAY_RINGTONE_raised;
				/*! Raises the in event 'WAIT_FOR_RT_CH_ACQUISITION_AND_PLAY_RINGTONE' that is defined in the interface scope 'UserAction'. */
				void internal_raise_wAIT_FOR_RT_CH_ACQUISITION_AND_PLAY_RINGTONE();
				sc_boolean WAIT_FOR_RT_CH_ACQUISITION_AND_PLAY_RINGTONE_raised;
				/*! Raises the in event 'WAIT_FOR_PLAY_RT_RESP_AND_PLAY_RINGTONE' that is defined in the interface scope 'UserAction'. */
				void internal_raise_wAIT_FOR_PLAY_RT_RESP_AND_PLAY_RINGTONE();
				sc_boolean WAIT_FOR_PLAY_RT_RESP_AND_PLAY_RINGTONE_raised;
				PmRingtoneHandlerSm * parent;
				void dispatch_event(pmringtonehandlersm_events::SctEvent * event);
				
				
		};
				//! Inner class for UserAction interface scope operation callbacks.
				class SCI_UserAction_OCB
				{
					public:
						virtual ~SCI_UserAction_OCB() = 0;
						
						virtual void stopRingtone(pmcore::PmCoreIfMessage_StopRingtoneRequest * msg) = 0;
						
						
				};
				
				/*! Set the working instance of the operation callback interface 'SCI_UserAction_OCB'. */
				void setSCI_UserAction_OCB(SCI_UserAction_OCB* operationCallback);
		
		/*! Returns an instance of the interface class 'SCI_UserAction'. */
		SCI_UserAction* getSCI_UserAction();
		
		//! Inner class for SmHandler interface scope.
		class SCI_SmHandler
		{
			public:
				SCI_SmHandler(PmRingtoneHandlerSm * parent):
					WAIT_FOR_STOP_RESP_AND_PLAY_RINGTONE_raised(false),
					SWITCH_TO_ACTIVE_raised(false),
					MOVE_TO_IDLE_raised(false),
					parent(parent)
				{}
				
				/*! Raises the in event 'WAIT_FOR_STOP_RESP_AND_PLAY_RINGTONE' that is defined in the interface scope 'SmHandler'. */
				void raise_wAIT_FOR_STOP_RESP_AND_PLAY_RINGTONE();
				
				
				/*! Raises the in event 'SWITCH_TO_ACTIVE' that is defined in the interface scope 'SmHandler'. */
				void raise_sWITCH_TO_ACTIVE();
				
				
				/*! Raises the in event 'MOVE_TO_IDLE' that is defined in the interface scope 'SmHandler'. */
				void raise_mOVE_TO_IDLE();
				
				
				
				
				
				
			private:
				friend class PmRingtoneHandlerSm;
				/*! Raises the in event 'WAIT_FOR_STOP_RESP_AND_PLAY_RINGTONE' that is defined in the interface scope 'SmHandler'. */
				void internal_raise_wAIT_FOR_STOP_RESP_AND_PLAY_RINGTONE();
				sc_boolean WAIT_FOR_STOP_RESP_AND_PLAY_RINGTONE_raised;
				/*! Raises the in event 'SWITCH_TO_ACTIVE' that is defined in the interface scope 'SmHandler'. */
				void internal_raise_sWITCH_TO_ACTIVE();
				sc_boolean SWITCH_TO_ACTIVE_raised;
				/*! Raises the in event 'MOVE_TO_IDLE' that is defined in the interface scope 'SmHandler'. */
				void internal_raise_mOVE_TO_IDLE();
				sc_boolean MOVE_TO_IDLE_raised;
				PmRingtoneHandlerSm * parent;
				void dispatch_event(pmringtonehandlersm_events::SctEvent * event);
				
				
		};
				//! Inner class for SmHandler interface scope operation callbacks.
				class SCI_SmHandler_OCB
				{
					public:
						virtual ~SCI_SmHandler_OCB() = 0;
						
						virtual void sendPlayResponse(pmcore::PmResultMessage result) = 0;
						
						virtual void sendPauseResponse(pmcore::PmResultMessage result) = 0;
						
						virtual void updateRingtoneStatus(pmcore::RingtonePlaybackStateSMType state) = 0;
						
						
				};
				
				/*! Set the working instance of the operation callback interface 'SCI_SmHandler_OCB'. */
				void setSCI_SmHandler_OCB(SCI_SmHandler_OCB* operationCallback);
		
		/*! Returns an instance of the interface class 'SCI_SmHandler'. */
		SCI_SmHandler* getSCI_SmHandler();
		
		//! Inner class for AudioManagerRequest interface scope.
		class SCI_AudioManagerRequest
		{
			public:
				SCI_AudioManagerRequest(PmRingtoneHandlerSm * parent):
					parent(parent)
				{}
				
				
				
				
				
				
			private:
				friend class PmRingtoneHandlerSm;
				PmRingtoneHandlerSm * parent;
				void dispatch_event(pmringtonehandlersm_events::SctEvent * event);
				
				
		};
				//! Inner class for AudioManagerRequest interface scope operation callbacks.
				class SCI_AudioManagerRequest_OCB
				{
					public:
						virtual ~SCI_AudioManagerRequest_OCB() = 0;
						
						virtual void requestRingtoneAudio() = 0;
						
						virtual void playRingtone() = 0;
						
						virtual void pauseRingtone() = 0;
						
						virtual void resumeRingtone() = 0;
						
						
				};
				
				/*! Set the working instance of the operation callback interface 'SCI_AudioManagerRequest_OCB'. */
				void setSCI_AudioManagerRequest_OCB(SCI_AudioManagerRequest_OCB* operationCallback);
		
		/*! Returns an instance of the interface class 'SCI_AudioManagerRequest'. */
		SCI_AudioManagerRequest* getSCI_AudioManagerRequest();
		
		//! Inner class for AudioManagerResponse interface scope.
		class SCI_AudioManagerResponse
		{
			public:
				SCI_AudioManagerResponse(PmRingtoneHandlerSm * parent):
					RINGTONE_CHANNEL_GRANTED_raised(false),
					RINGTONE_CHANNEL_DENIED_raised(false),
					PLAY_AUDIO_SUCCESS_raised(false),
					PLAY_AUDIO_FAILURE_raised(false),
					PAUSE_AUDIO_SUCCESS_raised(false),
					PAUSE_AUDIO_FAILURE_raised(false),
					STOP_AUDIO_SUCCESS_raised(false),
					STOP_AUDIO_FAILURE_raised(false),
					RINGTONE_CHANNEL_RELEASED_raised(false),
					parent(parent)
				{}
				
				/*! Raises the in event 'RINGTONE_CHANNEL_GRANTED' that is defined in the interface scope 'AudioManagerResponse'. */
				void raise_rINGTONE_CHANNEL_GRANTED();
				
				
				/*! Raises the in event 'RINGTONE_CHANNEL_DENIED' that is defined in the interface scope 'AudioManagerResponse'. */
				void raise_rINGTONE_CHANNEL_DENIED();
				
				
				/*! Raises the in event 'PLAY_AUDIO_SUCCESS' that is defined in the interface scope 'AudioManagerResponse'. */
				void raise_pLAY_AUDIO_SUCCESS();
				
				
				/*! Raises the in event 'PLAY_AUDIO_FAILURE' that is defined in the interface scope 'AudioManagerResponse'. */
				void raise_pLAY_AUDIO_FAILURE();
				
				
				/*! Raises the in event 'PAUSE_AUDIO_SUCCESS' that is defined in the interface scope 'AudioManagerResponse'. */
				void raise_pAUSE_AUDIO_SUCCESS();
				
				
				/*! Raises the in event 'PAUSE_AUDIO_FAILURE' that is defined in the interface scope 'AudioManagerResponse'. */
				void raise_pAUSE_AUDIO_FAILURE();
				
				
				/*! Raises the in event 'STOP_AUDIO_SUCCESS' that is defined in the interface scope 'AudioManagerResponse'. */
				void raise_sTOP_AUDIO_SUCCESS();
				
				
				/*! Raises the in event 'STOP_AUDIO_FAILURE' that is defined in the interface scope 'AudioManagerResponse'. */
				void raise_sTOP_AUDIO_FAILURE();
				
				
				/*! Raises the in event 'RINGTONE_CHANNEL_RELEASED' that is defined in the interface scope 'AudioManagerResponse'. */
				void raise_rINGTONE_CHANNEL_RELEASED();
				
				
				
			private:
				friend class PmRingtoneHandlerSm;
				/*! Raises the in event 'RINGTONE_CHANNEL_GRANTED' that is defined in the interface scope 'AudioManagerResponse'. */
				void internal_raise_rINGTONE_CHANNEL_GRANTED();
				sc_boolean RINGTONE_CHANNEL_GRANTED_raised;
				/*! Raises the in event 'RINGTONE_CHANNEL_DENIED' that is defined in the interface scope 'AudioManagerResponse'. */
				void internal_raise_rINGTONE_CHANNEL_DENIED();
				sc_boolean RINGTONE_CHANNEL_DENIED_raised;
				/*! Raises the in event 'PLAY_AUDIO_SUCCESS' that is defined in the interface scope 'AudioManagerResponse'. */
				void internal_raise_pLAY_AUDIO_SUCCESS();
				sc_boolean PLAY_AUDIO_SUCCESS_raised;
				/*! Raises the in event 'PLAY_AUDIO_FAILURE' that is defined in the interface scope 'AudioManagerResponse'. */
				void internal_raise_pLAY_AUDIO_FAILURE();
				sc_boolean PLAY_AUDIO_FAILURE_raised;
				/*! Raises the in event 'PAUSE_AUDIO_SUCCESS' that is defined in the interface scope 'AudioManagerResponse'. */
				void internal_raise_pAUSE_AUDIO_SUCCESS();
				sc_boolean PAUSE_AUDIO_SUCCESS_raised;
				/*! Raises the in event 'PAUSE_AUDIO_FAILURE' that is defined in the interface scope 'AudioManagerResponse'. */
				void internal_raise_pAUSE_AUDIO_FAILURE();
				sc_boolean PAUSE_AUDIO_FAILURE_raised;
				/*! Raises the in event 'STOP_AUDIO_SUCCESS' that is defined in the interface scope 'AudioManagerResponse'. */
				void internal_raise_sTOP_AUDIO_SUCCESS();
				sc_boolean STOP_AUDIO_SUCCESS_raised;
				/*! Raises the in event 'STOP_AUDIO_FAILURE' that is defined in the interface scope 'AudioManagerResponse'. */
				void internal_raise_sTOP_AUDIO_FAILURE();
				sc_boolean STOP_AUDIO_FAILURE_raised;
				/*! Raises the in event 'RINGTONE_CHANNEL_RELEASED' that is defined in the interface scope 'AudioManagerResponse'. */
				void internal_raise_rINGTONE_CHANNEL_RELEASED();
				sc_boolean RINGTONE_CHANNEL_RELEASED_raised;
				PmRingtoneHandlerSm * parent;
				void dispatch_event(pmringtonehandlersm_events::SctEvent * event);
				
				
		};
		
		/*! Returns an instance of the interface class 'SCI_AudioManagerResponse'. */
		SCI_AudioManagerResponse* getSCI_AudioManagerResponse();
		
		
		/*
		 * Functions inherited from StatemachineInterface
		 */
		virtual void init();
		
		virtual void enter();
		
		virtual void exit();
		
		virtual void runCycle();
		
		/*!
		* Checks if the state machine is active (until 2.4.1 this method was used for states).
		* A state machine is active if it has been entered. It is inactive if it has not been entered at all or if it has been exited.
		*/
		virtual sc_boolean isActive() const;
		
		
		/*!
		* Checks if all active states are final. 
		* If there are no active states then the state machine is considered being inactive. In this case this method returns false.
		*/
		virtual sc_boolean isFinal() const;
		
		void setTraceObserver(ysc::TraceObserver<PmRingtoneHandlerSmStates>* tracingcallback);
		
		ysc::TraceObserver<PmRingtoneHandlerSmStates>* getTraceObserver();
		
		/*! Checks if the specified state is active (until 2.4.1 the used method for states was calles isActive()). */
		sc_boolean isStateActive(PmRingtoneHandlerSmStates state) const;
		
		
		
	protected:
		
		
	private:
		PmRingtoneHandlerSm(const PmRingtoneHandlerSm &rhs);
		PmRingtoneHandlerSm& operator=(const PmRingtoneHandlerSm&);
		
		
		//! the maximum number of orthogonal states defines the dimension of the state configuration vector.
		static const sc_ushort maxOrthogonalStates = 1;
		
		
		ysc::TraceObserver<PmRingtoneHandlerSmStates>* ifaceTraceObserver;
		
		PmRingtoneHandlerSmStates stateConfVector[maxOrthogonalStates];
		
		sc_ushort stateConfVectorPosition;
		
		SCI_UserAction ifaceUserAction;
		SCI_UserAction_OCB* ifaceUserAction_OCB;
		SCI_SmHandler ifaceSmHandler;
		SCI_SmHandler_OCB* ifaceSmHandler_OCB;
		SCI_AudioManagerRequest ifaceAudioManagerRequest;
		SCI_AudioManagerRequest_OCB* ifaceAudioManagerRequest_OCB;
		SCI_AudioManagerResponse ifaceAudioManagerResponse;
		
		// prototypes of all internal functions
		
		void effect_Main_region_RingtoneHandler_tr2();
		void effect_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_tr3();
		void effect_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_tr0();
		void enact_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_RequestStreaming();
		void enact_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingStarted();
		void enact_Main_region_RingtoneHandler_ringtonehandler_region_WaitForRingtoneChannelAcquisition();
		void enact_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone();
		void enact_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_RequestStopAudio();
		void enseq_Main_region_RingtoneHandler_default();
		void enseq_Main_region_RingtoneHandler_ringtonehandler_region_Idle_default();
		void enseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_EntryToWaitForPlayRespToReplay();
		void enseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_default();
		void enseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_RequestStreaming_default();
		void enseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingStarted_default();
		void enseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingPaused_default();
		void enseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_Replay_default();
		void enseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_WaitForPlayRespToReplay_default();
		void enseq_Main_region_RingtoneHandler_ringtonehandler_region_WaitForRingtoneChannelAcquisition_default();
		void enseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_PlayAfterStopResp();
		void enseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_default();
		void enseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_PlayAfterStopAudioResponse_default();
		void enseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_StopAfterStopAudioResponse_default();
		void enseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_RequestStopAudio_default();
		void enseq_Main_region_default();
		void enseq_Main_region_RingtoneHandler_ringtonehandler_region_default();
		void enseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_default();
		void enseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_EntryToWaitForPlayRespToReplay();
		void enseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_default();
		void enseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_PlayAfterStopResp();
		void exseq_Main_region_RingtoneHandler();
		void exseq_Main_region_RingtoneHandler_ringtonehandler_region_Idle();
		void exseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone();
		void exseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_RequestStreaming();
		void exseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingStarted();
		void exseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingPaused();
		void exseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_Replay();
		void exseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_WaitForPlayRespToReplay();
		void exseq_Main_region_RingtoneHandler_ringtonehandler_region_WaitForRingtoneChannelAcquisition();
		void exseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone();
		void exseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_PlayAfterStopAudioResponse();
		void exseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_StopAfterStopAudioResponse();
		void exseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_RequestStopAudio();
		void exseq_Main_region();
		void exseq_Main_region_RingtoneHandler_ringtonehandler_region();
		void exseq_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region();
		void exseq_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region();
		void react_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region__entry_Default();
		void react_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_EntryToWaitForPlayRespToReplay();
		void react_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region__entry_Default();
		void react_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_PlayAfterStopResp();
		void react_Main_region_RingtoneHandler_ringtonehandler_region__entry_Default();
		void react_Main_region__entry_Default();
		void react_Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_MoveToIdle();
		void react_Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_MoveToIdle();
		void react_Main_region_RingtoneHandler_ringtonehandler_region_ToIdle();
		sc_boolean react();
		sc_boolean Main_region_RingtoneHandler_react(const sc_boolean try_transition);
		sc_boolean Main_region_RingtoneHandler_ringtonehandler_region_Idle_react(const sc_boolean try_transition);
		sc_boolean Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_react(const sc_boolean try_transition);
		sc_boolean Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_RequestStreaming_react(const sc_boolean try_transition);
		sc_boolean Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingStarted_react(const sc_boolean try_transition);
		sc_boolean Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_StreamingPaused_react(const sc_boolean try_transition);
		sc_boolean Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_Replay_react(const sc_boolean try_transition);
		sc_boolean Main_region_RingtoneHandler_ringtonehandler_region_PlayRingtone_playringtone_region_WaitForPlayRespToReplay_react(const sc_boolean try_transition);
		sc_boolean Main_region_RingtoneHandler_ringtonehandler_region_WaitForRingtoneChannelAcquisition_react(const sc_boolean try_transition);
		sc_boolean Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_react(const sc_boolean try_transition);
		sc_boolean Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_PlayAfterStopAudioResponse_react(const sc_boolean try_transition);
		sc_boolean Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_StopAfterStopAudioResponse_react(const sc_boolean try_transition);
		sc_boolean Main_region_RingtoneHandler_ringtonehandler_region_StoppingRingtone_StoppingRingtone_region_RequestStopAudio_react(const sc_boolean try_transition);
		void clearInEvents();
		void clearOutEvents();
		
		
		pmringtonehandlersm_events::SctEvent* getNextEvent();
		void dispatch_event(pmringtonehandlersm_events::SctEvent * event);
		std::deque<pmringtonehandlersm_events::SctEvent*> inEventQueue;
		sc_boolean isRunningCycle;
		
		
};


inline PmRingtoneHandlerSm::SCI_UserAction_OCB::~SCI_UserAction_OCB() {}
inline PmRingtoneHandlerSm::SCI_SmHandler_OCB::~SCI_SmHandler_OCB() {}
inline PmRingtoneHandlerSm::SCI_AudioManagerRequest_OCB::~SCI_AudioManagerRequest_OCB() {}


#endif /* PMRINGTONEHANDLERSM_H_ */
