/* *
 * @file RVCSm.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Generated code from RVCSm.sct
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 * */

#ifndef RVCSM_H_
#define RVCSM_H_


#include <deque>
#include "sc_types.h"
#include "StatemachineInterface.h"
#include "scTracing.h"

/*! \file Header of the state machine 'RVCSm'.
*/


#ifndef SCT_EVENTS_RVCSM_H
#define SCT_EVENTS_RVCSM_H
#ifndef SC_INVALID_EVENT_VALUE
#define SC_INVALID_EVENT_VALUE 0
#endif

namespace rvcsm_events
{
typedef enum  {
	rvcsm_invalid_event = SC_INVALID_EVENT_VALUE,
	SCI_AgVolCtrlUpdate_VOLUME_CHANGED,
	SCI_AudioManagerVolCtrlUpdate_VOLUME_CHANGED,
	SCI_VolCtrlTimerUpdate_TIMER_CALLBACK
} RVCSmEventName;

class SctEvent
{
	public:
		SctEvent(RVCSmEventName name) : name(name){}
		virtual ~SctEvent(){}
		const RVCSmEventName name;
		
};
		
template <typename T>
class TypedSctEvent : public SctEvent
{
	public:
		TypedSctEvent(RVCSmEventName name, T value) :
			SctEvent(name),
			value(value)
			{}
		virtual ~TypedSctEvent(){}
		const T value;
};

class SctEvent_SCI_AgVolCtrlUpdate_VOLUME_CHANGED : public SctEvent
{
	public:
		SctEvent_SCI_AgVolCtrlUpdate_VOLUME_CHANGED(RVCSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_AudioManagerVolCtrlUpdate_VOLUME_CHANGED : public SctEvent
{
	public:
		SctEvent_SCI_AudioManagerVolCtrlUpdate_VOLUME_CHANGED(RVCSmEventName name) : SctEvent(name){};
};
class SctEvent_SCI_VolCtrlTimerUpdate_TIMER_CALLBACK : public SctEvent
{
	public:
		SctEvent_SCI_VolCtrlTimerUpdate_TIMER_CALLBACK(RVCSmEventName name) : SctEvent(name){};
};

}
#endif /* SCT_EVENTS_RVCSM_H */


/*! Define indices of states in the StateConfVector */
#define SCVI_MAIN_REGION_RVCHANDLER 0
#define SCVI_MAIN_REGION_RVCHANDLER_RVCHANDLER_REGION_IDLE 0
#define SCVI_MAIN_REGION_RVCHANDLER_RVCHANDLER_REGION_SETINPROGRESSTOAG 0
#define SCVI_MAIN_REGION_RVCHANDLER_RVCHANDLER_REGION_SETINPROGRESSTOAUDIO 0
#define SCVI_MAIN_REGION_RVCHANDLER_RVCHANDLER_REGION_WAITFORAGRESPONSE 0
#define SCVI_MAIN_REGION_RVCHANDLER_RVCHANDLER_REGION_WAITFORAUDIORESPONSE 0


class RVCSm : public StatemachineInterface
{
	public:
		RVCSm();
		
		~RVCSm();
		
		/*! Enumeration of all states */ 
		typedef enum
		{
			RVCSm_last_state,
			Main_region_RVCHandler,
			Main_region_RVCHandler_RVCHandler_region_Idle,
			Main_region_RVCHandler_RVCHandler_region_SetInProgressToAg,
			Main_region_RVCHandler_RVCHandler_region_SetInProgressToAudio,
			Main_region_RVCHandler_RVCHandler_region_WaitForAgResponse,
			Main_region_RVCHandler_RVCHandler_region_WaitForAudioResponse
		} RVCSmStates;
					
		static const sc_integer numStates = 6;
		
		//! Inner class for AgVolCtrlUpdate interface scope.
		class SCI_AgVolCtrlUpdate
		{
			public:
				SCI_AgVolCtrlUpdate(RVCSm * parent):
					VOLUME_CHANGED_raised(false),
					parent(parent)
				{}
				
				/*! Raises the in event 'VOLUME_CHANGED' that is defined in the interface scope 'AgVolCtrlUpdate'. */
				void raise_vOLUME_CHANGED();
				
				
				
			private:
				friend class RVCSm;
				/*! Raises the in event 'VOLUME_CHANGED' that is defined in the interface scope 'AgVolCtrlUpdate'. */
				void internal_raise_vOLUME_CHANGED();
				sc_boolean VOLUME_CHANGED_raised;
				RVCSm * parent;
				void dispatch_event(rvcsm_events::SctEvent * event);
				
				
		};
		
		/*! Returns an instance of the interface class 'SCI_AgVolCtrlUpdate'. */
		SCI_AgVolCtrlUpdate* getSCI_AgVolCtrlUpdate();
		
		//! Inner class for AudioManagerVolCtrlUpdate interface scope.
		class SCI_AudioManagerVolCtrlUpdate
		{
			public:
				SCI_AudioManagerVolCtrlUpdate(RVCSm * parent):
					VOLUME_CHANGED_raised(false),
					parent(parent)
				{}
				
				/*! Raises the in event 'VOLUME_CHANGED' that is defined in the interface scope 'AudioManagerVolCtrlUpdate'. */
				void raise_vOLUME_CHANGED();
				
				
				
			private:
				friend class RVCSm;
				/*! Raises the in event 'VOLUME_CHANGED' that is defined in the interface scope 'AudioManagerVolCtrlUpdate'. */
				void internal_raise_vOLUME_CHANGED();
				sc_boolean VOLUME_CHANGED_raised;
				RVCSm * parent;
				void dispatch_event(rvcsm_events::SctEvent * event);
				
				
		};
		
		/*! Returns an instance of the interface class 'SCI_AudioManagerVolCtrlUpdate'. */
		SCI_AudioManagerVolCtrlUpdate* getSCI_AudioManagerVolCtrlUpdate();
		
		//! Inner class for AudioManagerVolCtrlIf interface scope.
		class SCI_AudioManagerVolCtrlIf
		{
			public:
				SCI_AudioManagerVolCtrlIf(RVCSm * parent):
					parent(parent)
				{}
				
				
				
			private:
				friend class RVCSm;
				RVCSm * parent;
				void dispatch_event(rvcsm_events::SctEvent * event);
				
				
		};
				//! Inner class for AudioManagerVolCtrlIf interface scope operation callbacks.
				class SCI_AudioManagerVolCtrlIf_OCB
				{
					public:
						virtual ~SCI_AudioManagerVolCtrlIf_OCB() = 0;
						
						virtual void setAmSpeakerVolume() = 0;
						
						
				};
				
				/*! Set the working instance of the operation callback interface 'SCI_AudioManagerVolCtrlIf_OCB'. */
				void setSCI_AudioManagerVolCtrlIf_OCB(SCI_AudioManagerVolCtrlIf_OCB* operationCallback);
		
		/*! Returns an instance of the interface class 'SCI_AudioManagerVolCtrlIf'. */
		SCI_AudioManagerVolCtrlIf* getSCI_AudioManagerVolCtrlIf();
		
		//! Inner class for AgVolCtrlIf interface scope.
		class SCI_AgVolCtrlIf
		{
			public:
				SCI_AgVolCtrlIf(RVCSm * parent):
					parent(parent)
				{}
				
				
				
			private:
				friend class RVCSm;
				RVCSm * parent;
				void dispatch_event(rvcsm_events::SctEvent * event);
				
				
		};
				//! Inner class for AgVolCtrlIf interface scope operation callbacks.
				class SCI_AgVolCtrlIf_OCB
				{
					public:
						virtual ~SCI_AgVolCtrlIf_OCB() = 0;
						
						virtual void setAgSpeakerVolume() = 0;
						
						
				};
				
				/*! Set the working instance of the operation callback interface 'SCI_AgVolCtrlIf_OCB'. */
				void setSCI_AgVolCtrlIf_OCB(SCI_AgVolCtrlIf_OCB* operationCallback);
		
		/*! Returns an instance of the interface class 'SCI_AgVolCtrlIf'. */
		SCI_AgVolCtrlIf* getSCI_AgVolCtrlIf();
		
		//! Inner class for VolCtrlTimerUpdate interface scope.
		class SCI_VolCtrlTimerUpdate
		{
			public:
				SCI_VolCtrlTimerUpdate(RVCSm * parent):
					TIMER_CALLBACK_raised(false),
					parent(parent)
				{}
				
				/*! Raises the in event 'TIMER_CALLBACK' that is defined in the interface scope 'VolCtrlTimerUpdate'. */
				void raise_tIMER_CALLBACK();
				
				
				
			private:
				friend class RVCSm;
				/*! Raises the in event 'TIMER_CALLBACK' that is defined in the interface scope 'VolCtrlTimerUpdate'. */
				void internal_raise_tIMER_CALLBACK();
				sc_boolean TIMER_CALLBACK_raised;
				RVCSm * parent;
				void dispatch_event(rvcsm_events::SctEvent * event);
				
				
		};
		
		/*! Returns an instance of the interface class 'SCI_VolCtrlTimerUpdate'. */
		SCI_VolCtrlTimerUpdate* getSCI_VolCtrlTimerUpdate();
		
		//! Inner class for VolCtrlTimerIf interface scope.
		class SCI_VolCtrlTimerIf
		{
			public:
				SCI_VolCtrlTimerIf(RVCSm * parent):
					parent(parent)
				{}
				
				
				
				
			private:
				friend class RVCSm;
				RVCSm * parent;
				void dispatch_event(rvcsm_events::SctEvent * event);
				
				
		};
				//! Inner class for VolCtrlTimerIf interface scope operation callbacks.
				class SCI_VolCtrlTimerIf_OCB
				{
					public:
						virtual ~SCI_VolCtrlTimerIf_OCB() = 0;
						
						virtual void startTimer() = 0;
						
						virtual void stopTimer() = 0;
						
						
				};
				
				/*! Set the working instance of the operation callback interface 'SCI_VolCtrlTimerIf_OCB'. */
				void setSCI_VolCtrlTimerIf_OCB(SCI_VolCtrlTimerIf_OCB* operationCallback);
		
		/*! Returns an instance of the interface class 'SCI_VolCtrlTimerIf'. */
		SCI_VolCtrlTimerIf* getSCI_VolCtrlTimerIf();
		
		//! Inner class for UserActionVolCtrl interface scope.
		class SCI_UserActionVolCtrl
		{
			public:
				SCI_UserActionVolCtrl(RVCSm * parent):
					parent(parent)
				{}
				
				
			private:
				friend class RVCSm;
				RVCSm * parent;
				void dispatch_event(rvcsm_events::SctEvent * event);
				
				
		};
		
		/*! Returns an instance of the interface class 'SCI_UserActionVolCtrl'. */
		SCI_UserActionVolCtrl* getSCI_UserActionVolCtrl();
		
		//! Inner class for VolCtrlSmHandlerIf interface scope.
		class SCI_VolCtrlSmHandlerIf
		{
			public:
				SCI_VolCtrlSmHandlerIf(RVCSm * parent):
					parent(parent)
				{}
				
				
				
			private:
				friend class RVCSm;
				RVCSm * parent;
				void dispatch_event(rvcsm_events::SctEvent * event);
				
				
		};
				//! Inner class for VolCtrlSmHandlerIf interface scope operation callbacks.
				class SCI_VolCtrlSmHandlerIf_OCB
				{
					public:
						virtual ~SCI_VolCtrlSmHandlerIf_OCB() = 0;
						
						virtual void handleIdle() = 0;
						
						
				};
				
				/*! Set the working instance of the operation callback interface 'SCI_VolCtrlSmHandlerIf_OCB'. */
				void setSCI_VolCtrlSmHandlerIf_OCB(SCI_VolCtrlSmHandlerIf_OCB* operationCallback);
		
		/*! Returns an instance of the interface class 'SCI_VolCtrlSmHandlerIf'. */
		SCI_VolCtrlSmHandlerIf* getSCI_VolCtrlSmHandlerIf();
		
		
		/*
		 * Functions inherited from StatemachineInterface
		 */
		virtual void init();
		
		virtual void enter();
		
		virtual void exit();
		
		virtual void runCycle();
		
		/*!
		* Checks if the state machine is active (until 2.4.1 this method was used for states).
		* A state machine is active if it has been entered. It is inactive if it has not been entered at all or if it has been exited.
		*/
		virtual sc_boolean isActive() const;
		
		
		/*!
		* Checks if all active states are final. 
		* If there are no active states then the state machine is considered being inactive. In this case this method returns false.
		*/
		virtual sc_boolean isFinal() const;
		
		void setTraceObserver(ysc::TraceObserver<RVCSmStates>* tracingcallback);
		
		ysc::TraceObserver<RVCSmStates>* getTraceObserver();
		
		/*! Checks if the specified state is active (until 2.4.1 the used method for states was calles isActive()). */
		sc_boolean isStateActive(RVCSmStates state) const;
		
		
		
	protected:
		
		
	private:
		RVCSm(const RVCSm &rhs);
		RVCSm& operator=(const RVCSm&);
		
		
		//! the maximum number of orthogonal states defines the dimension of the state configuration vector.
		static const sc_ushort maxOrthogonalStates = 1;
		
		
		ysc::TraceObserver<RVCSmStates>* ifaceTraceObserver;
		
		RVCSmStates stateConfVector[maxOrthogonalStates];
		
		sc_ushort stateConfVectorPosition;
		
		SCI_AgVolCtrlUpdate ifaceAgVolCtrlUpdate;
		SCI_AudioManagerVolCtrlUpdate ifaceAudioManagerVolCtrlUpdate;
		SCI_AudioManagerVolCtrlIf ifaceAudioManagerVolCtrlIf;
		SCI_AudioManagerVolCtrlIf_OCB* ifaceAudioManagerVolCtrlIf_OCB;
		SCI_AgVolCtrlIf ifaceAgVolCtrlIf;
		SCI_AgVolCtrlIf_OCB* ifaceAgVolCtrlIf_OCB;
		SCI_VolCtrlTimerUpdate ifaceVolCtrlTimerUpdate;
		SCI_VolCtrlTimerIf ifaceVolCtrlTimerIf;
		SCI_VolCtrlTimerIf_OCB* ifaceVolCtrlTimerIf_OCB;
		SCI_UserActionVolCtrl ifaceUserActionVolCtrl;
		SCI_VolCtrlSmHandlerIf ifaceVolCtrlSmHandlerIf;
		SCI_VolCtrlSmHandlerIf_OCB* ifaceVolCtrlSmHandlerIf_OCB;
		
		// prototypes of all internal functions
		
		void enact_Main_region_RVCHandler_RVCHandler_region_Idle();
		void enact_Main_region_RVCHandler_RVCHandler_region_SetInProgressToAg();
		void enact_Main_region_RVCHandler_RVCHandler_region_SetInProgressToAudio();
		void exact_Main_region_RVCHandler_RVCHandler_region_WaitForAgResponse();
		void exact_Main_region_RVCHandler_RVCHandler_region_WaitForAudioResponse();
		void enseq_Main_region_RVCHandler_default();
		void enseq_Main_region_RVCHandler_RVCHandler_region_Idle_default();
		void enseq_Main_region_RVCHandler_RVCHandler_region_SetInProgressToAg_default();
		void enseq_Main_region_RVCHandler_RVCHandler_region_SetInProgressToAudio_default();
		void enseq_Main_region_RVCHandler_RVCHandler_region_WaitForAgResponse_default();
		void enseq_Main_region_RVCHandler_RVCHandler_region_WaitForAudioResponse_default();
		void enseq_Main_region_default();
		void enseq_Main_region_RVCHandler_RVCHandler_region_default();
		void exseq_Main_region_RVCHandler();
		void exseq_Main_region_RVCHandler_RVCHandler_region_Idle();
		void exseq_Main_region_RVCHandler_RVCHandler_region_SetInProgressToAg();
		void exseq_Main_region_RVCHandler_RVCHandler_region_SetInProgressToAudio();
		void exseq_Main_region_RVCHandler_RVCHandler_region_WaitForAgResponse();
		void exseq_Main_region_RVCHandler_RVCHandler_region_WaitForAudioResponse();
		void exseq_Main_region();
		void exseq_Main_region_RVCHandler_RVCHandler_region();
		void react_Main_region_RVCHandler_RVCHandler_region__entry_Default();
		void react_Main_region__entry_Default();
		sc_boolean react();
		sc_boolean Main_region_RVCHandler_react(const sc_boolean try_transition);
		sc_boolean Main_region_RVCHandler_RVCHandler_region_Idle_react(const sc_boolean try_transition);
		sc_boolean Main_region_RVCHandler_RVCHandler_region_SetInProgressToAg_react(const sc_boolean try_transition);
		sc_boolean Main_region_RVCHandler_RVCHandler_region_SetInProgressToAudio_react(const sc_boolean try_transition);
		sc_boolean Main_region_RVCHandler_RVCHandler_region_WaitForAgResponse_react(const sc_boolean try_transition);
		sc_boolean Main_region_RVCHandler_RVCHandler_region_WaitForAudioResponse_react(const sc_boolean try_transition);
		void clearInEvents();
		void clearOutEvents();
		
		
		rvcsm_events::SctEvent* getNextEvent();
		void dispatch_event(rvcsm_events::SctEvent * event);
		std::deque<rvcsm_events::SctEvent*> inEventQueue;
		sc_boolean isRunningCycle;
		
		
};


inline RVCSm::SCI_AudioManagerVolCtrlIf_OCB::~SCI_AudioManagerVolCtrlIf_OCB() {}
inline RVCSm::SCI_AgVolCtrlIf_OCB::~SCI_AgVolCtrlIf_OCB() {}
inline RVCSm::SCI_VolCtrlTimerIf_OCB::~SCI_VolCtrlTimerIf_OCB() {}
inline RVCSm::SCI_VolCtrlSmHandlerIf_OCB::~SCI_VolCtrlSmHandlerIf_OCB() {}


#endif /* RVCSM_H_ */
