/**
 * @file PmCoreIfMessage.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the PmCoreIfMessage class method
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details This file provides the Base implementation for all request and response messages in PmCore
 *
 * @ingroup PmCore
 */

#include "PmCoreIfMessage.h"
#include "PmAppTrace.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/PmCoreIfMessage.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#endif
#endif

namespace pmcore
{

void swap(PmCoreIfMessage& first, PmCoreIfMessage& second)
{
   using std::swap;

   swap(first._messageId, second._messageId);
   swap(first._act, second._act);
   swap(first._origin, second._origin);
}

PmCoreIfMessage::PmCoreIfMessage(IN const PmCoreIfMsgId messageId, IN const ActType act,
      IN const PmCoreIfMsgOrigin origin) :
      _messageId(messageId), _act(act), _origin(origin)
{
   ETG_TRACE_USR4(("PmCoreIfMessage: [0x%p] being created", (void*) this));
}

PmCoreIfMessage::PmCoreIfMessage(IN const PmCoreIfMessage& other) :
            _messageId(other._messageId),
            _act(other._act),
            _origin(other._origin)
{
   ETG_TRACE_USR4(("PmCoreIfMessage: [0x%p] being copy-created", (void*) this));
}

PmCoreIfMessage::~PmCoreIfMessage()
{
   ETG_TRACE_USR4(("~PmCoreIfMessage: [0x%p] being destroyed", (void*) this));
}

//lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
PmCoreIfMessage& PmCoreIfMessage::operator=(PmCoreIfMessage other)
{
   swap(*this, other);

   return *this;
}

bool PmCoreIfMessage::operator==(const PmCoreIfMessage& rhs) const
{
   return ((this->_messageId == rhs._messageId)
         && (this->_act == rhs._act)
         && (this->_origin == rhs._origin));
}

void PmCoreIfMessage::traceMessage(void) const
{
   ETG_TRACE_USR4(("traceMessage: [0x%p] MsgId = %d, Act = %u, Origin = %d",
         (const void*) this, ETG_CENUM(PmCoreIfMsgId, _messageId), _act, ETG_CENUM(PmCoreIfMsgOrigin, _origin)));
}

}
