/**
 * @file WaitingModeState.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the WaitingModeState class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#ifndef WaitingModeState_h
#define WaitingModeState_h

#include "PmInterfaceTypesInternal.h"

namespace pmcore
{
   class WaitingModeState
   {
   public:
      /**
       * Constructor of WaitingModeState class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      WaitingModeState();

      /**
       * Parameterized constructor of WaitingModeState class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      WaitingModeState(const WaitingModeStateType waitingModeState);

      /**
       * Copy constructor of WaitingModeState class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      WaitingModeState(const WaitingModeState& other);

      /**
       * Destructor of WaitingModeState class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      ~WaitingModeState();

      /**
       * Friend function used when copying the object.
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      friend void swap(WaitingModeState& first, WaitingModeState& second);

      /**
       * Overloading '=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      WaitingModeState& operator=(WaitingModeState other);

      /**
       * Overloading '==' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator==(const WaitingModeState& rhs) const;

      /**
       * Overloading '!=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator!=(const WaitingModeState& rhs) const;

      WaitingModeStateType _waitingModeState; /**< waiting mode state type*/
   };

} // namespace pmcore

#endif // WatingModeStateType_h
