/**
 * @file WaitingModeFilePath.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the WaitingModeFilePath class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#include "WaitingModeFilePath.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/WaitingModeFilePath.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#endif
#endif

namespace pmcore
{
   WaitingModeFilePath::WaitingModeFilePath() : _filePathNB(""),_filePathWB("")
   {
   }

   WaitingModeFilePath::WaitingModeFilePath(const FilePath filePathNB, const FilePath filePathWB) :
      _filePathNB(filePathNB),_filePathWB(filePathWB)
   {
   }

   WaitingModeFilePath::WaitingModeFilePath(const WaitingModeFilePath& other) :
      _filePathNB(other._filePathNB),_filePathWB(other._filePathWB)
   {
   }

   WaitingModeFilePath::~WaitingModeFilePath()
   {
   }

   void swap(WaitingModeFilePath& first, WaitingModeFilePath& second)
   {
      using std::swap;

      swap(first._filePathNB, second._filePathNB);
      swap(first._filePathWB, second._filePathWB);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   WaitingModeFilePath& WaitingModeFilePath::operator=(WaitingModeFilePath other)
   {
      swap(*this, other);

      return *this;
   }

   bool WaitingModeFilePath::operator==(const WaitingModeFilePath& rhs) const
   {
      return ((this->_filePathNB == rhs._filePathNB)
            && (this->_filePathWB == rhs._filePathWB));
   }

   bool WaitingModeFilePath::operator!=(const WaitingModeFilePath& rhs) const
   {
      return (!((this->_filePathNB == rhs._filePathNB)
            && (this->_filePathWB == rhs._filePathWB)));
   }
}
