/**
 * @file VoiceRecognitionStatus.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the VoiceRecognitionStatus class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#ifndef VoiceRecognitionStatus_h
#define VoiceRecognitionStatus_h

#include "PmInterfaceTypesInternal.h"

namespace pmcore
{
   class VoiceRecognitionStatus
   {
   public:
      /**
       * Constructor of VoiceRecognitionStatus class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      VoiceRecognitionStatus();

      /**
       * Parameterized Constructor of VoiceRecognitionStatus class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      VoiceRecognitionStatus(const VRStatus vrStatus);

      /**
       * Copy Constructor of VoiceRecognitionStatus class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      VoiceRecognitionStatus(const VoiceRecognitionStatus& other);

      /**
       * Destructor of VoiceRecognitionStatus class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      ~VoiceRecognitionStatus();

      /**
       * Friend function used when copying the object.
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      friend void swap(VoiceRecognitionStatus& first, VoiceRecognitionStatus& second);

      /**
       * Overloading '=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      VoiceRecognitionStatus& operator=(VoiceRecognitionStatus other);

      /**
       * Overloading '==' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator==(const VoiceRecognitionStatus& rhs) const;

      /**
       * Overloading '!=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator!=(const VoiceRecognitionStatus& rhs) const;

      VRStatus _vrStatus; /**< voice recognition status */
   };

} // namespace pmcore

#endif // VoiceRecognitionStatus_h
