/**
 * @file VoiceMail.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the VoiceMail class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#ifndef VoiceMail_h
#define VoiceMail_h

#include "PmInterfaceTypesInternal.h"
#include <vector>

namespace pmcore
{
   class VoiceMail
   {
   public:
      /**
       * Constructor of VoiceMail class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      VoiceMail();

      /**
       * Parameterized Constructor of VoiceMail class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      VoiceMail(const TelephoneNumber telephoneNumber, const NumberType numberType);

      /**
       * Copy Constructor of VoiceMail class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      VoiceMail(const VoiceMail& other);

      /**
       * Destructor of VoiceMail class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      ~VoiceMail();

      /**
       * Friend function used when copying the object.
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      friend void swap(VoiceMail& first, VoiceMail& second);

      /**
       * Overloading '=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      VoiceMail& operator=(VoiceMail other);

      /**
       * Overloading '==' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator==(const VoiceMail& rhs) const;

      /**
       * Overloading '!=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator!=(const VoiceMail& rhs) const;

      TelephoneNumber _telephoneNumber; /**< telephone number */
      NumberType      _numberType;      /**< number type of voice mail */
   };

   typedef std::vector<VoiceMail> VoiceMailList; /**< voice mail list */

} // namespace pmcore

#endif // VoiceMail_h
