/**
 * @file VoiceMail.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the VoiceMail class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#include "VoiceMail.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/VoiceMail.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#endif
#endif

namespace pmcore
{
   VoiceMail::VoiceMail() : _telephoneNumber(""), _numberType(NUMBER_TYPE_UNKNOWN)
   {
   }

   VoiceMail::VoiceMail(const TelephoneNumber telephoneNumber, const NumberType numberType) :
      _telephoneNumber(telephoneNumber), _numberType(numberType)
   {
   }

   VoiceMail::VoiceMail(const VoiceMail& other) :
      _telephoneNumber(other._telephoneNumber), _numberType(other._numberType)
   {
   }

   VoiceMail::~VoiceMail()
   {
   }

   void swap(VoiceMail& first, VoiceMail& second)
   {
      using std::swap;

      swap(first._telephoneNumber, second._telephoneNumber);
      swap(first._numberType, second._numberType);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   VoiceMail& VoiceMail::operator=(VoiceMail other)
   {
      swap(*this, other);

      return *this;
   }

   bool VoiceMail::operator==(const VoiceMail& rhs) const
   {
      return ((this->_telephoneNumber == rhs._telephoneNumber)
            && (this->_numberType == rhs._numberType));
   }

   bool VoiceMail::operator!=(const VoiceMail& rhs) const
   {
      return (!((this->_telephoneNumber == rhs._telephoneNumber)
            && (this->_numberType == rhs._numberType)));
   }
}
