/**
 * @file VehicleConfiguration.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the VehicleConfiguration class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#ifndef VehicleConfiguration_h
#define VehicleConfiguration_h

#include "PmInterfaceTypesInternal.h"

namespace pmcore
{

/**
 * enum- Device Connection Status
 */

class VehicleConfiguration
{
public:
   /**
    * Constructor of VehicleConfiguration class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   VehicleConfiguration();

   /**
    * Destructor of VehicleConfiguration class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   ~VehicleConfiguration();
   /**
    * Parameterized constructor of VehicleConfiguration class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   VehicleConfiguration(const BdAddress BtAddress, const VehicleDetails vendorIDSource,
         const VehicleDetails vendorID, const VehicleDetails productID, const VehicleDetails productVersion);

   /**
    * Copy constructor of VehicleConfiguration class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   VehicleConfiguration(const VehicleConfiguration& other);
   /**
    * Friend function used when copying the object.
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   friend void swap(VehicleConfiguration& first, VehicleConfiguration& second);

   /**
    * Overloading '=' operator
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
   VehicleConfiguration& operator=(VehicleConfiguration other);

   /**
    * Overloading '==' operator
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   bool operator==(const VehicleConfiguration& rhs) const;

   /**
    * Overloading '!=' operator
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   bool operator!=(const VehicleConfiguration& rhs) const;
   /**
    * Prints the value of VehicleConfiguration class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */

   BdAddress      _vehicleBTAddress;
   VehicleDetails _vendorIDSource;
   VehicleDetails _vendorID;
   VehicleDetails _productID;
   VehicleDetails _productVersion;
};

} // namespace pmcore

#endif // #define VehicleConfiguration_h
