/**
 * @file SystemWideRingtonesList.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the SystemWideRingtonesList class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#ifndef SystemWideRingtonesList_h
#define SystemWideRingtonesList_h

#include "SystemRingtones.h"

namespace pmcore
{
   class SystemWideRingtonesList
   {
   public:
      /**
       * Constructor of SystemWideRingtonesList class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      SystemWideRingtonesList();

      /**
       * Parameterized Constructor of SystemWideRingtonesList class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      SystemWideRingtonesList(const RingtoneId activeSystemRingtoneId, const SystemRingtonesList systemRingtonesList);

      /**
       * Copy Constructor of SystemWideRingtonesList class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      SystemWideRingtonesList(const SystemWideRingtonesList& other);

      /**
       * Destructor of SystemWideRingtonesList class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      ~SystemWideRingtonesList();

      /**
       * Friend function used when copying the object.
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      friend void swap(SystemWideRingtonesList& first, SystemWideRingtonesList& second);

      /**
       * Overloading '=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      SystemWideRingtonesList& operator=(SystemWideRingtonesList other);

      /**
       * Overloading '==' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator==(const SystemWideRingtonesList& rhs) const;

      /**
       * Overloading '!=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator!=(const SystemWideRingtonesList& rhs) const;

      RingtoneId          _activeSystemRingtoneId; /**< active system ringtone id */
      SystemRingtonesList _systemRingtonesList;    /**< system ringtones list */
   };

} // namespace pmcore

#endif // SystemWideRingtonesList_h
