/**
 * @file SystemRingtones.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the SystemRingtones class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#ifndef SystemRingtones_h
#define SystemRingtones_h

#include "PmInterfaceTypesInternal.h"
#include <vector>

namespace pmcore
{
   class SystemRingtones
   {
   public:
      /**
       * Constructor of SystemRingtones class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      SystemRingtones();

      /**
       * Parameterized Constructor of SystemRingtones class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      SystemRingtones(const RingtoneId ringtoneId, const RingtoneName ringtoneName);

      /**
       * Copy Constructor of SystemRingtones class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      SystemRingtones(const SystemRingtones& other);

      /**
       * Destructor of SystemRingtones class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      ~SystemRingtones();

      /**
       * Friend function used when copying the object.
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      friend void swap(SystemRingtones& first, SystemRingtones& second);

      /**
       * Overloading '=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      SystemRingtones& operator=(SystemRingtones other);

      /**
       * Overloading '==' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator==(const SystemRingtones& rhs) const;

      /**
       * Overloading '!=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator!=(const SystemRingtones& rhs) const;

      RingtoneId _ringtoneId;     /**< ringtone id */
      RingtoneName _ringtoneName; /**< ringtone name */
   };

   typedef std::vector<SystemRingtones> SystemRingtonesList; /**< system ringtones list */

} // namespace pmcore

#endif // SystemRingtones_h
