/**
 * @file SystemRingtones.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the SystemRingtones class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#include "SystemRingtones.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/SystemRingtones.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#endif
#endif

namespace pmcore
{
   SystemRingtones::SystemRingtones() : _ringtoneId(RINGTONE_ID_DEFAULT), _ringtoneName("")
   {
   }

   SystemRingtones::SystemRingtones(const RingtoneId ringtoneId, const RingtoneName ringtoneName) :
      _ringtoneId(ringtoneId), _ringtoneName(ringtoneName)
   {
   }

   SystemRingtones::SystemRingtones(const SystemRingtones& other) :
      _ringtoneId(other._ringtoneId), _ringtoneName(other._ringtoneName)
   {
   }

   SystemRingtones::~SystemRingtones()
   {
   }

   void swap(SystemRingtones& first, SystemRingtones& second)
   {
      using std::swap;

      swap(first._ringtoneId, second._ringtoneId);
      swap(first._ringtoneName, second._ringtoneName);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   SystemRingtones& SystemRingtones::operator=(SystemRingtones other)
   {
      swap(*this, other);

      return *this;
   }

   bool SystemRingtones::operator==(const SystemRingtones& rhs) const
   {
      return ((this->_ringtoneId == rhs._ringtoneId)
            && (this->_ringtoneName == rhs._ringtoneName));
   }

   bool SystemRingtones::operator!=(const SystemRingtones& rhs) const
   {
      return (!((this->_ringtoneId == rhs._ringtoneId)
            && (this->_ringtoneName == rhs._ringtoneName)));
   }
}
