/**
 * @file SuppressRingtoneOnOffList.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the SuppressRingtoneOnOffList class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#ifndef SuppressRingtoneOnOffList_h
#define SuppressRingtoneOnOffList_h

#include "PmInterfaceTypesInternal.h"

namespace pmcore
{
   class SuppressRingtoneOnOffList
   {
   public:
      /**
       * Constructor of SuppressRingtoneOnOffList class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      SuppressRingtoneOnOffList();

      /**
       * Parameterized Constructor of SuppressRingtoneOnOffList class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      SuppressRingtoneOnOffList(const SuppressRingtoneOnOffListMap suppressRingtoneOnOffList);

      /**
       * Copy Constructor of SuppressRingtoneOnOffList class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      SuppressRingtoneOnOffList(const SuppressRingtoneOnOffList& other);

      /**
       * Destructor of SuppressRingtoneOnOffList class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      ~SuppressRingtoneOnOffList();

      /**
       * Friend function used when copying the object.
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      friend void swap(SuppressRingtoneOnOffList& first, SuppressRingtoneOnOffList& second);

      /**
       * Overloading '=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      SuppressRingtoneOnOffList& operator=(SuppressRingtoneOnOffList other);

      /**
       * Overloading '==' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator==(const SuppressRingtoneOnOffList& rhs) const;

      /**
       * Overloading '!=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator!=(const SuppressRingtoneOnOffList& rhs) const;

      SuppressRingtoneOnOffListMap _suppressRingtoneOnOffList; /**< suppress ringtone on off list map */
   };

} // namespace pmcore

#endif // SuppressRingtoneOnOffList_h
