/**
 * @file SuppressRingtoneOnOffList.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the SuppressRingtoneOnOffList class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#include "SuppressRingtoneOnOffList.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/SuppressRingtoneOnOffList.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#endif
#endif

namespace pmcore
{
   SuppressRingtoneOnOffList::SuppressRingtoneOnOffList() : _suppressRingtoneOnOffList()
   {
   }

   SuppressRingtoneOnOffList::SuppressRingtoneOnOffList(const SuppressRingtoneOnOffListMap suppressRingtoneOnOffList) :
      _suppressRingtoneOnOffList(suppressRingtoneOnOffList)
   {
   }

   SuppressRingtoneOnOffList::SuppressRingtoneOnOffList(const SuppressRingtoneOnOffList& other) :
      _suppressRingtoneOnOffList(other._suppressRingtoneOnOffList)
   {
   }

   SuppressRingtoneOnOffList::~SuppressRingtoneOnOffList()
   {
   }

   void swap(SuppressRingtoneOnOffList& first, SuppressRingtoneOnOffList& second)
   {
      using std::swap;

      swap(first._suppressRingtoneOnOffList, second._suppressRingtoneOnOffList);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   SuppressRingtoneOnOffList& SuppressRingtoneOnOffList::operator=(SuppressRingtoneOnOffList other)
   {
      swap(*this, other);

      return *this;
   }

   bool SuppressRingtoneOnOffList::operator==(const SuppressRingtoneOnOffList& rhs) const
   {
      return (this->_suppressRingtoneOnOffList == rhs._suppressRingtoneOnOffList);
   }

   bool SuppressRingtoneOnOffList::operator!=(const SuppressRingtoneOnOffList& rhs) const
   {
      return (!(this->_suppressRingtoneOnOffList == rhs._suppressRingtoneOnOffList));
   }
}
