/**
 * @file RingtoneMuteState.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the RingtoneMuteState class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#include "RingtoneMuteState.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/RingtoneMuteState.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#endif
#endif

namespace pmcore
{
   RingtoneMuteState::RingtoneMuteState() : _ringtoneMuteState(false)
   {
   }

   RingtoneMuteState::RingtoneMuteState(const MuteState ringtoneMuteState) : _ringtoneMuteState(ringtoneMuteState)
   {
   }

   RingtoneMuteState::RingtoneMuteState(const RingtoneMuteState& other) : _ringtoneMuteState(other._ringtoneMuteState)
   {
   }

   RingtoneMuteState::~RingtoneMuteState()
   {
   }

   void swap(RingtoneMuteState& first, RingtoneMuteState& second)
   {
      using std::swap;

      swap(first._ringtoneMuteState, second._ringtoneMuteState);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   RingtoneMuteState& RingtoneMuteState::operator=(RingtoneMuteState other)
   {
      swap(*this, other);

      return *this;
   }

   bool RingtoneMuteState::operator==(const RingtoneMuteState& rhs) const
   {
      return ((this->_ringtoneMuteState == rhs._ringtoneMuteState));
   }

   bool RingtoneMuteState::operator!=(const RingtoneMuteState& rhs) const
   {
      return (!(this->_ringtoneMuteState == rhs._ringtoneMuteState));
   }
}
