/**
 * @file PmResult.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the PmResult class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#include "PmResult.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/PmResult.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#endif
#endif

namespace pmcore
{
   PmResult::PmResult() : _pmResultCode(PM_RESULT_OK), _pmResultMessage("")
   {
   }

   PmResult::PmResult(const PmResultCode pmResultCode, const PmResultMessage pmResultMessage) :
         _pmResultCode(pmResultCode), _pmResultMessage(pmResultMessage)
   {
   }

   PmResult::PmResult(const PmResult& other) :
         _pmResultCode(other._pmResultCode), _pmResultMessage(other._pmResultMessage)
   {
   }

   PmResult::~PmResult()
   {
   }

   void swap(PmResult& first, PmResult& second)
   {
      using std::swap;

      swap(first._pmResultCode, second._pmResultCode);
      swap(first._pmResultMessage, second._pmResultMessage);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   PmResult& PmResult::operator=(PmResult other)
   {
      swap(*this, other);

      return *this;
   }

   bool PmResult::operator==(const PmResult& rhs) const
   {
      return ((this->_pmResultCode == rhs._pmResultCode)
            && (this->_pmResultMessage == rhs._pmResultMessage));
   }

   bool PmResult::operator!=(const PmResult& rhs) const
   {
      return (!((this->_pmResultCode == rhs._pmResultCode)
            && (this->_pmResultMessage == rhs._pmResultMessage)));
   }
}
