/**
 * @file PmCoreSmTypes.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file used to switch between target build and state chart simulation
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#ifndef PmCoreSmTypes_h
#define PmCoreSmTypes_h

#ifndef DONT_INCLUDE_TARGET_BUILD_PATH

#include "PmResult.h"
#include "PmAudioManagerTypesInternal.h"
using namespace pmcore;
using namespace pmaudiomanager;

#else

#include <string>

typedef enum
{
   SCO_NOT_ESTABLISHED  = 0x00u,
   SCO_PAUSED,
   SCO_NARROWBAND,
   SCO_WIDEBAND,
   SCO_NARROWBAND_SIRI,
   SCO_WIDEBAND_SIRI,
   SCO_DEFAULT          = 0xFFu
} SCOStatusEnumType;

typedef enum
{
   VR_SESSION_IDLE     = 0x00u,
   VR_SESSION_ACTIVE,
   VR_SESSION_STARTING,
   VR_SESSION_ENDING
} VRStatusEnumType;

typedef enum
{
   EXT_VR_SESSION_IDLE     = 0x00u,
   EXT_VR_SESSION_READY,
   EXT_VR_SESSION_ACTIVE,
} ExternalVRStatusEnumType;

typedef enum
{
   HFP_CALL     = 0x00u,
   AUDIO_CHANNEL_RELEASED
} VRInterruptedReason;

typedef enum
{
   WAITING_MODE_IDLE       = 0x00u,
   WAITING_MODE_ACTIVE     = 0x01u,
   WAITING_MODE_STARTING   = 0x02u,
   WAITING_MODE_STOPPING   = 0x03u
} WaitingModeStateEnumType;

typedef enum
{
   PHONE_AUDIO_CHANNEL_IDLE           = 0x00u,

   PHONE_CHANNEL_REQUESTED,
   PHONE_CHANNEL_ALLOCATED,
   PHONE_CHANNEL_NOT_ALLOCATED,
   PHONE_START_STREAMING_REQUESTED,
   PHONE_START_STREAMING_SUCCESS,
   PHONE_START_STREAMING_FAILED,
   PHONE_STOP_STREAMING_REQUESTED,
   PHONE_STOP_STREAMING_SUCCESS,
   PHONE_STOP_STREAMING_FAILED,
   PHONE_PAUSE_STREAMING_REQUESTED,
   PHONE_PAUSE_STREAMING_SUCCESS,
   PHONE_PAUSE_STREAMING_FAILED,

   RINGTONE_CHANNEL_REQUESTED,
   RINGTONE_CHANNEL_ALLOCATED,
   RINGTONE_CHANNEL_NOT_ALLOCATED,
   RINGTONE_START_STREAMING_REQUESTED,
   RINGTONE_START_STREAMING_SUCCESS,
   RINGTONE_START_STREAMING_FAILED,
   RINGTONE_STOP_STREAMING_REQUESTED,
   RINGTONE_STOP_STREAMING_SUCCESS,
   RINGTONE_STOP_STREAMING_FAILED,
   RINGTONE_PAUSE_STREAMING_REQUESTED,
   RINGTONE_PAUSE_STREAMING_SUCCESS,
   RINGTONE_PAUSE_STREAMING_FAILED,

   WAITINGMODE_CHANNEL_REQUESTED,
   WAITINGMODE_CHANNEL_ALLOCATED,
   WAITINGMODE_CHANNEL_NOT_ALLOCATED,
   WAITINGMODE_START_STREAMING_REQUESTED,
   WAITINGMODE_START_STREAMING_SUCCESS,
   WAITINGMODE_START_STREAMING_FAILED,
   WAITINGMODE_STOP_STREAMING_REQUESTED,
   WAITINGMODE_STOP_STREAMING_SUCCESS,
   WAITINGMODE_STOP_STREAMING_FAILED,
   WAITINGMODE_PAUSE_STREAMING_REQUESTED,
   WAITINGMODE_PAUSE_STREAMING_SUCCESS,
   WAITINGMODE_PAUSE_STREAMING_FAILED

}PmCorePhoneAudioState;

typedef enum
{
   NO_AUDIO_PROCESS_PENDING       = 0x00u,
   WAIT_FOR_PAUSE_AUDIO_RESPONSE  = 0x01u,
   STOP_AUDIO_NOT_CALLED          = 0x02u,
   WAIT_FOR_STOP_AUDIO_RESPONSE   = 0x03u

} StopAudioStateEnumType;

typedef enum
{
   DIAL_CALL_ERROR              = 0x00u,
   SPEED_DIAL_ERROR,
   ACCEPT_CALL_ERROR,
   HOLD_AND_ACCEPT_ERROR,
   RELEASE_AND_ACCEPT_ERROR,
   RELEASE_AND_SWAP_ERROR,
   SWAP_CALL_ERROR,
   CONFERENCE_CALL_ERROR,
   SPLIT_CALL_ERROR,
   HANGUP_MULTIPARTY_ERROR,
   TRANSFER_CALL_ERROR,
   TRANSFER_CALL_ERROR_FOR_SWITCH_TO_PASSIVE,
   HANGUP_CALL_ERROR,
   HANGUP_ALL_CALL_ERROR,
   RINGTONE_CHANNEL_DENIED_ERROR,
   PHONE_CHANNEL_DENIED_FOR_ACCEPT_ERROR,
   PHONE_CHANNEL_DENIED_FOR_RINGTONE_ERROR,
   PHONE_CHANNEL_DENIED_FOR_TRANSFER_AUDIO_ERROR,
   ECNR_FAILED_FOR_TRANSFER_AUDIO_ERROR,
   WAITINGMODE_CHANNEL_DENIED_ERROR,
   ACCEPT_CALL_FAILED_TO_START_WAITINGMODE_ERROR,
   START_WAITINGMODE_FAILED_ERROR,
   STOP_WAITINGMODE_FAILED_ERROR
} SmErrorEnumType;

typedef enum
{
   AM_UNKNOWN = 0UL,     /**< Unknown source, default value*/
   AM_VEHICLERINGTONE,   /**< For playing the vehicle ringtone or the playable audio file */
   AM_PHONEAUDIO,        /**< For phone call audio streaming */
   AM_WAITINGMODE,       /**< For waiting mode tone to be streamed for the far end device */
   AM_VOICERECOGNITION,  /**< Stream the voice recognition audio */
   AM_ALERTTONE          /**< For the Alert tone to be played */
}AudioChannel;

/**
 * PmInterface result code
 */
typedef enum
{
   PM_RESULT_OK = 0,
   PM_RESULT_ERR_GENERAL,
   PM_RESULT_ERR_DEVICE_NOT_EXIST,
   PM_RESULT_ERR_INVALID_PARAMETER,
   PM_RESULT_ERR_NOT_IMPLEMENTED,
   PM_RESULT_ERR_FAILED,
   PM_RESULT_ERR_TIMEOUT,
   PM_RESULT_ERR_HFP
} PmResultCode;

typedef enum
{
   RT_SM_NOT_PLAYING,
   RT_SM_PREPARING_CH,
   RT_SM_STARTING_TO_PLAY,
   RT_SM_PLAYING,
   RT_SM_STOPPING
}RingtonePlaybackStateSMType;

typedef bool          StartStop;

typedef unsigned char SCOStatus;

typedef unsigned char CallCount;

typedef std::string   EnhancedVRFeature;

typedef std::string   PmResultMessage;

typedef unsigned char PlayCount;

typedef signed short int RingtoneId;

typedef void* voidptr;


#endif // DONT_INCLUDE_TARGET_BUILD_PATH

#endif // PmCoreSmTypes_h
