/**
 * @file PmCoreInternalTypeConversion.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the PmCore internal type conversion functions
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup pmcore
 */

#ifndef PmCoreInternalTypeConversion_h
#define PmCoreInternalTypeConversion_h

#include "BTSResult.h"
#include "PmResult.h"

namespace pmcore
{

   /**
    * This method is used to convert the BTSResult to PmResult type
    *
    * @param[in] btsResult - BTS Result type
    * @param[out] pmResult - PmResult type
    * @param[in,out]
    *
    * @return void
    */
   void convertBTSResultToPmResult(IN const BTSResult& btsResult, OUT PmResult& pmResult);

} //pmcore

#endif // BTSResult_h
