/**
 * @file PmCoreInternalTypeConversion.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the PmCore internal type conversion functions
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup pmcore
 */

#include "PmCoreInternalTypeConversion.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/PmCoreInternalTypeConversion.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#endif
#endif

namespace pmcore
{

   void convertBTSResultToPmResult(IN const BTSResult& btsResult, OUT PmResult& pmResult)
   {
      if(BTS_REQ_SUCCESS == btsResult._btsRequestResult)
      {
         pmResult._pmResultCode = PM_RESULT_OK;
      }
      else if(BTS_REQ_FAILED == btsResult._btsRequestResult)
      {
         switch(btsResult._errorCode)
         {
            case ::ccdbusif::evolution::ERROR_ORG_OFONO_ERROR_INVALIDARGUMENTS:
            case ::ccdbusif::evolution::ERROR_ORG_OFONO_ERROR_INVALIDFORMAT:
               pmResult._pmResultCode = PM_RESULT_ERR_INVALID_PARAMETER;
               break;
            case ::ccdbusif::evolution::ERROR_ORG_OFONO_ERROR_NOTIMPLEMENTED:
               pmResult._pmResultCode = PM_RESULT_ERR_NOT_IMPLEMENTED;
               break;
            case ::ccdbusif::evolution::ERROR_ORG_OFONO_ERROR_FAILED:
               pmResult._pmResultCode = PM_RESULT_ERR_FAILED;
               break;
            case ::ccdbusif::evolution::ERROR_ORG_OFONO_ERROR_INPROGRESS:
            case ::ccdbusif::evolution::ERROR_ORG_OFONO_ERROR_NOTFOUND:
            case ::ccdbusif::evolution::ERROR_ORG_OFONO_ERROR_NOTACTIVE:
            case ::ccdbusif::evolution::ERROR_ORG_OFONO_ERROR_NOTSUPPORTED:
            case ::ccdbusif::evolution::ERROR_ORG_OFONO_ERROR_NOTAVAILABLE:
               pmResult._pmResultCode = PM_RESULT_ERR_GENERAL; //TODO
               break;
            case ::ccdbusif::evolution::ERROR_ORG_OFONO_ERROR_TIMEDOUT:
               pmResult._pmResultCode = PM_RESULT_ERR_TIMEOUT;
               break;
            case ::ccdbusif::evolution::ERROR_ORG_OFONO_ERROR_INUSE:
               pmResult._pmResultCode = PM_RESULT_ERR_GENERAL; //TODO
               break;
            case ::ccdbusif::evolution::ERROR_ORG_OFONO_ERROR_HFP:
               pmResult._pmResultCode = PM_RESULT_ERR_HFP;
               break;
            case ::ccdbusif::evolution::ERROR_ORG_OFONO_ERROR_INTERFACEREMOVED:
            case ::ccdbusif::evolution::ERROR_ORG_OFONO_ERROR_ACCESSDENIED:
               pmResult._pmResultCode = PM_RESULT_ERR_GENERAL; //TODO
               break;
            default:
               pmResult._pmResultCode = PM_RESULT_ERR_GENERAL;
               break;
         }

         pmResult._pmResultMessage = btsResult._errorMessage;
      }
      else
      {
         //something wrong
      }
   }

} // pmcore
