/**
 * @file PhoneCallAudioActive.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the PhoneCallAudioActive class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#ifndef PhoneCallAudioActive_h
#define PhoneCallAudioActive_h

#include "PmInterfaceTypesInternal.h"

namespace pmcore
{
   class PhoneCallAudioActive
   {
   public:
      /**
       * Constructor of PhoneCallAudioActive class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      PhoneCallAudioActive();

      /**
       * Parameterized Constructor of PhoneCallAudioActive class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      PhoneCallAudioActive(const AudioActiveStatus status);

      /**
       * Copy Constructor of PhoneCallAudioActive class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      PhoneCallAudioActive(const PhoneCallAudioActive& other);

      /**
       * Destructor of PhoneCallAudioActive class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      ~PhoneCallAudioActive();

      /**
       * Friend function used when copying the object.
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      friend void swap(PhoneCallAudioActive& first, PhoneCallAudioActive& second);

      /**
       * Overloading '=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      PhoneCallAudioActive& operator=(PhoneCallAudioActive other);

      /**
       * Overloading '==' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator==(const PhoneCallAudioActive& rhs) const;

      /**
       * Overloading '!=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator!=(const PhoneCallAudioActive& rhs) const;

      AudioActiveStatus _status; /**< phone call audio active status */
   };

} // namespace pmcore

#endif // PhoneCallAudioActive_h
