/**
 * @file PhoneCallAudioActive.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the PhoneCallAudioActive class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#include "PhoneCallAudioActive.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/PhoneCallAudioActive.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#endif
#endif

namespace pmcore
{
   PhoneCallAudioActive::PhoneCallAudioActive() : _status(false)
   {
   }

   PhoneCallAudioActive::PhoneCallAudioActive(const AudioActiveStatus status) : _status(status)
   {
   }

   PhoneCallAudioActive::PhoneCallAudioActive(const PhoneCallAudioActive& other) : _status(other._status)
   {
   }

   PhoneCallAudioActive::~PhoneCallAudioActive()
   {
   }

   void swap(PhoneCallAudioActive& first, PhoneCallAudioActive& second)
   {
      using std::swap;

      swap(first._status, second._status);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   PhoneCallAudioActive& PhoneCallAudioActive::operator=(PhoneCallAudioActive other)
   {
      swap(*this, other);

      return *this;
   }

   bool PhoneCallAudioActive::operator==(const PhoneCallAudioActive& rhs) const
   {
      return ((this->_status == rhs._status));
   }

   bool PhoneCallAudioActive::operator!=(const PhoneCallAudioActive& rhs) const
   {
      return (!(this->_status == rhs._status));
   }
}
