/**
 * @file NetworkStatus.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the NetworkStatus class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#ifndef NetworkStatus_h
#define NetworkStatus_h

#include "PmInterfaceTypesInternal.h"

namespace pmcore
{
   class NetworkStatus
   {
   public:
      /**
       * Constructor of NetworkStatus class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      NetworkStatus();

      /**
       * Parameterized Constructor of NetworkStatus class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      NetworkStatus(const NetworkStatusType networkStatus);

      /**
       * Copy Constructor of NetworkStatus class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      NetworkStatus(const NetworkStatus& other);

      /**
       * Destructor of NetworkStatus class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      ~NetworkStatus();

      /**
       * Friend function used when copying the object.
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      friend void swap(NetworkStatus& first, NetworkStatus& second);

      /**
       * Overloading '=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      NetworkStatus& operator=(NetworkStatus other);

      /**
       * Overloading '==' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator==(const NetworkStatus& rhs) const;

      /**
       * Overloading '!=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator!=(const NetworkStatus& rhs) const;

      NetworkStatusType _networkStatus; /**< network status */
   };

} // namespace pmcore

#endif // NetworkStatus_h
