/**
 * @file NetworkOperator.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the NetworkOperator class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#ifndef NetworkOperator_h
#define NetworkOperator_h

#include "PmInterfaceTypesInternal.h"

namespace pmcore
{
   class NetworkOperator
   {
   public:
      /**
       * Constructor of NetworkOperator class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      NetworkOperator();

      /**
       * Parameterized Constructor of NetworkOperator class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      NetworkOperator(const NetworkOperatorType networkOperator);

      /**
       * Copy Constructor of NetworkOperator class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      NetworkOperator(const NetworkOperator& other);

      /**
       * Destructor of NetworkOperator class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      ~NetworkOperator();

      /**
       * Friend function used when copying the object.
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      friend void swap(NetworkOperator& first, NetworkOperator& second);

      /**
       * Overloading '=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      NetworkOperator& operator=(NetworkOperator other);

      /**
       * Overloading '==' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator==(const NetworkOperator& rhs) const;

      /**
       * Overloading '!=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator!=(const NetworkOperator& rhs) const;

      NetworkOperatorType _networkOperator; /**< network operator */
   };

} // namespace pmcore

#endif // NetworkOperator_h
